/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.web.facebook;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.security.oauth.facebook.FacebookAccessTokenContext;
import org.gatein.security.oauth.facebook.GateInFacebookProcessor;
import org.gatein.security.oauth.social.FacebookPrincipal;
import org.gatein.security.oauth.spi.InteractionState;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.utils.OAuthUtils;
import org.gatein.security.oauth.web.OAuthProviderFilter;

public class FacebookFilter
extends OAuthProviderFilter<FacebookAccessTokenContext> {
    @Override
    protected OAuthProviderType<FacebookAccessTokenContext> getOAuthProvider() {
        return this.getOauthProvider("FACEBOOK", FacebookAccessTokenContext.class);
    }

    @Override
    protected void initInteraction(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().removeAttribute("_authState");
        request.getSession().removeAttribute("_verificationState");
    }

    @Override
    protected OAuthPrincipal<FacebookAccessTokenContext> getOAuthPrincipal(HttpServletRequest request, HttpServletResponse response, InteractionState<FacebookAccessTokenContext> interactionState) {
        FacebookAccessTokenContext accessTokenContext = (FacebookAccessTokenContext)interactionState.getAccessTokenContext();
        FacebookPrincipal principal = ((GateInFacebookProcessor)this.getOauthProviderProcessor()).getPrincipal(accessTokenContext);
        String avatarURL = ((GateInFacebookProcessor)this.getOauthProviderProcessor()).getAvatar(accessTokenContext);
        if (principal == null) {
            this.log.error((Object)"Principal was null");
            return null;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Finished Facebook OAuth2 flow with state: " + interactionState));
            this.log.trace((Object)("Facebook accessToken: " + principal.getAccessToken()));
        }
        OAuthPrincipal oauthPrincipal = OAuthUtils.convertFacebookPrincipalToOAuthPrincipal((FacebookPrincipal)principal, (String)avatarURL, this.getOAuthProvider(), (FacebookAccessTokenContext)accessTokenContext);
        return oauthPrincipal;
    }

    @Override
    protected String obtainCustomScopeIfAvailable(HttpServletRequest httpRequest) {
        String customScope = super.obtainCustomScopeIfAvailable(httpRequest);
        if (customScope != null) {
            StringBuilder result = new StringBuilder();
            String[] scopes = customScope.split(" ");
            boolean first = true;
            for (String scope : scopes) {
                if (scope.equals("installed")) continue;
                if (!first) {
                    result.append(" ");
                }
                first = false;
                result.append(scope);
            }
            customScope = result.toString();
        }
        return customScope;
    }
}

