/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.web.openid;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.security.oauth.openid.OpenIdAccessTokenContext;
import org.gatein.security.oauth.openid.OpenIdProcessor;
import org.gatein.security.oauth.spi.InteractionState;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.utils.OAuthUtils;
import org.gatein.security.oauth.web.OAuthProviderFilter;
import org.json.JSONObject;

public class OpenIdFilter
extends OAuthProviderFilter<OpenIdAccessTokenContext> {
    @Override
    protected OAuthProviderType<OpenIdAccessTokenContext> getOAuthProvider() {
        return this.getOauthProvider("OPENID", OpenIdAccessTokenContext.class);
    }

    @Override
    protected void initInteraction(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().removeAttribute("_authState");
        request.getSession().removeAttribute("_verificationState");
    }

    @Override
    protected OAuthPrincipal<OpenIdAccessTokenContext> getOAuthPrincipal(HttpServletRequest request, HttpServletResponse response, InteractionState<OpenIdAccessTokenContext> interactionState) {
        OpenIdAccessTokenContext accessTokenContext = (OpenIdAccessTokenContext)interactionState.getAccessTokenContext();
        JSONObject userInfo = ((OpenIdProcessor)this.getOauthProviderProcessor()).obtainUserInfo(accessTokenContext);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Obtained tokenResponse from OpenId authentication: " + accessTokenContext));
        }
        return OAuthUtils.convertOpenIdInfoToOAuthPrincipal((JSONObject)userInfo, (OpenIdAccessTokenContext)accessTokenContext, this.getOAuthProvider());
    }
}

