/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public abstract class BaseActivityProcessorPlugin
extends BaseComponentPlugin
implements ActivityProcessor {
    protected int priority;
    private static final Log LOG = ExoLogger.getLogger(BaseActivityProcessorPlugin.class);
    public static final String TEMPLATE_PARAM_TO_PROCESS = "registeredKeysForProcessor";
    public static final String TEMPLATE_PARAM_LIST_DELIM = "\\|";

    public BaseActivityProcessorPlugin(InitParams params) {
        try {
            this.priority = Integer.valueOf(params.getValueParam("priority").getValue());
        }
        catch (Exception e) {
            this.priority = 5;
            LOG.warn((Object)("an <value-param> 'priority' of type int is recommanded for component " + this.getClass()));
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public List<String> getTemplateParamKeysToFilter(ExoSocialActivity activity) {
        Map<String, String> templateParams = activity.getTemplateParams();
        ArrayList<String> keys = new ArrayList<String>();
        if (templateParams != null && templateParams.containsKey(TEMPLATE_PARAM_TO_PROCESS)) {
            String[] templateParamKeys;
            for (String key : templateParamKeys = activity.getTemplateParams().get(TEMPLATE_PARAM_TO_PROCESS).split(TEMPLATE_PARAM_LIST_DELIM)) {
                if (key.endsWith("\\")) {
                    key = key.replace("\\", "");
                }
                if (!templateParams.containsKey(key.replace("\\", ""))) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    @Override
    public abstract void processActivity(ExoSocialActivity var1);
}

