/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class PostActivitySpaceStreamPlugin
extends BaseNotificationPlugin {
    public static final String ID = "PostActivitySpaceStreamPlugin";

    public PostActivitySpaceStreamPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        try {
            ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
            String originalTitle = (String)ctx.value(SocialNotificationUtils.ORIGINAL_TITLE);
            Space space = Utils.getSpaceService().getSpaceByPrettyName(activity.getStreamOwner());
            String poster = Utils.getUserId(activity.getPosterId());
            return NotificationInfo.instance().key(this.getId()).with(SocialNotificationUtils.POSTER.getKey(), poster).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).with(SocialNotificationUtils.ORIGINAL_TITLE.getKey(), originalTitle).to(Utils.getDestinataires(activity, space)).end();
        }
        catch (Exception e) {
            ctx.setException((Throwable)e);
            return null;
        }
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        if (!Utils.isActivityNotificationsEnabled(activity.getType())) {
            return false;
        }
        Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", activity.getStreamOwner(), false);
        return spaceIdentity != null && !activity.getPosterId().equals(spaceIdentity.getId());
    }
}

