/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.configuration;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.service.configuration.DomainService;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.addons.gamification.storage.DomainStorage;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class DomainServiceImpl
implements DomainService {
    private static final Log LOG = ExoLogger.getLogger(DomainServiceImpl.class);
    protected final DomainStorage domainStorage;
    protected final ListenerService listenerService;
    protected final IdentityManager identityManager;
    protected final SpaceService spaceService;
    protected final FileService fileService;

    public DomainServiceImpl(DomainStorage domainStorage, ListenerService listenerService, IdentityManager identityManager, SpaceService spaceService, FileService fileService) {
        this.domainStorage = domainStorage;
        this.listenerService = listenerService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.fileService = fileService;
    }

    @Override
    public List<DomainDTO> getDomainsByFilter(DomainFilter domainFilter, String username, int offset, int limit) {
        ArrayList<DomainDTO> domains = new ArrayList<DomainDTO>();
        if (!Utils.isSuperManager(username)) {
            List spaceIds = this.spaceService.getMemberSpacesIds(username, 0, -1);
            if (spaceIds.isEmpty()) {
                return Collections.emptyList();
            }
            List userSpaceIds = spaceIds.stream().map(Long::parseLong).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(domainFilter.getSpacesIds())) {
                userSpaceIds = (List)CollectionUtils.intersection(userSpaceIds, domainFilter.getSpacesIds());
            }
            domainFilter.setSpacesIds(userSpaceIds);
        }
        List<Long> domainIds = domainFilter.isSortByBudget() ? this.domainStorage.findHighestBudgetDomainIdsBySpacesIds(domainFilter.getSpacesIds(), offset, limit) : this.domainStorage.getDomainsByFilter(domainFilter, offset, limit);
        for (Long domainId : domainIds) {
            DomainDTO domainDTO = this.getDomainById(domainId);
            domains.add(domainDTO);
        }
        return domains;
    }

    @Override
    public List<DomainDTO> getEnabledDomains() {
        return this.domainStorage.getEnabledDomains();
    }

    @Override
    public DomainDTO getDomainByTitle(String domainTitle) {
        if (StringUtils.isBlank((CharSequence)domainTitle)) {
            throw new IllegalArgumentException("domainTitle has to be not null");
        }
        return this.domainStorage.getDomainByTitle(domainTitle);
    }

    @Override
    public int countDomains(DomainFilter domainFilter, String username) {
        if (!Utils.isSuperManager(username)) {
            List spaceIds = this.spaceService.getMemberSpacesIds(username, 0, -1);
            if (spaceIds.isEmpty()) {
                return 0;
            }
            List userSpaceIds = spaceIds.stream().map(Long::parseLong).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(domainFilter.getSpacesIds())) {
                userSpaceIds = (List)CollectionUtils.intersection(userSpaceIds, domainFilter.getSpacesIds());
            }
            domainFilter.setSpacesIds(userSpaceIds);
        }
        return this.domainStorage.countDomains(domainFilter);
    }

    @Override
    public DomainDTO createDomain(DomainDTO domain, Identity aclIdentity) throws IllegalAccessException {
        if (domain == null) {
            throw new IllegalArgumentException("domain is mandatory");
        }
        if (domain.getId() != 0L) {
            throw new IllegalArgumentException("domain id must be equal to 0");
        }
        if (!this.canAddDomain(aclIdentity)) {
            throw new IllegalAccessException("The user is not authorized to create a domain");
        }
        return this.createDomain(domain, aclIdentity.getUserId());
    }

    @Override
    public DomainDTO createDomain(DomainDTO domain) {
        return this.createDomain(domain, IdentityConstants.SYSTEM);
    }

    @Override
    public DomainDTO updateDomain(DomainDTO domain, Identity aclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        DomainDTO storedDomain = this.domainStorage.getDomainById(domain.getId());
        if (storedDomain == null) {
            throw new ObjectNotFoundException("domain doesn't exist");
        }
        if (!this.isDomainOwner(domain.getId(), aclIdentity)) {
            throw new IllegalAccessException("The user is not authorized to update domain " + domain);
        }
        if (domain.equals(storedDomain)) {
            return storedDomain;
        }
        if (storedDomain.isDeleted()) {
            throw new IllegalAccessException("Domain is already marked as deleted");
        }
        domain.setLastModifiedBy(aclIdentity.getUserId());
        domain.setLastModifiedDate(Utils.toRFC3339Date(new Date(System.currentTimeMillis())));
        domain.setType(storedDomain.getType());
        domain.setCreatedBy(storedDomain.getCreatedBy());
        domain.setCreatedDate(storedDomain.getCreatedDate());
        domain.setDeleted(storedDomain.isDeleted());
        domain.setCoverFileId(storedDomain.getCoverFileId());
        domain = this.domainStorage.saveDomain(domain);
        if (storedDomain.isEnabled() && !domain.isEnabled()) {
            this.broadcast("exo.gamification.domain.disable", domain, aclIdentity.getUserId());
        } else if (!storedDomain.isEnabled() && domain.isEnabled()) {
            this.broadcast("exo.gamification.domain.enable", domain, aclIdentity.getUserId());
        }
        return domain;
    }

    @Override
    public DomainDTO deleteDomainById(long domainId, Identity aclIdentity) throws IllegalAccessException, ObjectNotFoundException {
        String date = Utils.toRFC3339Date(new Date(System.currentTimeMillis()));
        DomainDTO domain = this.domainStorage.getDomainById(domainId);
        if (domain == null) {
            throw new ObjectNotFoundException("domain doesn't exist");
        }
        if (!this.isDomainOwner(domainId, aclIdentity)) {
            throw new IllegalAccessException("The user is not authorized to delete the domain");
        }
        domain.setDeleted(true);
        domain.setLastModifiedDate(date);
        domain = this.domainStorage.saveDomain(domain);
        this.broadcast("exo.gamification.domain.delete", domain, aclIdentity.getUserId());
        return domain;
    }

    @Override
    public DomainDTO getDomainById(long domainId) {
        if (domainId <= 0L) {
            throw new IllegalArgumentException("domain id has to be positive integer");
        }
        return this.domainStorage.getDomainById(domainId);
    }

    @Override
    public InputStream getFileDetailAsStream(long domainId) throws ObjectNotFoundException {
        DomainDTO domain = this.domainStorage.getDomainById(domainId);
        if (domain == null) {
            throw new ObjectNotFoundException("Domain with id " + domainId + " doesn't exist");
        }
        if (domain.getCoverFileId() == 0L) {
            throw new ObjectNotFoundException("Domain with id " + domainId + " doesn't have a coverdId");
        }
        try {
            FileItem fileItem = this.fileService.getFile(domain.getCoverFileId());
            return fileItem == null || fileItem.getFileInfo() == null ? null : fileItem.getAsStream();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving image with id {}", new Object[]{domainId, e});
            return null;
        }
    }

    @Override
    public boolean canAddDomain(Identity aclIdentity) {
        return aclIdentity != null && Utils.isSuperManager(aclIdentity.getUserId());
    }

    @Override
    public boolean isDomainOwner(long domainId, Identity aclIdentity) {
        org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(aclIdentity.getUserId());
        DomainDTO domain = this.domainStorage.getDomainById(domainId);
        return domain != null && Utils.isProgramOwner(domain.getAudienceId(), domain.getOwners(), userIdentity);
    }

    private void broadcast(String eventName, DomainDTO domain, String userName) {
        try {
            this.listenerService.broadcast(eventName, (Object)domain, (Object)userName);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting operation '{}' on domain {}. The operation '{}' isn't interrupted.", new Object[]{eventName, domain, e});
        }
    }

    private DomainDTO createDomain(DomainDTO domain, String username) {
        if (StringUtils.isBlank((CharSequence)domain.getType())) {
            domain.setType(EntityType.AUTOMATIC.name());
        }
        domain.setCreatedBy(username);
        domain.setCreatedDate(Utils.toRFC3339Date(new Date(System.currentTimeMillis())));
        domain.setLastModifiedBy(username);
        domain.setLastModifiedDate(Utils.toRFC3339Date(new Date(System.currentTimeMillis())));
        return this.domainStorage.saveDomain(domain);
    }
}

