/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.mapper;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityType;
import org.exoplatform.addons.gamification.utils.Utils;

public class DomainMapper {
    private DomainMapper() {
    }

    public static List<DomainDTO> domainsToDomainDTOs(List<DomainEntity> domains) {
        return domains.stream().filter(Objects::nonNull).map(DomainMapper::domainEntityToDomainDTO).collect(Collectors.toList());
    }

    public static DomainEntity domainDTOToDomainEntity(DomainDTO domainDTO) {
        if (domainDTO == null) {
            return null;
        }
        DomainEntity domain = new DomainEntity();
        domain.setId(domainDTO.getId());
        domain.setTitle(domainDTO.getTitle());
        domain.setDescription(domainDTO.getDescription());
        domain.setCreatedBy(domainDTO.getCreatedBy());
        domain.setLastModifiedBy(domainDTO.getLastModifiedBy());
        domain.setDeleted(domainDTO.isDeleted());
        domain.setEnabled(domainDTO.isEnabled());
        if (domainDTO.getAudienceId() > 0L) {
            domain.setAudienceId(domainDTO.getAudienceId());
        }
        if (domainDTO.getCreatedDate() != null) {
            domain.setCreatedDate(Utils.parseRFC3339Date(domainDTO.getCreatedDate()));
        }
        domain.setLastModifiedDate(Utils.parseRFC3339Date(domainDTO.getLastModifiedDate()));
        domain.setPriority(domainDTO.getPriority());
        domain.setBudget(domainDTO.getBudget());
        domain.setCoverFileId(domainDTO.getCoverFileId());
        if (StringUtils.isBlank((CharSequence)domainDTO.getType())) {
            domain.setType(EntityType.AUTOMATIC);
        } else {
            domain.setType(EntityType.valueOf(domainDTO.getType()));
        }
        if (domainDTO.getOwners() != null) {
            domain.setOwners(domainDTO.getOwners());
        } else {
            domain.setOwners(Collections.emptySet());
        }
        return domain;
    }

    public static DomainDTO domainEntityToDomainDTO(DomainEntity domainEntity) {
        if (domainEntity == null) {
            return null;
        }
        long lastUpdateTime = domainEntity.getLastModifiedDate() == null ? 0L : domainEntity.getLastModifiedDate().getTime();
        String coverUrl = Utils.buildAttachmentUrl(String.valueOf(domainEntity.getId()), lastUpdateTime, "cover", domainEntity.getCoverFileId() == 0L);
        DomainDTO domainDTO = new DomainDTO();
        domainDTO.setId(domainEntity.getId());
        domainDTO.setTitle(domainEntity.getTitle());
        domainDTO.setDescription(domainEntity.getDescription());
        if (domainEntity.getAudienceId() != null) {
            domainDTO.setAudienceId(domainEntity.getAudienceId());
        }
        domainDTO.setCreatedBy(domainEntity.getCreatedBy());
        domainDTO.setCreatedDate(Utils.toRFC3339Date(domainEntity.getCreatedDate()));
        domainDTO.setLastModifiedBy(domainEntity.getLastModifiedBy());
        domainDTO.setLastModifiedDate(Utils.toRFC3339Date(domainEntity.getLastModifiedDate()));
        domainDTO.setDeleted(domainEntity.isDeleted());
        domainDTO.setEnabled(domainEntity.isEnabled());
        domainDTO.setBudget(domainEntity.getBudget());
        domainDTO.setType(domainEntity.getType().name());
        domainDTO.setCoverFileId(domainEntity.getCoverFileId());
        domainDTO.setCoverUrl(coverUrl);
        domainDTO.setOwners(domainEntity.getOwners());
        domainDTO.setRulesTotalScore(Utils.getRulesTotalScoreByDomain(domainEntity.getId()));
        return domainDTO;
    }
}

