/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.util.Collections;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.WebSocketMessage;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.service.AgendaWebSocketService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Asynchronous
public class AgendaWebSocketEventReplyListener
extends Listener<EventAttendee, EventAttendee> {
    private PortalContainer container;
    private AgendaEventService agendaEventService;
    private AgendaWebSocketService agendaWebSocketService;
    private IdentityManager identityManager;

    public AgendaWebSocketEventReplyListener(PortalContainer container, AgendaEventService agendaEventService, IdentityManager identityManager, AgendaWebSocketService agendaWebSocketService) {
        this.container = container;
        this.agendaEventService = agendaEventService;
        this.agendaWebSocketService = agendaWebSocketService;
        this.identityManager = identityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<EventAttendee, EventAttendee> event) throws Exception {
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            EventAttendee newAttendee = (EventAttendee)event.getData();
            long eventId = newAttendee.getEventId();
            long userIdentityId = newAttendee.getIdentityId();
            org.exoplatform.agenda.model.Event agendaEvent = this.agendaEventService.getEventById(eventId);
            long calendarId = agendaEvent.getCalendarId();
            WebSocketMessage socketMessage = new WebSocketMessage(event.getEventName());
            socketMessage.addParam("eventId", (Object)eventId);
            socketMessage.addParam("calendarId", (Object)calendarId);
            Identity identity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
            String username = identity.getRemoteId();
            this.agendaWebSocketService.sendMessage(socketMessage, Collections.singleton(username));
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

