/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.exception;

import java.io.Serializable;
import java.util.MissingResourceException;
import org.exoplatform.perkstore.model.constant.PerkStoreError;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PerkStoreException
extends Exception {
    private static final Log LOG = ExoLogger.getLogger(PerkStoreException.class);
    private static final long serialVersionUID = -5925338937598951745L;
    private final PerkStoreError errorType;
    private final Serializable[] parameters;

    public PerkStoreException(PerkStoreError errorType, Serializable ... parameters) {
        if (errorType == null) {
            throw new IllegalArgumentException("Error details is mandatory");
        }
        errorType.checkValidParametersCount(parameters);
        this.errorType = errorType;
        this.parameters = parameters;
    }

    @Override
    public String getMessage() {
        return this.getMessage(null, true);
    }

    public String getMessage(String message, boolean includeSuffix) {
        try {
            return this.errorType.computeErrorMessage(message, !includeSuffix, this.parameters);
        }
        catch (Exception e) {
            LOG.error((Object)"      -------- DEVELOPMENT BUG: Error composing exception message", (Throwable)e);
            return this.errorType.getErrorCode();
        }
    }

    @Override
    public String getLocalizedMessage() {
        String errorCode = null;
        try {
            errorCode = this.errorType.getErrorCode();
            String message = Utils.getI18NMessage("perkstore.error." + errorCode);
            return this.getMessage(message, false);
        }
        catch (IllegalStateException | MissingResourceException e) {
            LOG.warn("Error getting message for code: {}", new Object[]{errorCode, e});
            return this.getMessage();
        }
        catch (Exception e) {
            LOG.debug("Error getting message for code: {}", new Object[]{errorCode, e});
            return this.getMessage();
        }
    }

    public PerkStoreError getErrorType() {
        return this.errorType;
    }
}

