/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.listener;

import java.util.List;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;

public class ProfileUpdateListener
extends ProfileListenerPlugin {
    private ActivityStorage activityStorage;
    private KudosService kudosService;

    public ProfileUpdateListener(KudosService kudosService, ActivityStorage activityStorage) {
        this.kudosService = kudosService;
        this.activityStorage = activityStorage;
    }

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        String userId = event.getProfile().getIdentity().getId();
        this.clearUserActivitiesCache(userId);
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        String userId = event.getProfile().getIdentity().getId();
        this.clearUserActivitiesCache(userId);
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void createProfile(ProfileLifeCycleEvent event) {
    }

    private void clearUserActivitiesCache(String userId) {
        long count = this.kudosService.countKudosByPeriodAndReceiver(Long.parseLong(userId), 0L, System.currentTimeMillis());
        List<Kudos> kudosList = this.kudosService.getKudosByPeriodAndReceiver(Long.parseLong(userId), 0L, System.currentTimeMillis(), (int)count);
        if (kudosList == null || kudosList.isEmpty()) {
            return;
        }
        kudosList.stream().forEach(kudos -> ((CachedActivityStorage)this.activityStorage).clearActivityCached(String.valueOf(kudos.getActivityId())));
    }
}

