/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

public class WindowsRegistryMimeDetector
extends MimeDetector {
    private static final String REG_QUERY = "reg query ";
    private static final String CONTENT_TYPE = "\"Content Type\"";
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    public String getDescription() {
        return "Get the MIME types of file extensions from the Windows Registry. Will be inafective on non-Windows machines.";
    }

    public Collection getMimeTypesFile(File file) throws UnsupportedOperationException {
        try {
            return this.getMimeTypesURL(file.toURI().toURL());
        }
        catch (Exception e) {
            throw new MimeException(e);
        }
    }

    public Collection getMimeTypesFileName(String fileName) throws UnsupportedOperationException {
        return this.getMimeTypesFile(new File(fileName));
    }

    public Collection getMimeTypesURL(URL url) throws UnsupportedOperationException {
        ArrayList<MimeType> mimeTypes = new ArrayList<MimeType>();
        if (!isWindows) {
            return mimeTypes;
        }
        String contentType = this.getContentType(MimeUtil.getExtension(url.getPath()));
        if (contentType != null && contentType.length() > 0) {
            mimeTypes.add(new MimeType(contentType));
        }
        return mimeTypes;
    }

    public Collection getMimeTypesByteArray(byte[] data) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("WindowsRegistryMimeDetector does not support detection from byte arrays.");
    }

    public Collection getMimeTypesInputStream(InputStream in) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("WindowsRegistryMimeDetector does not support detection from InputStreams.");
    }

    private String getContentType(String extension) {
        int p;
        String result;
        block4: {
            if (extension == null || extension.length() < 1) {
                return null;
            }
            try {
                String query = "reg query \"HKEY_CLASSES_ROOT\\." + extension + "\" /v " + CONTENT_TYPE;
                Process process = Runtime.getRuntime().exec(query);
                StreamReader reader = new StreamReader(process.getInputStream());
                reader.start();
                process.waitFor();
                reader.join();
                result = reader.getResult();
                p = result.indexOf("REG_SZ");
                if (p != -1) break block4;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return result.substring(p + "REG_SZ".length()).trim();
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw;

        StreamReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

