/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.search.ExtendProfileFilter;
import org.exoplatform.social.core.jpa.storage.EntityConverterUtils;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.core.jpa.storage.RDBMSRelationshipStorageImpl$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.RDBMSRelationshipStorageImpl$AjcClosure3;
import org.exoplatform.social.core.jpa.storage.RDBMSRelationshipStorageImpl$AjcClosure5;
import org.exoplatform.social.core.jpa.storage.RDBMSRelationshipStorageImpl$AjcClosure7;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.storage.RelationshipStorageException;
import org.exoplatform.social.core.storage.api.RelationshipStorage;

public class RDBMSRelationshipStorageImpl
implements RelationshipStorage {
    private static final char NULL_CHARACTER = '\u0000';
    private static final Log LOG;
    private final ConnectionDAO connectionDAO;
    private final IdentityDAO identityDAO;
    private final RDBMSIdentityStorageImpl identityStorage;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public RDBMSRelationshipStorageImpl(RDBMSIdentityStorageImpl identityStorage, ConnectionDAO connectionDAO, IdentityDAO identityDAO) {
        this.connectionDAO = connectionDAO;
        this.identityDAO = identityDAO;
        this.identityStorage = identityStorage;
    }

    @ExoTransactional
    public Relationship saveRelationship(Relationship relationship) throws RelationshipStorageException {
        Relationship relationship2 = relationship;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)relationship2);
        Object[] objectArray = new Object[]{this, relationship2, joinPoint};
        RDBMSRelationshipStorageImpl$AjcClosure1 rDBMSRelationshipStorageImpl$AjcClosure1 = new RDBMSRelationshipStorageImpl$AjcClosure1(objectArray);
        return (Relationship)ExoTransactionalAspect.aspectOf().around(rDBMSRelationshipStorageImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void removeRelationship(Relationship relationship) throws RelationshipStorageException {
        Relationship relationship2 = relationship;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)relationship2);
        Object[] objectArray = new Object[]{this, relationship2, joinPoint};
        RDBMSRelationshipStorageImpl$AjcClosure3 rDBMSRelationshipStorageImpl$AjcClosure3 = new RDBMSRelationshipStorageImpl$AjcClosure3(objectArray);
        ExoTransactionalAspect.aspectOf().around(rDBMSRelationshipStorageImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public Relationship getRelationship(Identity identity1, Identity identity2) throws RelationshipStorageException {
        Identity identity = identity1;
        Identity identity3 = identity2;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)identity, (Object)identity3);
        Object[] objectArray = new Object[]{this, identity, identity3, joinPoint};
        RDBMSRelationshipStorageImpl$AjcClosure5 rDBMSRelationshipStorageImpl$AjcClosure5 = new RDBMSRelationshipStorageImpl$AjcClosure5(objectArray);
        return (Relationship)ExoTransactionalAspect.aspectOf().around(rDBMSRelationshipStorageImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public Relationship getRelationship(String relationshipId) throws RelationshipStorageException {
        return EntityConverterUtils.convertRelationshipItemToRelationship((ConnectionEntity)this.connectionDAO.find(Long.valueOf(relationshipId)));
    }

    public List<Identity> getConnections(Identity identity) throws RelationshipStorageException {
        return this.getConnections(identity, 0L, -1L);
    }

    public List<Identity> getConnections(Identity identity, long offset, long limit) throws RelationshipStorageException {
        return this.convertRelationshipEntitiesToIdentities(this.connectionDAO.getConnections(identity, Relationship.Type.CONFIRMED, null, '\u0000', offset, limit, null), identity.getId());
    }

    @ExoTransactional
    public int getConnectionsCount(Identity identity) throws RelationshipStorageException {
        Identity identity2 = identity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)identity2);
        Object[] objectArray = new Object[]{this, identity2, joinPoint};
        RDBMSRelationshipStorageImpl$AjcClosure7 rDBMSRelationshipStorageImpl$AjcClosure7 = new RDBMSRelationshipStorageImpl$AjcClosure7(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(rDBMSRelationshipStorageImpl$AjcClosure7.linkClosureAndJoinPoint(69648)));
    }

    public int getRelationshipsCount(Identity identity) throws RelationshipStorageException {
        return this.connectionDAO.getConnectionsCount(identity, null);
    }

    public List<Relationship> getRelationships(Identity identity, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        return this.getRelationships(identity, type);
    }

    public List<Relationship> getReceiverRelationships(Identity receiver, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        return this.getRelationships(null, receiver, type);
    }

    public List<Relationship> getSenderRelationships(Identity sender, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        return this.getRelationships(sender, null, type);
    }

    public List<Relationship> getRelationships(Identity identity, Relationship.Type type) {
        return this.convertRelationshipEntitiesToRelationships(this.connectionDAO.getConnections(identity, type, null, '\u0000', 0L, -1L, null));
    }

    public List<Relationship> getRelationships(Identity identity, Relationship.Type type, long offset, long limit) {
        return this.convertRelationshipEntitiesToRelationships(this.connectionDAO.getConnections(identity, type, null, '\u0000', offset, limit, null));
    }

    public List<Relationship> getRelationships(Identity sender, Identity receiver, Relationship.Type type) {
        return this.convertRelationshipEntitiesToRelationships(this.connectionDAO.getConnections(sender, receiver, type));
    }

    public List<Identity> getOutgoingRelationships(Identity sender, long offset, long limit) throws RelationshipStorageException {
        return this.convertRelationshipEntitiesToIdentities(this.connectionDAO.getConnections(sender, Relationship.Type.OUTGOING, null, '\u0000', offset, limit, null), sender.getId());
    }

    public int getOutgoingRelationshipsCount(Identity sender) throws RelationshipStorageException {
        return this.connectionDAO.getConnectionsCount(sender, Relationship.Type.OUTGOING);
    }

    public List<Identity> getIncomingRelationships(Identity receiver, long offset, long limit) throws RelationshipStorageException {
        return this.searchConnections(receiver, Relationship.Type.INCOMING, null, '\u0000', offset, limit, null);
    }

    public int getIncomingRelationshipsCount(Identity receiver) throws RelationshipStorageException {
        return this.connectionDAO.getConnectionsCount(receiver, Relationship.Type.INCOMING);
    }

    public List<Identity> getLastConnections(Identity identity, int limit) throws RelationshipStorageException {
        return this.convertRelationshipEntitiesToIdentities(this.connectionDAO.getLastConnections(identity, limit), identity.getId());
    }

    private List<Identity> convertRelationshipEntitiesToIdentities(List<ConnectionEntity> connections, String ownerId) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        if (connections == null) {
            return identities;
        }
        for (ConnectionEntity item : connections) {
            identities.add(this.getIdentityFromRelationshipItem(item, ownerId));
        }
        return identities;
    }

    private List<Relationship> convertRelationshipEntitiesToRelationships(List<ConnectionEntity> connections) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        if (connections == null) {
            return relationships;
        }
        for (ConnectionEntity item : connections) {
            relationships.add(EntityConverterUtils.convertRelationshipItemToRelationship(item));
        }
        return relationships;
    }

    private Identity getIdentityFromRelationshipItem(ConnectionEntity item, String ownerId) {
        Identity identity = null;
        identity = ownerId.equals(item.getSender().getStringId()) ? this.identityStorage.findIdentityById(item.getReceiver().getStringId()) : this.identityStorage.findIdentityById(item.getSender().getStringId());
        if (identity == null) {
            return null;
        }
        Profile profile = this.identityStorage.loadProfile(identity.getProfile());
        identity.setProfile(profile);
        return identity;
    }

    public List<Relationship> getSenderRelationships(String senderId, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        Identity sender = this.identityStorage.findIdentityById(senderId);
        return this.getSenderRelationships(sender, type, listCheckIdentity);
    }

    public boolean hasRelationship(Identity identity1, Identity identity2, String relationshipPath) {
        Relationship r = this.getRelationship(identity1, identity2);
        return r != null && Relationship.Type.CONFIRMED.equals((Object)r.getStatus());
    }

    public List<Identity> getRelationships(Identity identity, long offset, long limit) throws RelationshipStorageException {
        return this.convertRelationshipEntitiesToIdentities(this.connectionDAO.getConnections(identity, Relationship.Type.ALL, null, '\u0000', offset, limit, null), identity.getId());
    }

    public List<Identity> getConnectionsByFilter(Identity existingIdentity, ProfileFilter profileFilter, long offset, long limit) throws RelationshipStorageException {
        return this.searchConnectionByFilter(existingIdentity, Relationship.Type.CONFIRMED, profileFilter, offset, limit);
    }

    public List<Identity> getIncomingByFilter(Identity existingIdentity, ProfileFilter profileFilter, long offset, long limit) throws RelationshipStorageException {
        return this.searchConnectionByFilter(existingIdentity, Relationship.Type.INCOMING, profileFilter, offset, limit);
    }

    public List<Identity> getOutgoingByFilter(Identity existingIdentity, ProfileFilter profileFilter, long offset, long limit) throws RelationshipStorageException {
        return this.searchConnectionByFilter(existingIdentity, Relationship.Type.OUTGOING, profileFilter, offset, limit);
    }

    public int getConnectionsCountByFilter(Identity existingIdentity, ProfileFilter profileFilter) throws RelationshipStorageException {
        return this.countConnectionByFilter(existingIdentity, Relationship.Type.CONFIRMED, profileFilter);
    }

    public int getIncomingCountByFilter(Identity existingIdentity, ProfileFilter profileFilter) throws RelationshipStorageException {
        return this.countConnectionByFilter(existingIdentity, Relationship.Type.INCOMING, profileFilter);
    }

    public int getOutgoingCountByFilter(Identity existingIdentity, ProfileFilter profileFilter) throws RelationshipStorageException {
        return this.countConnectionByFilter(existingIdentity, Relationship.Type.OUTGOING, profileFilter);
    }

    public List<Relationship> getRelationshipsByStatus(Identity identity, Relationship.Type type, long offset, long limit) {
        return this.getRelationships(identity, type, offset, limit);
    }

    public int getRelationshipsCountByStatus(Identity identity, Relationship.Type type) {
        return this.countConnectionByFilter(identity, type, null);
    }

    public Map<Identity, Integer> getSuggestions(Identity identity, int maxConnections, int maxConnectionsToLoad, int maxSuggestions) throws RelationshipStorageException {
        List ids;
        List<Identity> connections;
        int endIndex;
        if (maxConnectionsToLoad > 0 && maxConnections > maxConnectionsToLoad) {
            maxConnectionsToLoad = maxConnections;
        }
        HashSet<Identity> relationIdLevel1 = new HashSet<Identity>();
        int size = this.getConnectionsCount(identity);
        Random random = new Random();
        if (size > maxConnectionsToLoad && maxConnectionsToLoad > 0 && maxConnections > 0) {
            int startIndex = random.nextInt(size - maxConnectionsToLoad);
            endIndex = maxConnections;
            connections = this.getConnections(identity, startIndex, maxConnectionsToLoad);
        } else {
            endIndex = size;
            connections = this.getConnections(identity, 0L, size);
        }
        for (int i = 0; i < connections.size(); ++i) {
            Identity id = connections.get(i);
            relationIdLevel1.add(id);
        }
        relationIdLevel1.remove(identity);
        HashMap<List, Integer> suggestedIdentities = new HashMap<List, Integer>();
        Iterator it = relationIdLevel1.iterator();
        for (int j = 0; j < size && it.hasNext(); ++j) {
            Identity id = (Identity)it.next();
            if (j >= endIndex && suggestedIdentities.size() > maxSuggestions && maxSuggestions > 0) break;
            int allConnSize = this.getConnectionsCount(id);
            int allConnStartIndex = 0;
            if (allConnSize > maxConnections && maxConnections > 0) {
                allConnStartIndex = random.nextInt(allConnSize - maxConnections);
                connections = this.getConnections(id, allConnStartIndex, maxConnections);
            } else {
                connections = this.getConnections(id, 0L, allConnSize);
            }
            for (int i = 0; i < connections.size(); ++i) {
                ids = connections.get(i);
                if (relationIdLevel1.contains(ids) || ids.equals(identity) || ids.isDeleted() || !ids.isEnable() || this.getRelationship((Identity)ids, identity) != null) continue;
                Integer commonIdentities = (Integer)suggestedIdentities.get(ids);
                commonIdentities = commonIdentities == null ? new Integer(1) : new Integer(commonIdentities + 1);
                suggestedIdentities.put(ids, commonIdentities);
            }
        }
        TreeMap<Integer, ArrayList<Identity>> groupByCommonConnections = new TreeMap<Integer, ArrayList<Identity>>();
        for (Identity id : suggestedIdentities.keySet()) {
            Integer commonIdentities = (Integer)suggestedIdentities.get(id);
            ArrayList<Identity> ids2 = (ArrayList<Identity>)groupByCommonConnections.get(commonIdentities);
            if (ids2 == null) {
                ids2 = new ArrayList<Identity>();
                groupByCommonConnections.put(commonIdentities, ids2);
            }
            ids2.add(id);
        }
        LinkedHashMap<Identity, Integer> suggestions = new LinkedHashMap<Identity, Integer>();
        int suggestionLeft = maxSuggestions;
        block4: for (Integer key : groupByCommonConnections.descendingKeySet()) {
            ids = (List)groupByCommonConnections.get(key);
            for (Identity id : ids) {
                suggestions.put(id, key);
                if (maxSuggestions <= 0 || --suggestionLeft != 0) continue;
                break block4;
            }
        }
        return suggestions;
    }

    public int getConnectionsInCommonCount(Identity identity1, Identity identity2) {
        return this.connectionDAO.getConnectionsInCommonCount(identity1.getId(), identity2.getId());
    }

    private List<Identity> searchConnectionByFilter(Identity owner, Relationship.Type status, ProfileFilter profileFilter, long offset, long limit) {
        ExtendProfileFilter xFilter = new ExtendProfileFilter(profileFilter);
        if (xFilter.isEmpty()) {
            return this.searchConnections(owner, status, xFilter.getFirstCharFieldName(), xFilter.getFirstCharacterOfName(), offset, limit, profileFilter.getSorting());
        }
        xFilter.setConnection(owner);
        xFilter.setConnectionStatus(status);
        ListAccess<Identity> list = this.identityStorage.findByFilter(xFilter);
        try {
            return Arrays.asList((Identity[])list.load((int)offset, (int)limit));
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    private List<Identity> searchConnections(Identity owner, Relationship.Type status, String firstCharacterField, char firstCharacter, long offset, long limit, Sorting sorting) {
        long ownerId = Long.valueOf(owner.getId());
        List<ConnectionEntity> connections = this.connectionDAO.getConnections(owner, status, firstCharacterField, firstCharacter, offset, limit, sorting);
        ArrayList<Identity> identities = new ArrayList<Identity>();
        for (ConnectionEntity connectionEntity : connections) {
            Identity identity;
            IdentityEntity receiver = connectionEntity.getReceiver();
            IdentityEntity sender = connectionEntity.getSender();
            if (ownerId == sender.getId() && !receiver.isDeleted() && receiver.isEnabled()) {
                identity = EntityConverterUtils.convertToIdentity(receiver);
                identities.add(identity);
                continue;
            }
            if (ownerId == receiver.getId() && !sender.isDeleted() && sender.isEnabled()) {
                identity = EntityConverterUtils.convertToIdentity(sender);
                identities.add(identity);
                continue;
            }
            LOG.warn("Incompatible returned connection entity, the ownerId {} is not receiver, neither sender", new Object[]{ownerId});
        }
        return identities;
    }

    private int countConnectionByFilter(Identity owner, Relationship.Type status, ProfileFilter profileFilter) {
        ExtendProfileFilter xFilter = new ExtendProfileFilter(profileFilter);
        xFilter.setConnection(owner);
        xFilter.setConnectionStatus(status);
        ListAccess<Identity> list = this.identityStorage.findByFilter(xFilter);
        try {
            return list.getSize();
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            return 0;
        }
    }

    static {
        RDBMSRelationshipStorageImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(RDBMSRelationshipStorageImpl.class);
    }

    static /* synthetic */ Relationship saveRelationship_aroundBody0(RDBMSRelationshipStorageImpl ajc$this, Relationship relationship, JoinPoint joinPoint) {
        if (relationship.getId() == null) {
            ConnectionEntity entity = ajc$this.connectionDAO.getConnection(relationship.getSender(), relationship.getReceiver());
            if (entity == null) {
                entity = new ConnectionEntity();
            }
            entity.setReceiver((IdentityEntity)ajc$this.identityDAO.find(Long.valueOf(relationship.getReceiver().getId())));
            entity.setSender((IdentityEntity)ajc$this.identityDAO.find(Long.valueOf(relationship.getSender().getId())));
            entity.setStatus(relationship.getStatus());
            entity.setUpdatedDate(new Date());
            ajc$this.connectionDAO.create(entity);
            relationship.setId(Long.toString(entity.getId()));
        } else {
            ConnectionEntity entity = ajc$this.connectionDAO.getConnection(relationship.getSender(), relationship.getReceiver());
            entity.setStatus(relationship.getStatus());
            entity.setUpdatedDate(new Date());
            ajc$this.connectionDAO.update(entity);
        }
        return relationship;
    }

    static /* synthetic */ void removeRelationship_aroundBody2(RDBMSRelationshipStorageImpl ajc$this, Relationship relationship, JoinPoint joinPoint) {
        ConnectionEntity connection = ajc$this.connectionDAO.getConnection(relationship.getSender(), relationship.getReceiver());
        if (connection != null) {
            ajc$this.connectionDAO.delete(connection);
        }
    }

    static /* synthetic */ Relationship getRelationship_aroundBody4(RDBMSRelationshipStorageImpl ajc$this, Identity identity1, Identity identity2, JoinPoint joinPoint) {
        if (identity1 == null) {
            throw new IllegalArgumentException("Argument identity1 is null");
        }
        if (identity2 == null) {
            throw new IllegalArgumentException("Argument identity2 is null");
        }
        ConnectionEntity item = ajc$this.connectionDAO.getConnection(identity1, identity2);
        if (item == null) {
            item = ajc$this.connectionDAO.getConnection(identity2, identity1);
        }
        return EntityConverterUtils.convertRelationshipItemToRelationship(item);
    }

    static /* synthetic */ int getConnectionsCount_aroundBody6(RDBMSRelationshipStorageImpl ajc$this, Identity identity, JoinPoint joinPoint) {
        return ajc$this.connectionDAO.getConnectionsCount(identity, Relationship.Type.CONFIRMED);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RDBMSRelationshipStorageImpl.java", RDBMSRelationshipStorageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveRelationship", "org.exoplatform.social.core.jpa.storage.RDBMSRelationshipStorageImpl", "org.exoplatform.social.core.relationship.model.Relationship", "relationship", "org.exoplatform.social.core.storage.RelationshipStorageException", "org.exoplatform.social.core.relationship.model.Relationship"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeRelationship", "org.exoplatform.social.core.jpa.storage.RDBMSRelationshipStorageImpl", "org.exoplatform.social.core.relationship.model.Relationship", "relationship", "org.exoplatform.social.core.storage.RelationshipStorageException", "void"), 92);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRelationship", "org.exoplatform.social.core.jpa.storage.RDBMSRelationshipStorageImpl", "org.exoplatform.social.core.identity.model.Identity:org.exoplatform.social.core.identity.model.Identity", "identity1:identity2", "org.exoplatform.social.core.storage.RelationshipStorageException", "org.exoplatform.social.core.relationship.model.Relationship"), 101);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnectionsCount", "org.exoplatform.social.core.jpa.storage.RDBMSRelationshipStorageImpl", "org.exoplatform.social.core.identity.model.Identity", "identity", "org.exoplatform.social.core.storage.RelationshipStorageException", "int"), 132);
    }
}

