/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;

public class GroupSynchronizationSocialProfileListener
extends ProfileListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(GroupSynchronizationSocialProfileListener.class);
    private static final String PROFILE_GROUP_NAME = "profile";
    private static final String MEMBER = "member";
    private final ProfilePropertyService profilePropertyService;
    private final OrganizationService organizationService;

    public GroupSynchronizationSocialProfileListener(ProfilePropertyService profilePropertyService, OrganizationService organizationService) {
        this.profilePropertyService = profilePropertyService;
        this.organizationService = organizationService;
    }

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    public void createProfile(ProfileLifeCycleEvent event) {
        this.profileUpdated(event);
    }

    private void profileUpdated(ProfileLifeCycleEvent profileLifeCycleEvent) {
        Profile profile = profileLifeCycleEvent.getProfile();
        try {
            User user = this.organizationService.getUserHandler().findUserByName(profile.getIdentity().getRemoteId());
            this.synchronizePropertyGroups(profileLifeCycleEvent.getProfile(), user);
        }
        catch (Exception e) {
            LOG.error("Error while synchronizing profile property of user {} to groups", new Object[]{profile.getIdentity().getRemoteId(), e});
        }
    }

    private void synchronizePropertyGroups(Profile profile, User user) {
        try {
            Group profileGroup = this.getOrCreateGroup(PROFILE_GROUP_NAME, null);
            List<String> synchronizedProperties = this.profilePropertyService.getSynchronizedPropertySettings().stream().filter(ProfilePropertySetting::isActive).map(ProfilePropertySetting::getPropertyName).toList();
            Set properties = profile.getProperties().entrySet();
            Set<Map.Entry> propertiesToSynchronize = properties.stream().filter(property -> synchronizedProperties.contains(property.getKey())).collect(Collectors.toSet());
            propertiesToSynchronize.forEach(property -> this.synchronizeProperty((Map.Entry<String, Object>)property, profileGroup, user));
        }
        catch (Exception e) {
            LOG.error("Error while trying to add / create profile group {} for user ", new Object[]{PROFILE_GROUP_NAME, user.getUserName(), e});
        }
    }

    private void synchronizeProperty(Map.Entry<String, Object> property, Group profileGroup, User user) {
        String propertyName = property.getKey();
        String propertyValue = (String)property.getValue();
        try {
            Group newPropertyNameGroup = this.getOrCreateGroup(propertyName, profileGroup);
            try {
                Group newPropertyValueGroup = this.getOrCreateGroup(propertyValue, newPropertyNameGroup);
                this.addUserToGroup(newPropertyValueGroup, user);
            }
            catch (Exception e) {
                LOG.error("Error while adding property value group {} under property Group {}", new Object[]{propertyValue, newPropertyNameGroup != null ? newPropertyNameGroup.getId() : "/", e});
            }
        }
        catch (Exception e) {
            LOG.error("Error while adding property group {} under profile Group {}", new Object[]{propertyName, profileGroup != null ? profileGroup.getId() : "/", e});
        }
    }

    private Group getGroup(String groupId) throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        return groupHandler.findGroupById(groupId);
    }

    private Group getOrCreateGroup(String groupName, Group parentGroup) throws Exception {
        Group group = this.getGroup(this.buildGroupId(parentGroup, groupName));
        if (group != null) {
            return group;
        }
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group newGroup = groupHandler.createGroupInstance();
        newGroup.setGroupName(groupName.toLowerCase());
        newGroup.setLabel(StringUtils.capitalize((String)groupName));
        newGroup.setDescription(groupName + " group");
        groupHandler.addChild(parentGroup, newGroup, true);
        return this.getGroup(this.buildGroupId(parentGroup, groupName));
    }

    private void addUserToGroup(Group group, User user) throws Exception {
        if (group == null) {
            return;
        }
        try {
            MembershipType membershipType = this.organizationService.getMembershipTypeHandler().findMembershipType(MEMBER);
            this.organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
        }
        catch (Exception e) {
            LOG.error("Error while adding user {} to Group {}", new Object[]{user.getUserName(), group.getId(), e});
            throw e;
        }
    }

    private String buildGroupId(Group parentGroup, String groupName) {
        if (parentGroup == null) {
            return "/" + groupName.toLowerCase();
        }
        return parentGroup.getId() + "/" + groupName.toLowerCase();
    }
}

