/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.impl.dataflow.PermissionValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;

public class PermissionPersistedValueData
extends PermissionValueData
implements PersistedValueData {
    public PermissionPersistedValueData() {
        super(0, null);
    }

    public PermissionPersistedValueData(int orderNumber, AccessControlEntry value) {
        super(orderNumber, value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.orderNumber = in.readInt();
        String identity = null;
        String permission = null;
        byte[] data = new byte[in.readInt()];
        if (data.length > 0) {
            in.readFully(data);
            identity = new String(data, "UTF-8");
        }
        if ((data = new byte[in.readInt()]).length > 0) {
            in.readFully(data);
            permission = new String(data, "UTF-8");
        }
        this.value = new AccessControlEntry(identity, permission);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.orderNumber);
        byte[] data = this.value.getIdentity().getBytes("UTF-8");
        out.writeInt(data.length);
        if (data.length > 0) {
            out.write(data);
        }
        data = this.value.getPermission().getBytes("UTF-8");
        out.writeInt(data.length);
        if (data.length > 0) {
            out.write(data);
        }
    }
}

