/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

public class AgendaEventReminderComputingListener
extends Listener<AgendaEventModification, Object> {
    private AgendaEventReminderService agendaEventReminderService;
    private AgendaEventService agendaEventService;

    public void onEvent(Event<AgendaEventModification, Object> event) throws Exception {
        long eventId = ((AgendaEventModification)event.getSource()).getEventId();
        org.exoplatform.agenda.model.Event agendaEvent = this.getAgendaEventService().getEventById(eventId);
        if (agendaEvent == null || agendaEvent.getStatus() != EventStatus.CONFIRMED) {
            return;
        }
        if (agendaEvent.getRecurrence() != null) {
            ZonedDateTime start = ZonedDateTime.now();
            ZonedDateTime end = start.plusDays(this.getAgendaEventReminderService().getReminderComputingPeriod());
            List occurrences = this.getAgendaEventService().getEventOccurrencesInPeriod(agendaEvent, start, end, ZoneId.systemDefault(), 0);
            for (org.exoplatform.agenda.model.Event occurrence : occurrences) {
                ZonedDateTime occurrenceId = occurrence.getOccurrence().getId();
                this.getAgendaEventService().saveEventExceptionalOccurrence(eventId, occurrenceId);
            }
        }
    }

    public AgendaEventReminderService getAgendaEventReminderService() {
        if (this.agendaEventReminderService == null) {
            this.agendaEventReminderService = (AgendaEventReminderService)ExoContainerContext.getService(AgendaEventReminderService.class);
        }
        return this.agendaEventReminderService;
    }

    public AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)ExoContainerContext.getService(AgendaEventService.class);
        }
        return this.agendaEventService;
    }
}

