/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

final class MathTransformContext
extends DefaultMathTransformFactory.Context {
    private static final long serialVersionUID = 8765209303733056283L;
    private double sourceMeridian;
    private double targetMeridian;

    MathTransformContext(GeodeticDatum geodeticDatum, GeodeticDatum geodeticDatum2) {
        double d = ReferencingUtilities.getGreenwichLongitude(geodeticDatum.getPrimeMeridian(), (Unit<Angle>)Units.DEGREE);
        double d2 = ReferencingUtilities.getGreenwichLongitude(geodeticDatum2.getPrimeMeridian(), (Unit<Angle>)Units.DEGREE);
        if (d != d2) {
            this.sourceMeridian = d;
            this.targetMeridian = d2;
        }
    }

    @Override
    public Matrix getMatrix(ContextualParameters.MatrixRole matrixRole) throws FactoryException {
        CoordinateSystem coordinateSystem;
        double d;
        boolean bl = false;
        switch (matrixRole) {
            default: {
                throw new IllegalArgumentException(Errors.format((short)45, (Object)"role", (Object)((Object)matrixRole)));
            }
            case INVERSE_NORMALIZATION: {
                bl = true;
            }
            case NORMALIZATION: {
                d = this.sourceMeridian;
                coordinateSystem = this.getSourceCS();
                break;
            }
            case INVERSE_DENORMALIZATION: {
                bl = true;
            }
            case DENORMALIZATION: {
                bl = !bl;
                d = this.targetMeridian;
                coordinateSystem = this.getTargetCS();
            }
        }
        Matrix matrix = super.getMatrix(matrixRole);
        if (d != 0.0) {
            if (bl) {
                d = -d;
            }
            MatrixSIS matrixSIS = MatrixSIS.castOrCopy(matrix);
            if (coordinateSystem instanceof CartesianCS) {
                d = Math.toRadians(d);
                Matrix4 matrix4 = new Matrix4();
                matrix4.m00 = matrix4.m11 = Math.cos(d);
                matrix4.m10 = Math.sin(d);
                matrix4.m01 = -matrix4.m10;
                matrix = bl ? Matrices.multiply(matrix4, matrixSIS) : matrixSIS.multiply(matrix4);
            } else if (coordinateSystem == null || coordinateSystem instanceof EllipsoidalCS || coordinateSystem instanceof SphericalCS) {
                Double d2 = d;
                if (bl) {
                    matrixSIS.convertBefore(0, null, d2);
                } else {
                    matrixSIS.convertAfter(0, null, d2);
                }
                matrix = matrixSIS;
            } else {
                throw new FactoryException(Errors.format((short)178, (Object)coordinateSystem.getName()));
            }
        }
        return matrix;
    }
}

