/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Collections;
import org.apache.sis.internal.referencing.provider.NorthPoleRotation;
import org.apache.sis.internal.referencing.provider.SouthPoleRotation;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptorGroup;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ComparisonMode;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class PoleRotation
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = -8355693495724373931L;
    private static final int POLE_LATITUDE = 0;
    private static final int POLE_LONGITUDE = 1;
    private static final int AXIS_ANGLE = 2;
    private static final double MAX_AXIS_ROTATION = 90.0;
    private final ContextualParameters context;
    private final double sin\u03c6p;
    private final double cos\u03c6p;
    private MathTransform2D inverse;

    private PoleRotation(PoleRotation poleRotation) {
        this.context = poleRotation.context.inverse(poleRotation.context.getDescriptor(), PoleRotation::inverseParameter);
        this.sin\u03c6p = poleRotation.sin\u03c6p;
        this.cos\u03c6p = -poleRotation.cos\u03c6p;
        this.inverse = poleRotation;
    }

    private static boolean inverseParameter(Parameters parameters, ParameterValue<?> parameterValue) {
        ParameterDescriptorGroup parameterDescriptorGroup = parameters.getDescriptor();
        int n = parameterDescriptorGroup.descriptors().indexOf(parameterValue.getDescriptor());
        if (n < 0) {
            return false;
        }
        if (n != 0) {
            n = 3 - n;
        }
        Number number = PoleRotation.getValue(parameters, n);
        if (n != 0 && SouthPoleRotation.PARAMETERS.equals((Object)parameterDescriptorGroup)) {
            double d = number.doubleValue();
            number = Math.copySign(180.0, d) - d;
        }
        parameterValue.setValue((Object)number);
        return true;
    }

    private static Number getValue(Parameters parameters, int n) {
        return (Number)((ParameterValue)parameters.values().get(n)).getValue();
    }

    private void setValue(int n, double d) {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.context.getDescriptor().descriptors().get(n);
        this.context.parameter(parameterDescriptor.getName().getCode()).setValue(d);
    }

    protected PoleRotation(boolean bl, double d, double d2, double d3) {
        this.context = new ContextualParameters(bl ? SouthPoleRotation.PARAMETERS : NorthPoleRotation.PARAMETERS, 2, 2);
        this.setValue(0, d);
        this.setValue(1, d2);
        this.setValue(2, d3);
        if (bl) {
            d3 = -d3;
        } else {
            d = -d;
            d2 -= Math.copySign(180.0, d2);
        }
        double d4 = 1.0;
        if (Math.abs(d3) > 90.0) {
            d4 = -1.0;
            d3 -= Math.copySign(180.0, d3);
            this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION).convertAfter(0, -1, null);
            this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).convertBefore(1, -1, null);
        }
        double d5 = Math.toRadians(d);
        this.sin\u03c6p = Math.sin(d5) * d4;
        this.cos\u03c6p = Math.cos(d5) * d4;
        this.context.normalizeGeographicInputs(d2);
        this.context.denormalizeGeographicOutputs(d3);
    }

    public static MathTransform rotateSouthPole(MathTransformFactory mathTransformFactory, double d, double d2, double d3) throws FactoryException {
        PoleRotation poleRotation = new PoleRotation(true, d, d2, d3);
        return poleRotation.context.completeTransform(mathTransformFactory, poleRotation);
    }

    public static MathTransform rotateNorthPole(MathTransformFactory mathTransformFactory, double d, double d2, double d3) throws FactoryException {
        PoleRotation poleRotation = new PoleRotation(false, d, d2, d3);
        return poleRotation.context.completeTransform(mathTransformFactory, poleRotation);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        ImmutableIdentifier immutableIdentifier = new ImmutableIdentifier(Citations.SIS, "SIS", "Rotated Latitude/longitude (radians domain)");
        return new DefaultParameterDescriptorGroup(Collections.singletonMap("name", immutableIdentifier), 1, 1, new GeneralParameterDescriptor[]{(ParameterDescriptor)this.context.getDescriptor().descriptors().get(0)});
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup parameterValueGroup = this.getParameterDescriptors().createValue();
        parameterValueGroup.values().add(this.context.values().get(0));
        return parameterValueGroup;
    }

    @Override
    protected ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = Math.sin(d);
        double d6 = Math.cos(d);
        double d7 = d4 * d6;
        double d8 = d4 * d5;
        double d9 = d8 * d8;
        double d10 = d7 * this.sin\u03c6p;
        double d11 = d7 * this.cos\u03c6p;
        double d12 = d3 * this.sin\u03c6p;
        double d13 = d3 * this.cos\u03c6p;
        double d14 = d13 - d10;
        double d15 = -d11 - d12;
        if (dArray2 != null) {
            dArray2[n2] = Math.atan2(d8, d14);
            dArray2[n2 + 1] = Math.asin(d15);
        }
        if (!bl) {
            return null;
        }
        double d16 = d14 * d14 + d9;
        double d17 = Math.sqrt(1.0 - d15 * d15);
        double d18 = d6 * d12 + d4 * this.cos\u03c6p;
        double d19 = d6 * d13 - d4 * this.sin\u03c6p;
        return new Matrix2((d14 * d7 - d9 * this.sin\u03c6p) / d16, -(d14 * d3 * d5 + d8 * d18) / d16, d8 * this.cos\u03c6p / d17, d19 / d17);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (dArray == dArray2 && n < n2 || this.getClass() != PoleRotation.class) {
            super.transform(dArray, n, dArray2, n2, n3);
            return;
        }
        while (--n3 >= 0) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            double d3 = Math.sin(d2);
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d) * d4;
            double d6 = Math.cos(d) * d4;
            double d7 = this.cos\u03c6p * d3 - this.sin\u03c6p * d6;
            double d8 = -this.cos\u03c6p * d6 - this.sin\u03c6p * d3;
            dArray2[n2++] = Math.atan2(d5, d7);
            dArray2[n2++] = Math.asin(d8);
        }
    }

    @Override
    public synchronized MathTransform2D inverse() {
        if (this.inverse == null) {
            PoleRotation poleRotation = new PoleRotation(this);
            ContextualParameters contextualParameters = poleRotation.context;
            double d = contextualParameters.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).getElement(0, 2);
            if (Math.abs(d) > 90.0) {
                PoleRotation poleRotation2 = new PoleRotation(SouthPoleRotation.PARAMETERS.equals((Object)contextualParameters.getDescriptor()), PoleRotation.getValue(contextualParameters, 0).doubleValue(), PoleRotation.getValue(contextualParameters, 1).doubleValue(), PoleRotation.getValue(contextualParameters, 2).doubleValue());
                ContextualParameters contextualParameters2 = poleRotation2.context;
                this.inverse = MathTransforms.concatenate(PoleRotation.concatenate(contextualParameters, ContextualParameters.MatrixRole.INVERSE_NORMALIZATION, contextualParameters2, ContextualParameters.MatrixRole.NORMALIZATION), poleRotation2, PoleRotation.concatenate(contextualParameters2, ContextualParameters.MatrixRole.DENORMALIZATION, contextualParameters, ContextualParameters.MatrixRole.INVERSE_DENORMALIZATION));
            } else {
                this.inverse = poleRotation;
            }
        }
        return this.inverse;
    }

    private static MathTransform2D concatenate(ContextualParameters contextualParameters, ContextualParameters.MatrixRole matrixRole, ContextualParameters contextualParameters2, ContextualParameters.MatrixRole matrixRole2) {
        return (MathTransform2D)MathTransforms.linear(contextualParameters2.getMatrix(matrixRole2).multiply(contextualParameters.getMatrix(matrixRole)));
    }

    @Override
    public boolean isIdentity() {
        return this.sin\u03c6p == -1.0;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            PoleRotation poleRotation = (PoleRotation)object;
            if (comparisonMode.isApproximate()) {
                return Numerics.epsilonEqual((double)this.sin\u03c6p, (double)poleRotation.sin\u03c6p, (double)1.5706706731410455E-9) && Numerics.epsilonEqual((double)this.cos\u03c6p, (double)poleRotation.cos\u03c6p, (double)1.5706706731410455E-9);
            }
            return Numerics.equals((double)this.sin\u03c6p, (double)poleRotation.sin\u03c6p) && Numerics.equals((double)this.cos\u03c6p, (double)poleRotation.cos\u03c6p);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() + Double.hashCode(this.cos\u03c6p) + Double.hashCode(this.sin\u03c6p);
    }
}

