/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.function;

import java.util.List;
import org.xmlpull.v1.builder.xpath.jaxen.Context;
import org.xmlpull.v1.builder.xpath.jaxen.Function;
import org.xmlpull.v1.builder.xpath.jaxen.FunctionCallException;
import org.xmlpull.v1.builder.xpath.jaxen.Navigator;

public class StringFunction
implements Function {
    @Override
    public Object call(Context context, List args) throws FunctionCallException {
        int size = args.size();
        if (size == 0) {
            return StringFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (size == 1) {
            return StringFunction.evaluate(args.get(0), context.getNavigator());
        }
        throw new FunctionCallException("string() requires one argument.");
    }

    public static String evaluate(Object obj, Navigator nav) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (nav.isElement(obj)) {
            return nav.getElementStringValue(obj);
        }
        if (nav.isAttribute(obj)) {
            return nav.getAttributeStringValue(obj);
        }
        if (nav.isText(obj)) {
            return nav.getTextStringValue(obj);
        }
        if (nav.isProcessingInstruction(obj)) {
            return nav.getProcessingInstructionData(obj);
        }
        if (nav.isComment(obj)) {
            return nav.getCommentStringValue(obj);
        }
        if (nav.isNamespace(obj)) {
            return nav.getNamespaceStringValue(obj);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            int size = list.size();
            if (size > 0) {
                return StringFunction.evaluate(list.get(0), nav);
            }
        } else {
            if (obj instanceof Boolean) {
                return obj.toString();
            }
            if (obj instanceof Integer) {
                return obj.toString();
            }
            if (obj instanceof Double) {
                Double num = (Double)obj;
                if (num.isNaN()) {
                    return "NaN";
                }
                if (num.isInfinite()) {
                    if (num.intValue() < 0) {
                        return "-Infinity";
                    }
                    return "Infinity";
                }
                if (num.floatValue() == (float)num.intValue()) {
                    return Integer.toString(num.intValue());
                }
                return num.toString();
            }
        }
        return "";
    }
}

