/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.listener;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.news.model.News;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.exoplatform.social.metadata.model.MetadataItem;

public class MetadataItemModified
extends Listener<Long, MetadataItem> {
    private IndexingService indexingService;
    private NewsService newsService;
    private CachedActivityStorage cachedActivityStorage;

    public MetadataItemModified(NewsService newsService, IndexingService indexingService, ActivityStorage activityStorage) {
        this.newsService = newsService;
        this.indexingService = indexingService;
        if (activityStorage instanceof CachedActivityStorage) {
            this.cachedActivityStorage = (CachedActivityStorage)activityStorage;
        }
    }

    public void onEvent(Event<Long, MetadataItem> event) throws Exception {
        News news;
        MetadataItem metadataItem = (MetadataItem)event.getData();
        String objectType = metadataItem.getObjectType();
        String objectId = metadataItem.getObjectId();
        if (this.isNewsEvent(objectType) && (news = this.newsService.getNewsById(objectId, false)) != null) {
            if (StringUtils.isNotBlank((CharSequence)news.getActivityId())) {
                this.clearCache(news.getActivityId());
            }
            this.reindexNews(objectId);
        }
    }

    protected boolean isNewsEvent(String objectType) {
        return StringUtils.equals((CharSequence)objectType, (CharSequence)"news");
    }

    private void clearCache(String activityId) {
        if (this.cachedActivityStorage != null) {
            this.cachedActivityStorage.clearActivityCached(activityId);
        }
    }

    private void reindexNews(String newsId) {
        this.indexingService.reindex("news", newsId);
    }
}

