/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.util.CharSequences;

public enum CodeType {
    FILE(false),
    URL(false),
    URN(true),
    HTTP_OGC(true),
    IDENTIFIER(true),
    UNKNOWN(false);

    public final boolean isCRS;
    private static final Map<String, CodeType> FOR_PROTOCOL;

    private CodeType(boolean bl) {
        this.isCRS = bl;
    }

    public static CodeType guess(String string) {
        char c;
        int n;
        int n2 = string.length();
        int n3 = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)0, (int)n2);
        int n4 = CharSequences.skipTrailingWhitespaces((CharSequence)string, (int)n3, (int)(n = string.indexOf(58, n3)));
        if (n4 <= n3) {
            if (string.contains(File.separator) || string.indexOf(47) >= 0 || string.indexOf(92) >= 0) {
                return FILE;
            }
            return UNKNOWN;
        }
        do {
            if ((n = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)(n + 1), (int)n2)) < n2) continue;
            return FILE;
        } while ((c = string.charAt(n)) == '.');
        CodeType codeType = FOR_PROTOCOL.get(string.substring(n3, n4).toLowerCase(Locale.US));
        if (codeType != null) {
            if (codeType != HTTP_OGC) {
                return codeType;
            }
            if (c == '/') {
                while (++n < n2) {
                    c = string.charAt(n);
                    if (c == '/') continue;
                    if (!CharSequences.regionMatches((CharSequence)string, (int)(n = CharSequences.skipLeadingWhitespaces((CharSequence)string, (int)n, (int)n2)), (CharSequence)"www.opengis.net", (boolean)true) || (n += "www.opengis.net".length()) < n2 && string.charAt(n) != '/') break;
                    return codeType;
                }
            }
            return URL;
        }
        if (c == '/') {
            return URL;
        }
        if (c == '\\' || c == File.separatorChar || n4 == n3 + 1) {
            return FILE;
        }
        return IDENTIFIER;
    }

    static {
        FOR_PROTOCOL = new HashMap<String, CodeType>();
        FOR_PROTOCOL.put("urn", URN);
        FOR_PROTOCOL.put("http", HTTP_OGC);
        FOR_PROTOCOL.put("https", HTTP_OGC);
        FOR_PROTOCOL.put("shttp", HTTP_OGC);
        for (String string : new String[]{"cvs", "dav", "file", "ftp", "git", "jar", "nfs", "sftp", "ssh", "svn"}) {
            if (FOR_PROTOCOL.put(string, URL) != null) {
                throw new AssertionError((Object)string);
            }
        }
    }
}

