/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.UndeliverableException;
import io.reactivex.plugins.RxJavaPlugins;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.future.FutureCache;
import org.exoplatform.services.cache.future.FutureExoCache;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure1;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure11;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure13;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure15;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure17;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure19;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure21;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure3;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure5;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure7;
import org.exoplatform.wallet.blockchain.service.EthereumClientConnector$AjcClosure9;
import org.exoplatform.wallet.contract.MeedsToken;
import org.exoplatform.wallet.model.ContractTransactionEvent;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.statistic.ExoWalletStatistic;
import org.exoplatform.wallet.statistic.ExoWalletStatisticAspect;
import org.exoplatform.wallet.statistic.ExoWalletStatisticService;
import org.exoplatform.wallet.utils.WalletUtils;
import org.picocontainer.Startable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.datatypes.Event;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketListener;
import org.web3j.protocol.websocket.WebSocketService;
import org.web3j.utils.Async;

public class EthereumClientConnector
implements ExoWalletStatisticService,
Startable {
    public static final int MINIMUM_POLLING_TIME = 2000;
    public static final int DEFAULT_POLLING_TIME = 15000;
    private static final Log LOG;
    private Web3j web3j = null;
    private WebSocketClient webSocketClient = null;
    private WebSocketService web3jService = null;
    private ListenerService listenerService = null;
    private FutureCache<String, Transaction, Object> transactionFutureCache = null;
    private FutureCache<String, TransactionReceipt, Object> receiptFutureCache = null;
    private ScheduledExecutorService subscriptionVerifierExecutor = null;
    private ScheduledExecutorService connectionVerifierExecutor = null;
    private ScheduledFuture<?> connectionVerifierFuture;
    private boolean permanentlyScanBlockchain = false;
    private boolean listeningToBlockchain = false;
    private boolean serviceStopping = false;
    private long networkId = 0L;
    private String websocketURL = null;
    private String websocketURLSuffix = null;
    private Disposable ethFilterSubscribtion;
    private boolean subscriptionInProgress = false;
    private long pollingInterval;
    private long lastWatchedBlockNumber;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    public EthereumClientConnector(CacheService cacheService) {
        String pollingIntervalParam = System.getProperty("exo.wallet.blockchain.polling.intervalInSeconds");
        if (StringUtils.isNotBlank((CharSequence)pollingIntervalParam)) {
            this.setPollingInterval(Long.parseLong(pollingIntervalParam) * 1000L);
        } else {
            this.setPollingInterval(15000L);
        }
        String permanentlyScanParam = System.getProperty("exo.wallet.blockchain.permanentlyScan", "false");
        this.permanentlyScanBlockchain = Boolean.parseBoolean(permanentlyScanParam);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Ethereum-websocket-connector-%d").build();
        this.connectionVerifierExecutor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Ethereum-contract-flowable-%d").build();
        this.subscriptionVerifierExecutor = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        ExoCache transactionCache = cacheService.getCacheInstance("wallet.blockchain.transaction");
        ExoCache receiptCache = cacheService.getCacheInstance("wallet.blockchain.transactionReceipt");
        this.transactionFutureCache = new FutureExoCache((context, hash) -> this.getTransactionFromBlockchain((String)hash), transactionCache);
        this.receiptFutureCache = new FutureExoCache((context, hash) -> this.getTransactionReceiptFromBlockchain((String)hash), receiptCache);
    }

    public void start() {
        this.websocketURL = WalletUtils.getWebsocketURL();
        this.networkId = WalletUtils.getNetworkId();
        if (RxJavaPlugins.getErrorHandler() == null) {
            RxJavaPlugins.setErrorHandler(e -> {
                if (e instanceof UndeliverableException) {
                    e = e.getCause();
                }
                LOG.warn((Object)"Unhandeled error happened while communicating with blockchain", e);
            });
        }
        if (this.permanentlyScanBlockchain) {
            this.startPeriodicConnectionVerifier();
        }
        this.subscriptionVerifierExecutor.scheduleWithFixedDelay(this::checkSubscription, this.getPollingInterval(), this.getPollingInterval(), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.serviceStopping = true;
        this.connectionVerifierExecutor.shutdownNow();
        this.subscriptionVerifierExecutor.shutdownNow();
        this.stopListeningToBlockchain();
        this.closeConnection();
    }

    public boolean isPermanentlyScanBlockchain() {
        return this.permanentlyScanBlockchain;
    }

    public boolean isListeningToBlockchain() {
        return this.listeningToBlockchain;
    }

    public synchronized Transaction getTransaction(String transactionHash) {
        return (Transaction)this.transactionFutureCache.get(null, (Object)StringUtils.lowerCase((String)transactionHash));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getTransactionByHash")
    public Transaction getTransactionFromBlockchain(String transactionHash) throws IOException {
        String string = transactionHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        EthereumClientConnector$AjcClosure1 ethereumClientConnector$AjcClosure1 = new EthereumClientConnector$AjcClosure1(objectArray);
        return (Transaction)ExoWalletStatisticAspect.aspectOf().around(ethereumClientConnector$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public synchronized TransactionReceipt getTransactionReceipt(String transactionHash) {
        return (TransactionReceipt)this.receiptFutureCache.get(null, (Object)StringUtils.lowerCase((String)transactionHash));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getBalance")
    public final BigInteger getEtherBalanceOf(String address) throws IOException {
        String string = address;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        EthereumClientConnector$AjcClosure3 ethereumClientConnector$AjcClosure3 = new EthereumClientConnector$AjcClosure3(objectArray);
        return (BigInteger)ExoWalletStatisticAspect.aspectOf().around(ethereumClientConnector$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getTransactionReceipt")
    public TransactionReceipt getTransactionReceiptFromBlockchain(String transactionHash) throws IOException {
        String string = transactionHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        EthereumClientConnector$AjcClosure5 ethereumClientConnector$AjcClosure5 = new EthereumClientConnector$AjcClosure5(objectArray);
        return (TransactionReceipt)ExoWalletStatisticAspect.aspectOf().around(ethereumClientConnector$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_blockNumber")
    public long getLastestBlockNumber() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        EthereumClientConnector$AjcClosure7 ethereumClientConnector$AjcClosure7 = new EthereumClientConnector$AjcClosure7(objectArray);
        return Conversions.longValue((Object)ExoWalletStatisticAspect.aspectOf().around(ethereumClientConnector$AjcClosure7.linkClosureAndJoinPoint(69648)));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_sendRawTransaction")
    public CompletableFuture<EthSendTransaction> sendTransactionToBlockchain(TransactionDetail transactionDetail) throws IOException {
        TransactionDetail transactionDetail2 = transactionDetail;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)transactionDetail2);
        Object[] objectArray = new Object[]{this, transactionDetail2, joinPoint};
        EthereumClientConnector$AjcClosure9 ethereumClientConnector$AjcClosure9 = new EthereumClientConnector$AjcClosure9(objectArray);
        return (CompletableFuture)ExoWalletStatisticAspect.aspectOf().around(ethereumClientConnector$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getTransactionCount")
    public BigInteger getNonce(String walletAddress, DefaultBlockParameterName blockParameterName) throws IOException {
        String string = walletAddress;
        DefaultBlockParameterName defaultBlockParameterName = blockParameterName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)defaultBlockParameterName);
        Object[] objectArray = new Object[]{this, string, defaultBlockParameterName, joinPoint};
        EthereumClientConnector$AjcClosure11 ethereumClientConnector$AjcClosure11 = new EthereumClientConnector$AjcClosure11(objectArray);
        return (BigInteger)ExoWalletStatisticAspect.aspectOf().around(ethereumClientConnector$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    public BigInteger getNonce(String walletAddress) throws IOException {
        return this.getNonce(walletAddress, null);
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getGasPrice")
    public BigInteger getGasPrice() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        EthereumClientConnector$AjcClosure13 ethereumClientConnector$AjcClosure13 = new EthereumClientConnector$AjcClosure13(objectArray);
        return (BigInteger)ExoWalletStatisticAspect.aspectOf().around(ethereumClientConnector$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    public Web3j getWeb3j(boolean waitUntilConnected) {
        boolean connected = this.checkConnection(false);
        if (waitUntilConnected && !connected) {
            this.waitConnection(3);
        }
        return this.web3j;
    }

    public Map<String, Object> getStatisticParameters(String statisticType, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.networkId > 0L && StringUtils.isNotBlank((CharSequence)this.websocketURL)) {
            if (this.websocketURLSuffix == null) {
                String[] urlParts = this.websocketURL.split("/");
                this.websocketURLSuffix = urlParts[urlParts.length - 1];
            }
            parameters.put("blockchain_network_url_suffix", this.websocketURLSuffix);
            parameters.put("blockchain_network_id", this.networkId);
        }
        switch (statisticType) {
            case "eth_getBalance": {
                parameters.put("address", methodArgs[0]);
                break;
            }
            case "eth_getTransactionByHash": {
                parameters.put("transaction_hash", methodArgs[0]);
                break;
            }
            case "eth_getTransactionReceipt": {
                parameters.put("transaction_hash", methodArgs[0]);
                break;
            }
            case "eth_getTransactionCount": {
                parameters.put("wallet_address", methodArgs[0]);
                break;
            }
            case "eth_getGasPrice": {
                BigInteger gasPriceInWei = (BigInteger)result;
                parameters.put("ga_price_gwei", WalletUtils.convertFromDecimals((BigInteger)BigInteger.valueOf(gasPriceInWei == null ? 0L : gasPriceInWei.longValue()), (int)9));
                break;
            }
            case "eth_blockNumber": {
                parameters.put("last_block_number", result);
                break;
            }
            case "eth_sendRawTransaction": {
                double valueAmount;
                double contractAmount;
                TransactionDetail transactionDetail = (TransactionDetail)methodArgs[0];
                String methodName = transactionDetail.getContractMethodName();
                parameters.put("hash", transactionDetail.getHash());
                parameters.put("nonce", transactionDetail.getNonce());
                parameters.put("sender", transactionDetail.getFromWallet());
                parameters.put("receiver", transactionDetail.getToWallet());
                parameters.put("gas_price", WalletUtils.convertFromDecimals((BigInteger)BigInteger.valueOf((long)transactionDetail.getGasPrice()), (int)9));
                if (StringUtils.isNotBlank((CharSequence)transactionDetail.getContractAddress())) {
                    parameters.put("contract_address", transactionDetail.getContractAddress());
                }
                if (StringUtils.isNotBlank((CharSequence)methodName)) {
                    parameters.put("contract_method", methodName);
                }
                if ((contractAmount = transactionDetail.getContractAmount()) > 0.0 && (StringUtils.equals((CharSequence)"transfer", (CharSequence)methodName) || StringUtils.equals((CharSequence)"transferFrom", (CharSequence)methodName))) {
                    parameters.put("amount_token", contractAmount);
                }
                if (!((valueAmount = transactionDetail.getValue()) > 0.0)) break;
                parameters.put("amount_ether", valueAmount);
                break;
            }
            case "eth_newFilter": 
            case "getFilterLogs": 
            case "eth_getFilterChanges": 
            case "eth_uninstallFilter": {
                break;
            }
            default: {
                LOG.warn("Statistic type {} not managed", new Object[]{statisticType});
                return null;
            }
        }
        return parameters;
    }

    public synchronized Future<Disposable> renewTransactionListeningSubscription(long lastWatchedBlockNumber) {
        this.setLastWatchedBlockNumber(lastWatchedBlockNumber);
        return this.renewTransactionListeningSubscription();
    }

    public synchronized void cancelTransactionListeningToBlockchain() {
        this.stopListeningToBlockchain();
        this.stopPeriodicConnectionVerifier();
    }

    public void setPollingInterval(long pollingInterval) {
        if (pollingInterval < 2000L) {
            throw new IllegalStateException("Polling interval " + pollingInterval + " shouldn't be less than block time 2000");
        }
        this.pollingInterval = pollingInterval;
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public void setLastWatchedBlockNumber(long blockNumber) {
        this.lastWatchedBlockNumber = Math.max(this.lastWatchedBlockNumber, blockNumber);
    }

    public long getLastWatchedBlockNumber() {
        return this.lastWatchedBlockNumber;
    }

    protected void setWebSocketClient(WebSocketClient webSocketClient) {
        this.webSocketClient = webSocketClient;
    }

    protected void setWeb3j(Web3j web3j) {
        this.web3j = web3j;
    }

    protected void setWeb3jService(WebSocketService web3jService) {
        this.web3jService = web3jService;
    }

    protected boolean isConnected() {
        return this.web3j != null && this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen();
    }

    protected boolean connect() throws Exception {
        return this.connect(false);
    }

    protected synchronized boolean connect(boolean periodicCheck) throws Exception {
        if (periodicCheck) {
            this.startPeriodicConnectionVerifier();
        }
        if (this.isConnected()) {
            return true;
        }
        if (this.serviceStopping) {
            LOG.info((Object)"Stopping server, thus no new connection is attempted again");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.websocketURL)) {
            LOG.info((Object)"No configured URL for Ethereum Websocket connection");
            return false;
        }
        if (!this.websocketURL.startsWith("ws:") && !this.websocketURL.startsWith("wss:")) {
            LOG.warn((Object)("Bad format for configured URL " + this.websocketURL + " for Ethereum Websocket connection"));
            return false;
        }
        if (this.web3j != null && this.web3jService != null && this.webSocketClient != null) {
            LOG.info("Reconnect to blockchain endpoint {}", new Object[]{this.websocketURL});
            return this.webSocketClient.reconnectBlocking();
        }
        LOG.info("Connecting to Ethereum network endpoint {}", new Object[]{this.websocketURL});
        this.webSocketClient = new WebSocketClient(new URI(this.websocketURL));
        this.webSocketClient.setConnectionLostTimeout(10);
        this.web3jService = new WebSocketService(this.webSocketClient, true);
        this.webSocketClient.setListener(new WebSocketListener(){

            public void onMessage(String message) throws IOException {
                LOG.debug("A new message is delivered from blockchain: {}", new Object[]{message});
            }

            public void onError(Exception e) {
                LOG.warn("Error connecting to blockchain: {}", new Object[]{e == null ? "" : e.getMessage()});
            }

            public void onClose() {
                LOG.debug((Object)"Blockchain websocket connection closed");
            }
        });
        this.web3jService.connect();
        this.web3j = Web3j.build((Web3jService)this.web3jService, (long)this.getPollingInterval(), (ScheduledExecutorService)Async.defaultExecutorService());
        LOG.info("Connection established to Ethereum network endpoint {}", new Object[]{this.websocketURL});
        return true;
    }

    protected boolean checkConnection(boolean periodicCheck) {
        try {
            return this.connect(periodicCheck);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            LOG.warn("Error while connecting to Etherreum Websocket endpoint: {}", new Object[]{e.getMessage()});
        }
        return false;
    }

    protected void closeConnection() {
        if (this.web3j != null) {
            LOG.info((Object)"Closing blockchain connection");
            try {
                this.web3j.shutdown();
                this.web3j = null;
                this.web3jService = null;
                this.webSocketClient = null;
            }
            catch (Throwable e) {
                LOG.warn("Error closing old web3j connection: {}", new Object[]{e.getMessage()});
            }
        }
        if (this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen()) {
            try {
                this.web3jService.close();
                this.web3jService = null;
                this.webSocketClient = null;
            }
            catch (Throwable e1) {
                LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
            }
        }
        if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
            try {
                this.webSocketClient.close();
                this.webSocketClient = null;
            }
            catch (Throwable e1) {
                LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
            }
        }
    }

    protected void setListenerService(ListenerService listenerService) {
        this.listenerService = listenerService;
    }

    protected ScheduledFuture<?> getConnectionVerifierFuture() {
        return this.connectionVerifierFuture;
    }

    protected synchronized void checkSubscription() {
        if (this.listeningToBlockchain && !this.subscriptionInProgress) {
            this.renewSubscriptionWhenDisposed();
        }
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_getFilterChanges")
    protected void renewSubscriptionWhenDisposed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        EthereumClientConnector$AjcClosure15 ethereumClientConnector$AjcClosure15 = new EthereumClientConnector$AjcClosure15(objectArray);
        ExoWalletStatisticAspect.aspectOf().around(ethereumClientConnector$AjcClosure15.linkClosureAndJoinPoint(69648));
    }

    protected void waitConnection(int tentatives) {
        if (StringUtils.isBlank((CharSequence)this.websocketURL)) {
            throw new IllegalStateException("No websocket connection is configured for ethereum blockchain");
        }
        if (this.serviceStopping) {
            throw new IllegalStateException("Server is stopping, thus no Web3 request should be emitted");
        }
        while (!this.isConnected() && !Thread.currentThread().isInterrupted() && tentatives-- > 0) {
            try {
                Thread.sleep(5000L);
                if (this.connect()) continue;
                LOG.debug((Object)"Wait until Websocket connection to blockchain is established to retrieve information");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOG.warn("Error while connecting to Etherreum Websocket endpoint: {}", new Object[]{e.getMessage()});
            }
        }
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_newFilter")
    protected Future<Disposable> subscribeToBlockchain() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        EthereumClientConnector$AjcClosure17 ethereumClientConnector$AjcClosure17 = new EthereumClientConnector$AjcClosure17(objectArray);
        return (Future)ExoWalletStatisticAspect.aspectOf().around(ethereumClientConnector$AjcClosure17.linkClosureAndJoinPoint(69648));
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="getFilterLogs")
    protected Disposable subscribeToBlockchain(DefaultBlockParameterNumber lastWatchedBlock) {
        DefaultBlockParameterNumber defaultBlockParameterNumber = lastWatchedBlock;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)defaultBlockParameterNumber);
        Object[] objectArray = new Object[]{this, defaultBlockParameterNumber, joinPoint};
        EthereumClientConnector$AjcClosure19 ethereumClientConnector$AjcClosure19 = new EthereumClientConnector$AjcClosure19(objectArray);
        return (Disposable)ExoWalletStatisticAspect.aspectOf().around(ethereumClientConnector$AjcClosure19.linkClosureAndJoinPoint(69648));
    }

    protected synchronized void stopListeningToBlockchain() {
        try {
            if (this.ethFilterSubscribtion != null && !this.ethFilterSubscribtion.isDisposed()) {
                LOG.info((Object)"Close mined contract transactions subscription");
                try {
                    this.uninstallFilter();
                }
                catch (Exception e) {
                    LOG.warn("Error when closing old subscription", new Object[]{e.getMessage()});
                }
            }
        }
        finally {
            this.listeningToBlockchain = false;
        }
    }

    @ExoWalletStatistic(service="blockchain", local=false, operation="eth_uninstallFilter")
    protected void uninstallFilter() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        EthereumClientConnector$AjcClosure21 ethereumClientConnector$AjcClosure21 = new EthereumClientConnector$AjcClosure21(objectArray);
        ExoWalletStatisticAspect.aspectOf().around(ethereumClientConnector$AjcClosure21.linkClosureAndJoinPoint(69648));
    }

    private synchronized void startPeriodicConnectionVerifier() {
        if (this.connectionVerifierFuture == null) {
            LOG.info((Object)"Start periodic WebSocket endpoint connection status check");
            this.connectionVerifierFuture = this.connectionVerifierExecutor.scheduleWithFixedDelay(() -> this.checkConnection(false), 0L, 30L, TimeUnit.SECONDS);
        }
    }

    private void stopPeriodicConnectionVerifier() {
        if (this.connectionVerifierFuture != null && !this.permanentlyScanBlockchain) {
            this.connectionVerifierFuture.cancel(false);
            this.connectionVerifierFuture = null;
            LOG.info((Object)"Stop periodic WebSocket endpoint connection status check");
        }
    }

    private Future<Disposable> renewTransactionListeningSubscription() {
        try {
            this.checkConnection(true);
            if (!this.listeningToBlockchain || !this.subscriptionInProgress && (this.ethFilterSubscribtion == null || this.ethFilterSubscribtion.isDisposed())) {
                this.stopListeningToBlockchain();
                Future<Disposable> future = this.subscribeToBlockchain();
                return future;
            }
        }
        finally {
            this.listeningToBlockchain = true;
        }
        return null;
    }

    private void handleNewContractTransactionMined(org.web3j.protocol.core.methods.response.Log log) throws Exception {
        String transactionHash = log.getTransactionHash();
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            return;
        }
        long blockNumber = log.getBlockNumber().longValue();
        this.setLastWatchedBlockNumber(blockNumber);
        this.getListenerService().broadcast("exo.wallet.transaction.minedForContract", null, (Object)new ContractTransactionEvent(transactionHash, log.getAddress(), log.getData(), log.getTopics(), blockNumber));
    }

    private DefaultBlockParameterNumber getLastWatchedBlock() {
        return new DefaultBlockParameterNumber(this.lastWatchedBlockNumber);
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }

    static {
        EthereumClientConnector.ajc$preClinit();
        LOG = ExoLogger.getLogger(EthereumClientConnector.class);
    }

    static /* synthetic */ Transaction getTransactionFromBlockchain_aroundBody0(EthereumClientConnector ajc$this, String transactionHash, JoinPoint joinPoint) {
        EthTransaction ethTransaction = (EthTransaction)ajc$this.getWeb3j(true).ethGetTransactionByHash(transactionHash).send();
        return ethTransaction == null ? null : (Transaction)ethTransaction.getResult();
    }

    static /* synthetic */ BigInteger getEtherBalanceOf_aroundBody2(EthereumClientConnector ajc$this, String address, JoinPoint joinPoint) {
        return ((EthGetBalance)ajc$this.getWeb3j(true).ethGetBalance(address, (DefaultBlockParameter)DefaultBlockParameterName.LATEST).send()).getBalance();
    }

    static /* synthetic */ TransactionReceipt getTransactionReceiptFromBlockchain_aroundBody4(EthereumClientConnector ajc$this, String transactionHash, JoinPoint joinPoint) {
        EthGetTransactionReceipt ethGetTransactionReceipt = (EthGetTransactionReceipt)ajc$this.getWeb3j(true).ethGetTransactionReceipt(transactionHash).send();
        return ethGetTransactionReceipt == null ? null : (TransactionReceipt)ethGetTransactionReceipt.getResult();
    }

    static /* synthetic */ long getLastestBlockNumber_aroundBody6(EthereumClientConnector ajc$this, JoinPoint joinPoint) {
        try {
            BigInteger blockNumber = ((EthBlockNumber)ajc$this.getWeb3j(true).ethBlockNumber().send()).getBlockNumber();
            return blockNumber.longValue();
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection error with Blockchain while attempting to retrieve block number", e);
        }
    }

    static /* synthetic */ CompletableFuture sendTransactionToBlockchain_aroundBody8(EthereumClientConnector ajc$this, TransactionDetail transactionDetail, JoinPoint joinPoint) {
        return ajc$this.getWeb3j(false).ethSendRawTransaction(transactionDetail.getRawTransaction()).sendAsync();
    }

    static /* synthetic */ BigInteger getNonce_aroundBody10(EthereumClientConnector ajc$this, String walletAddress, DefaultBlockParameterName blockParameterName, JoinPoint joinPoint) {
        if (blockParameterName == null) {
            blockParameterName = DefaultBlockParameterName.LATEST;
        }
        return ((EthGetTransactionCount)ajc$this.getWeb3j(false).ethGetTransactionCount(walletAddress, (DefaultBlockParameter)blockParameterName).send()).getTransactionCount();
    }

    static /* synthetic */ BigInteger getGasPrice_aroundBody12(EthereumClientConnector ajc$this, JoinPoint joinPoint) {
        return ((EthGasPrice)ajc$this.getWeb3j(false).ethGasPrice().send()).getGasPrice();
    }

    static /* synthetic */ void renewSubscriptionWhenDisposed_aroundBody14(EthereumClientConnector ajc$this, JoinPoint joinPoint) {
        if (ajc$this.ethFilterSubscribtion == null || ajc$this.ethFilterSubscribtion.isDisposed()) {
            try {
                if (ajc$this.checkConnection(false)) {
                    ajc$this.subscribeToBlockchain().get();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                LOG.warn((Object)"Error subscribing to blockchain", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Future subscribeToBlockchain_aroundBody16(EthereumClientConnector ajc$this, JoinPoint joinPoint) {
        ajc$this.listeningToBlockchain = true;
        ajc$this.subscriptionInProgress = true;
        LOG.info("Start watching mined contract transactions from blockchain from block '{}'", new Object[]{ajc$this.lastWatchedBlockNumber});
        DefaultBlockParameterNumber lastWatchedBlock = ajc$this.getLastWatchedBlock();
        return CompletableFuture.supplyAsync(() -> this.subscribeToBlockchain(lastWatchedBlock));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ Disposable subscribeToBlockchain_aroundBody18(EthereumClientConnector ajc$this, DefaultBlockParameterNumber lastWatchedBlock, JoinPoint joinPoint) {
        try {
            EthFilter ethFilter = new EthFilter((DefaultBlockParameter)lastWatchedBlock, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, WalletUtils.getContractAddress());
            ethFilter.addSingleTopic(EventEncoder.encode((Event)MeedsToken.TRANSFER_EVENT));
            Flowable flowable = ajc$this.getWeb3j(true).ethLogFlowable(ethFilter);
            Disposable disposable = ajc$this.ethFilterSubscribtion = flowable.subscribe(ajc$this::handleNewContractTransactionMined, exception -> LOG.debug((Object)"Error event received when watching events on contract", exception));
            return disposable;
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while subscribing to Blockchain Filter Contract events", (Throwable)e);
            Disposable disposable = null;
            return disposable;
        }
        finally {
            ajc$this.subscriptionInProgress = false;
        }
    }

    static /* synthetic */ void uninstallFilter_aroundBody20(EthereumClientConnector ajc$this, JoinPoint joinPoint) {
        ajc$this.ethFilterSubscribtion.dispose();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EthereumClientConnector.java", EthereumClientConnector.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransactionFromBlockchain", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "transactionHash", "java.io.IOException", "org.web3j.protocol.core.methods.response.Transaction"), 222);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "getEtherBalanceOf", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "address", "java.io.IOException", "java.math.BigInteger"), 238);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "uninstallFilter", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "", "", "", "void"), 646);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTransactionReceiptFromBlockchain", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "java.lang.String", "transactionHash", "java.io.IOException", "org.web3j.protocol.core.methods.response.TransactionReceipt"), 250);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLastestBlockNumber", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "", "", "", "long"), 260);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "sendTransactionToBlockchain", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "org.exoplatform.wallet.model.transaction.TransactionDetail", "transactionDetail", "java.io.IOException", "java.util.concurrent.CompletableFuture"), 279);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNonce", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "java.lang.String:org.web3j.protocol.core.DefaultBlockParameterName", "walletAddress:blockParameterName", "java.io.IOException", "java.math.BigInteger"), 296);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getGasPrice", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "", "", "java.io.IOException", "java.math.BigInteger"), 320);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "renewSubscriptionWhenDisposed", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "", "", "", "void"), 565);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "subscribeToBlockchain", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "", "", "", "java.util.concurrent.Future"), 601);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "subscribeToBlockchain", "org.exoplatform.wallet.blockchain.service.EthereumClientConnector", "org.web3j.protocol.core.DefaultBlockParameterNumber", "lastWatchedBlock", "", "io.reactivex.disposables.Disposable"), 611);
    }
}

