/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.LogicalFilter;
import org.apache.sis.internal.geoapi.filter.Literal;
import org.apache.sis.internal.geoapi.filter.LogicalOperator;
import org.apache.sis.internal.geoapi.filter.LogicalOperatorName;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.resources.Errors;

public class Optimization {
    private static final Object COMPUTING = Void.TYPE;
    private DefaultFeatureType featureType;
    private Map<Object, Object> done;

    public DefaultFeatureType getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(DefaultFeatureType defaultFeatureType) {
        this.featureType = defaultFeatureType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> Filter<? super R> apply(Filter<R> filter) {
        boolean bl;
        if (!(filter instanceof OnFilter)) {
            return filter;
        }
        boolean bl2 = bl = this.done == null;
        if (bl) {
            this.done = new IdentityHashMap<Object, Object>();
        }
        try {
            Object object = this.done.putIfAbsent(filter, COMPUTING);
            if (object == COMPUTING) {
                throw new IllegalArgumentException(Errors.format((short)123, filter.getOperatorType()));
            }
            Filter filter2 = (Filter)object;
            if (filter2 == null && this.done.put(filter, filter2 = ((OnFilter)filter).optimize(this)) != COMPUTING) {
                throw new ConcurrentModificationException();
            }
            Filter filter3 = filter2;
            return filter3;
        }
        finally {
            if (bl) {
                this.done = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, V> Expression<? super R, ? extends V> apply(Expression<R, V> expression) {
        boolean bl;
        if (!(expression instanceof OnExpression)) {
            return expression;
        }
        boolean bl2 = bl = this.done == null;
        if (bl) {
            this.done = new IdentityHashMap<Object, Object>();
        }
        try {
            Object object = this.done.putIfAbsent(expression, COMPUTING);
            if (object == COMPUTING) {
                throw new IllegalArgumentException(Errors.format((short)123, (Object)expression.getFunctionName()));
            }
            Expression expression2 = (Expression)object;
            if (expression2 == null && this.done.put(expression, expression2 = ((OnExpression)expression).optimize(this)) != COMPUTING) {
                throw new ConcurrentModificationException();
            }
            Expression expression3 = expression2;
            return expression3;
        }
        finally {
            if (bl) {
                this.done = null;
            }
        }
    }

    public <R> List<Filter<? super R>> applyAndDecompose(Filter<R> filter) {
        return Optimization.toAndOperands(this.apply(filter));
    }

    private static <R> List<Filter<? super R>> toAndOperands(Filter<R> filter) {
        Filter<R> filter2;
        if (filter == null) {
            return Collections.emptyList();
        }
        Enum<?> enum_ = filter.getOperatorType();
        if (enum_ == LogicalOperatorName.AND) {
            return ((LogicalOperator)filter).getOperands();
        }
        if (enum_ == LogicalOperatorName.NOT && (filter2 = Optimization.getNotOperand(filter)).getOperatorType() == LogicalOperatorName.OR) {
            List list = ((LogicalOperator)filter2).getOperands();
            ArrayList<Filter<R>> arrayList = new ArrayList<Filter<R>>(list.size());
            for (Filter filter3 : list) {
                filter3 = filter3.getOperatorType() == LogicalOperatorName.NOT ? Optimization.getNotOperand(filter3) : new LogicalFilter.Not(filter3);
                arrayList.add(filter3);
            }
            return arrayList;
        }
        return Collections.singletonList(filter);
    }

    private static <R> Filter<? super R> getNotOperand(Filter<R> filter) {
        Filter filter2 = (Filter)CollectionsExt.singletonOrNull(((LogicalOperator)filter).getOperands());
        if (filter2 != null) {
            return filter2;
        }
        throw new IllegalArgumentException();
    }

    public static <R, V> Expression<R, V> literal(V v) {
        return new LeafExpression.Literal(v);
    }

    public static interface OnFilter<R>
    extends Filter<R> {
        default public Filter<? super R> optimize(Optimization optimization) {
            List list = this.getExpressions();
            Expression[] expressionArray = new Expression[list.size()];
            boolean bl = true;
            boolean bl2 = true;
            for (int i = 0; i < expressionArray.length; ++i) {
                Expression expression = list.get(i);
                bl &= expression == (expression = optimization.apply(expression));
                bl2 &= expression instanceof Literal;
                expressionArray[i] = expression;
            }
            if (bl2) {
                return this.test(null) ? Filter.include() : Filter.exclude();
            }
            if (bl) {
                return this;
            }
            return this.recreate(expressionArray);
        }

        default public Filter<R> recreate(Expression<? super R, ?>[] expressionArray) {
            return this;
        }

        @Override
        default public Predicate<R> and(Predicate<? super R> predicate) {
            if (predicate instanceof Filter) {
                return new LogicalFilter.And(this, (Filter)predicate);
            }
            return Filter.super.and(predicate);
        }

        @Override
        default public Predicate<R> or(Predicate<? super R> predicate) {
            if (predicate instanceof Filter) {
                return new LogicalFilter.Or(this, (Filter)predicate);
            }
            return Filter.super.and(predicate);
        }

        @Override
        default public Predicate<R> negate() {
            return new LogicalFilter.Not(this);
        }
    }

    public static interface OnExpression<R, V>
    extends Expression<R, V> {
        default public Expression<? super R, ? extends V> optimize(Optimization optimization) {
            List list = this.getParameters();
            Expression[] expressionArray = new Expression[list.size()];
            boolean bl = true;
            boolean bl2 = true;
            for (int i = 0; i < expressionArray.length; ++i) {
                Expression expression = list.get(i);
                bl &= expression == (expression = optimization.apply(expression));
                bl2 &= expression instanceof Literal;
                expressionArray[i] = expression;
            }
            if (bl2) {
                return Optimization.literal(this.apply(null));
            }
            if (bl) {
                return this;
            }
            return this.recreate(expressionArray);
        }

        default public Expression<R, V> recreate(Expression<? super R, ?>[] expressionArray) {
            return this;
        }
    }
}

