/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.webdav.command.acl.ACLProperties;
import org.exoplatform.services.jcr.webdav.resource.FileResource;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.resource.IllegalResourceTypeException;
import org.exoplatform.services.jcr.webdav.resource.Resource;
import org.exoplatform.services.jcr.webdav.resource.ResourceUtil;
import org.exoplatform.services.jcr.webdav.resource.VersionedCollectionResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedFileResource;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CollectionResource
extends GenericResource {
    final String PREFIX = "sv:";
    final String XML_NODE = "sv:node";
    final String XML_IS_FILE = "sv:isFile";
    final String XML_NAME = "sv:name";
    final String XML_PROPERTY = "sv:property";
    final String XML_HREF = "xlink:href";
    static final String XML_PARENT_HREF = "xlink:parent-href";
    final String PREFIX_XMLNS = "xmlns:sv";
    final String PREFIX_LINK = "http://www.jcp.org/jcr/sv/1.0";
    final String XLINK_XMLNS = "xmlns:xlink";
    final String XLINK_LINK = "http://www.w3.org/1999/xlink";
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.webdav.CollectionResource");
    protected static final Set<String> COLLECTION_SKIP = new HashSet<String>();
    protected final Node node;

    public CollectionResource(URI identifier, Node node, WebDavNamespaceContext namespaceContext) throws IllegalResourceTypeException, RepositoryException {
        this(2, identifier, node, new WebDavNamespaceContext(node.getSession()));
    }

    protected CollectionResource(int type, URI identifier, Node node, WebDavNamespaceContext namespaceContext) throws IllegalResourceTypeException, RepositoryException {
        super(type, identifier, new WebDavNamespaceContext(node.getSession()));
        this.node = node;
    }

    @Override
    public Set<HierarchicalProperty> getProperties(boolean namesOnly) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        Set<HierarchicalProperty> props = super.getProperties(namesOnly);
        PropertyIterator jcrProps = this.node.getProperties();
        while (jcrProps.hasNext()) {
            Property property = jcrProps.nextProperty();
            if (COLLECTION_SKIP.contains(property.getName())) continue;
            QName name = this.namespaceContext.createQName(property.getName());
            try {
                props.add(namesOnly ? new HierarchicalProperty(name) : this.getProperty(name));
            }
            catch (UnsupportedOperationException exc) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.error((Object)exc.getMessage(), (Throwable)exc);
            }
            catch (ClassCastException exc) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.error((Object)exc.getMessage(), (Throwable)exc);
            }
            catch (IllegalArgumentException exc) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.error((Object)exc.getMessage(), (Throwable)exc);
            }
            catch (PathNotFoundException exc) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.error((Object)exc.getMessage(), (Throwable)exc);
            }
        }
        return props;
    }

    @Override
    public HierarchicalProperty getProperty(QName name) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (name.equals(DISPLAYNAME)) {
            return new HierarchicalProperty(name, this.decodeValue(this.node.getName()) + (String)(this.node.getIndex() > 1 ? "[" + this.node.getIndex() + "]" : ""));
        }
        if (name.equals(CHILDCOUNT)) {
            return new HierarchicalProperty(name, "" + this.node.getNodes().getSize());
        }
        if (name.equals(CREATIONDATE)) {
            if (this.node.isNodeType("nt:hierarchyNode")) {
                Calendar created = this.node.getProperty("jcr:created").getDate();
                HierarchicalProperty creationDate = new HierarchicalProperty(name, created, "yyyy-MM-dd'T'HH:mm:ss'Z'");
                creationDate.setAttribute("b:dt", "dateTime.tz");
                return creationDate;
            }
            throw new PathNotFoundException("Property not found " + CREATIONDATE);
        }
        if (name.equals(HASCHILDREN)) {
            if (this.node.getNodes().getSize() > 0L) {
                return new HierarchicalProperty(name, "1");
            }
            return new HierarchicalProperty(name, "0");
        }
        if (name.equals(ISCOLLECTION)) {
            return new HierarchicalProperty(name, "1");
        }
        if (name.equals(ISFOLDER)) {
            return new HierarchicalProperty(name, "1");
        }
        if (name.equals(ISROOT)) {
            return new HierarchicalProperty(name, this.node.getDepth() == 0 ? "1" : "0");
        }
        if (name.equals(PARENTNAME)) {
            if (this.node.getDepth() == 0) {
                throw new PathNotFoundException();
            }
            return new HierarchicalProperty(name, this.node.getParent().getName());
        }
        if (name.equals(RESOURCETYPE)) {
            HierarchicalProperty collectionProp = new HierarchicalProperty(new QName("DAV:", "collection"));
            HierarchicalProperty resourceType = new HierarchicalProperty(name);
            resourceType.addChild(collectionProp);
            return resourceType;
        }
        if (name.equals(SUPPORTEDLOCK)) {
            if (!this.node.canAddMixin("mix:lockable")) {
                throw new PathNotFoundException();
            }
            return this.supportedLock();
        }
        if (name.equals(LOCKDISCOVERY)) {
            if (this.node.isLocked()) {
                String token = this.node.getLock().getLockToken();
                String owner = this.node.getLock().getLockOwner();
                return CollectionResource.lockDiscovery(token, owner, "86400");
            }
            throw new PathNotFoundException();
        }
        if (name.equals(ISVERSIONED)) {
            return new HierarchicalProperty(name, "0");
        }
        if (name.equals(SUPPORTEDMETHODSET)) {
            return this.supportedMethodSet();
        }
        if (name.equals(ORDERING_TYPE)) {
            if (this.node.getPrimaryNodeType().hasOrderableChildNodes()) {
                HierarchicalProperty orderingType = new HierarchicalProperty(name);
                HierarchicalProperty orderHref = orderingType.addChild(new HierarchicalProperty(new QName("DAV:", "href")));
                orderHref.setValue("DAV:custom");
                return orderingType;
            }
            throw new PathNotFoundException();
        }
        if (name.equals(ACLProperties.ACL)) {
            return ACLProperties.getACL((NodeImpl)this.node);
        }
        if (name.equals(OWNER)) {
            return ACLProperties.getOwner((NodeImpl)this.node);
        }
        if ("DAV:".equals(name.getNamespaceURI())) {
            throw new PathNotFoundException();
        }
        Property property = this.node.getProperty(WebDavNamespaceContext.createName(name));
        String propertyValue = property.getDefinition().isMultiple() ? (property.getValues().length > 0 ? property.getValues()[0].getString() : "") : property.getString();
        return new HierarchicalProperty(name, propertyValue);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    public List<Resource> getResources() throws RepositoryException, IllegalResourceTypeException {
        NodeIterator children = this.node.getNodes();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        while (children.hasNext()) {
            Node node = children.nextNode();
            String name = node.getName() + (String)(node.getIndex() > 1 ? "[" + node.getIndex() + "]" : "");
            if (ResourceUtil.isVersioned(node)) {
                if (ResourceUtil.isFile(node)) {
                    resources.add(new VersionedFileResource(this.childURI(name), node, this.namespaceContext));
                    continue;
                }
                resources.add(new VersionedCollectionResource(this.childURI(name), node, this.namespaceContext));
                continue;
            }
            if (ResourceUtil.isFile(node)) {
                resources.add(new FileResource(this.childURI(name), node, this.namespaceContext));
                continue;
            }
            resources.add(new CollectionResource(this.childURI(name), node, this.namespaceContext));
        }
        return resources;
    }

    protected final URI childURI(String childName) {
        String childURI = this.identifier.toASCIIString() + "/" + TextUtil.escape(childName, '%', true);
        return URI.create(childURI);
    }

    public InputStream getContentAsStream(final String rootHref) throws IOException {
        final PipedOutputStream po = new PipedOutputStream();
        PipedInputStream pi = new PipedInputStream(po);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    XMLOutputFactory factory = XMLOutputFactory.newInstance();
                    XMLStreamWriter writer = factory.createXMLStreamWriter(po, "UTF-8");
                    writer.writeStartDocument("UTF-8", "1.0");
                    writer.writeStartElement("sv:node");
                    writer.writeAttribute("xmlns:sv", "http://www.jcp.org/jcr/sv/1.0");
                    writer.writeAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
                    writer.writeAttribute("sv:name", CollectionResource.this.node.getName() + (String)(CollectionResource.this.node.getIndex() > 1 ? "[" + CollectionResource.this.node.getIndex() + "]" : ""));
                    writer.writeAttribute("sv:isFile", CollectionResource.this.checkIfFile(CollectionResource.this.node));
                    writer.writeAttribute("xlink:href", rootHref + TextUtil.escape(CollectionResource.this.node.getPath(), '%', true));
                    if (!CollectionResource.this.node.getPath().equals("/")) {
                        String nodeParentHref = rootHref + TextUtil.escape(TextUtil.parentPath(CollectionResource.this.node.getPath()), '%', true);
                        writer.writeAttribute(CollectionResource.XML_PARENT_HREF, nodeParentHref);
                    }
                    PropertyIterator pi = CollectionResource.this.node.getProperties();
                    while (pi.hasNext()) {
                        Property curProperty = pi.nextProperty();
                        writer.writeStartElement("sv:property");
                        writer.writeAttribute("sv:name", curProperty.getName());
                        String propertyHref = rootHref + curProperty.getPath();
                        writer.writeAttribute("xlink:href", propertyHref);
                        writer.writeEndElement();
                    }
                    NodeIterator ni = CollectionResource.this.node.getNodes();
                    while (ni.hasNext()) {
                        Node childNode = ni.nextNode();
                        writer.writeStartElement("sv:node");
                        writer.writeAttribute("sv:name", CollectionResource.this.decodeValue(childNode.getName()) + (String)(childNode.getIndex() > 1 ? "[" + childNode.getIndex() + "]" : ""));
                        writer.writeAttribute("sv:isFile", CollectionResource.this.checkIfFile(childNode));
                        String childNodeHref = rootHref + TextUtil.escape(childNode.getPath(), '%', true);
                        writer.writeAttribute("xlink:href", childNodeHref);
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                    writer.writeEndDocument();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)"Error has occured : ", (Throwable)e);
                }
                catch (XMLStreamException e) {
                    LOG.error((Object)"Error has occured while xml processing : ", (Throwable)e);
                }
                finally {
                    try {
                        po.flush();
                        po.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }.start();
        return pi;
    }

    private String checkIfFile(Node node) {
        return ResourceUtil.isFile(node) ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
    }

    static {
        COLLECTION_SKIP.add("jcr:created");
        COLLECTION_SKIP.add("jcr:primaryType");
    }
}

