/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksStateModificationCommand;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;

public class ChecksDisableCommandStep
extends AbstractChecksStateModificationCommand {
    public static final String[] COMMAND_NAME = new String[]{"checks", "disable"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        String string;
        Object object = commandResultsBuilder.getCommandScope();
        String string2 = ((CommandScope)object).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        if (!this.doWork(commandResultsBuilder, string2, string = ((CommandScope)object).getConfiguredValue(CHECK_NAME_ARG).getValue(), (String)(object = ((CommandScope)object).getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue()))) {
            return;
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    @Override
    public boolean validateStateModification(AbstractConfigurableRule object, String string) {
        if (!((AbstractConfigurableRule)object).isEnabled()) {
            object = String.format("\n\nCheck '%s' is already %s.  No changes made.\n", string, this.describeStateModification());
            Scope.getCurrentScope().getUI().sendMessage((String)object);
            return false;
        }
        return true;
    }

    @Override
    public String describeStateModification() {
        return "disabled";
    }

    @Override
    public void doStateModification(AbstractConfigurableRule abstractConfigurableRule) {
        abstractConfigurableRule.setEnabled(false);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Disable an enabled check for current configuration");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).required().description("Name of check to disable").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_AUTO_UPDATE_ARG = commandBuilder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("off")) {
                return object;
            }
            object = "\nWARNING:  The autoUpdate value '" + (String)object + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException((String)object);
        }).build();
    }
}

