/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationException;

public class ValidationError {
    private final String statements;
    private Statement parsedStatement;
    private Set<ValidationException> errors = new HashSet<ValidationException>();
    private ValidationCapability capability;

    public ValidationError(String string) {
        this.statements = string;
    }

    public ValidationError addError(ValidationException validationException) {
        this.errors.add(validationException);
        return this;
    }

    public ValidationError addErrors(Collection<ValidationException> collection) {
        this.errors.addAll(collection);
        return this;
    }

    public Set<ValidationException> getErrors() {
        return this.errors;
    }

    public ValidationCapability getCapability() {
        return this.capability;
    }

    public Statement getParsedStatement() {
        return this.parsedStatement;
    }

    public String getStatements() {
        return this.statements;
    }

    public void setCapability(ValidationCapability validationCapability) {
        this.capability = validationCapability;
    }

    public void setParsedStatement(Statement statement) {
        this.parsedStatement = statement;
    }

    public ValidationError withCapability(ValidationCapability validationCapability) {
        this.setCapability(validationCapability);
        return this;
    }

    public ValidationError withParsedStatement(Statement statement) {
        this.setParsedStatement(statement);
        return this;
    }

    public String toString() {
        return "ValidationError [\nstatement=" + this.statements + "\ncapability=" + (this.capability != null ? this.capability.getName() : "<null>") + "\nerrors=" + this.errors + "\n]";
    }
}

