/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserImportResultEntity
implements Cloneable {
    private long count;
    private long processedCount;
    private Map<String, String> errorMessages;
    private Map<String, List<String>> warnMessages;

    public UserImportResultEntity() {
    }

    public UserImportResultEntity(long count, long processedCount, Map<String, String> errorMessages, Map<String, List<String>> warnMessages) {
        this.count = count;
        this.processedCount = processedCount;
        this.errorMessages = errorMessages;
        this.warnMessages = warnMessages;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getProcessedCount() {
        return this.processedCount;
    }

    public void setProcessedCount(long processedCount) {
        this.processedCount = processedCount;
    }

    public Map<String, String> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(Map<String, String> errorMessages) {
        this.errorMessages = errorMessages;
    }

    public Map<String, List<String>> getWarnMessages() {
        return this.warnMessages;
    }

    public void setWarnMessages(Map<String, List<String>> warnMessages) {
        this.warnMessages = warnMessages;
    }

    public void incrementProcessed() {
        ++this.processedCount;
    }

    public void addErrorMessage(String userName, String errorMessage) {
        if (this.errorMessages == null) {
            this.errorMessages = new HashMap<String, String>();
        }
        this.errorMessages.put(userName, errorMessage);
    }

    public void addWarnMessage(String userName, String warnMessage) {
        if (this.warnMessages == null) {
            this.warnMessages = new HashMap<String, List<String>>();
        }
        this.warnMessages.computeIfAbsent(userName, key -> new ArrayList()).add(warnMessage);
    }

    public UserImportResultEntity clone() {
        Map<String, String> errorMessagesCopy = this.errorMessages == null ? null : Collections.unmodifiableMap(this.errorMessages);
        Map<String, List<String>> warnMessagesCopy = this.warnMessages == null ? null : Collections.unmodifiableMap(this.warnMessages);
        return new UserImportResultEntity(this.count, this.processedCount, errorMessagesCopy, warnMessagesCopy);
    }
}

