/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.service;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.perkstore.exception.PerkStoreException;
import org.exoplatform.perkstore.model.FileDetail;
import org.exoplatform.perkstore.model.GlobalSettings;
import org.exoplatform.perkstore.model.OrderFilter;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.model.ProductOrder;
import org.exoplatform.perkstore.model.ProductOrderModification;
import org.exoplatform.perkstore.model.ProductOrderPeriod;
import org.exoplatform.perkstore.model.Profile;
import org.exoplatform.perkstore.model.UserProductData;
import org.exoplatform.perkstore.model.UserSettings;
import org.exoplatform.perkstore.model.constant.PerkStoreError;
import org.exoplatform.perkstore.model.constant.ProductOrderModificationType;
import org.exoplatform.perkstore.model.constant.ProductOrderPeriodType;
import org.exoplatform.perkstore.model.constant.ProductOrderStatus;
import org.exoplatform.perkstore.model.constant.ProductOrderTransactionStatus;
import org.exoplatform.perkstore.service.PerkStoreWebSocketService;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.perkstore.statistic.ExoPerkStoreStatistic;
import org.exoplatform.perkstore.statistic.ExoPerkStoreStatisticAspect;
import org.exoplatform.perkstore.statistic.ExoPerkStoreStatisticService;
import org.exoplatform.perkstore.statistic.StatisticUtils;
import org.exoplatform.perkstore.storage.PerkStoreStorage;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.picocontainer.Startable;

public class PerkStoreService
implements ExoPerkStoreStatisticService,
Startable {
    private static final Log LOG;
    private static final String USERNAME_IS_MANDATORY_ERROR = "Username is mandatory";
    private static final String STATISTIC_OPERATION_SAVE_PRODUCT = "product_save";
    private static final String STATISTIC_OPERATION_SAVE_ORDER = "order_save";
    private static final String STATISTIC_OPERATION_CREATE_PRODUCT = "create_product";
    private static final String STATISTIC_OPERATION_MODIFY_PRODUCT = "modify_product";
    private static final String STATISTIC_OPERATION_CREATE_ORDER = "create_order";
    private static final String STATISTIC_OPERATION_CHANGE_STATUS = "change_order_status";
    private static final String STATISTIC_OPERATION_PAY_ORDER = "pay_order";
    private static final String STATISTIC_OPERATION_DELIVER_ORDER = "deliver_order";
    private static final String STATISTIC_OPERATION_REFUND_ORDER = "refund_order";
    private static final String STATISTIC_OPERATION_REFUND_PAY_ORDER = "refund_pay_order";
    private PerkStoreWebSocketService webSocketService;
    private PerkStoreStorage perkStoreStorage;
    private SettingService settingService;
    private ListenerService listenerService;
    private GlobalSettings storedGlobalSettings;
    private PortalContainer container;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public PerkStoreService(PerkStoreWebSocketService webSocketService, PerkStoreStorage perkStoreStorage, SettingService settingService, PortalContainer container) {
        this.perkStoreStorage = perkStoreStorage;
        this.webSocketService = webSocketService;
        this.settingService = settingService;
        this.container = container;
    }

    public void start() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            this.storedGlobalSettings = this.loadGlobalSettings();
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading perk store global settings", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
    }

    public void saveGlobalSettings(GlobalSettings settings, String username) throws Exception {
        if (!this.isPerkStoreManager(username)) {
            throw new PerkStoreException(PerkStoreError.GLOBAL_SETTINGS_MODIFICATION_DENIED, new Serializable[]{username});
        }
        List<Profile> permissionsProfiles = settings.getAccessPermissionsProfiles();
        ArrayList<Long> permissions = new ArrayList<Long>();
        settings.setAccessPermissions(permissions);
        Utils.addIdentityIdsFromProfiles(permissionsProfiles, permissions);
        permissionsProfiles = settings.getManagersProfiles();
        permissions = new ArrayList();
        settings.setManagers(permissions);
        Utils.addIdentityIdsFromProfiles(permissionsProfiles, permissions);
        permissionsProfiles = settings.getProductCreationPermissionsProfiles();
        permissions = new ArrayList();
        settings.setProductCreationPermissions(permissions);
        Utils.addIdentityIdsFromProfiles(permissionsProfiles, permissions);
        settings.setUserSettings(null);
        settings.setAccessPermissionsProfiles(null);
        settings.setManagersProfiles(null);
        settings.setProductCreationPermissionsProfiles(null);
        this.getSettingService().set(Utils.PERKSTORE_CONTEXT, Utils.PERKSTORE_SCOPE, "ADDONS_PERKSTORE_SETTINGS", SettingValue.create((String)Utils.transformToString(settings)));
        this.storedGlobalSettings = null;
        this.getListenerService().broadcast("exo.perkstore.settings.modified", (Object)this, (Object)this.getGlobalSettings());
    }

    public GlobalSettings getGlobalSettings() {
        if (this.storedGlobalSettings == null) {
            this.storedGlobalSettings = this.loadGlobalSettings();
        }
        return this.storedGlobalSettings.clone();
    }

    public GlobalSettings getGlobalSettings(String username) throws Exception {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is null");
        }
        GlobalSettings globalSettings = this.getGlobalSettings();
        if (!this.canAccessApplication(globalSettings, username)) {
            throw new PerkStoreException(PerkStoreError.GLOBAL_SETTINGS_ACCESS_DENIED, new Serializable[]{username});
        }
        UserSettings userSettings = globalSettings.getUserSettings();
        if (userSettings == null) {
            userSettings = new UserSettings();
            globalSettings.setUserSettings(userSettings);
        }
        userSettings.setCometdToken(this.webSocketService.getUserToken(username));
        userSettings.setCometdContext(this.webSocketService.getCometdContextName());
        userSettings.setCanAddProduct(this.canAddProduct(username));
        userSettings.setAdministrator(this.isPerkStoreManager(username));
        if (!userSettings.isAdministrator()) {
            globalSettings.setManagers(null);
            globalSettings.setAccessPermissions(null);
            globalSettings.setProductCreationPermissions(null);
            globalSettings.setManagersProfiles(null);
            globalSettings.setAccessPermissionsProfiles(null);
            globalSettings.setProductCreationPermissionsProfiles(null);
        }
        return globalSettings;
    }

    @ExoPerkStoreStatistic(local=true, service="perkstore", operation="product_save")
    public Product saveProduct(Product product, String username) throws Exception {
        Product product2 = product;
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)product2, (Object)string);
        return (Product)PerkStoreService.saveProduct_aroundBody1$advice(this, product2, string, joinPoint, ExoPerkStoreStatisticAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public void deleteProduct(long productId, String username) throws Exception {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("Username is null");
        }
        if (productId <= 0L) {
            throw new IllegalArgumentException("product Id should to be positive integer");
        }
        Product product = this.getProductById(productId);
        if (product == null) {
            throw new PerkStoreException(PerkStoreError.PRODUCT_NOT_EXISTS, Long.valueOf(productId));
        }
        boolean canDelete = this.canViewProduct(product, username, this.isPerkStoreManager(username));
        if (!canDelete) {
            throw new IllegalAccessException("User " + username + " isn't allowed to delete product with id " + productId);
        }
        product.setDeleted(true);
        this.perkStoreStorage.saveProduct(product, username);
    }

    public List<Product> getProducts(boolean available, String username) throws Exception {
        List<Product> products = this.perkStoreStorage.getAllProducts();
        if (products == null || products.isEmpty() || !this.canAccessApplication(this.getGlobalSettings(), username)) {
            return Collections.emptyList();
        }
        boolean isPerkstoreManager = this.isPerkStoreManager(username);
        Iterator<Product> productsIterator = products.iterator();
        while (productsIterator.hasNext()) {
            boolean canEdit;
            Product product2 = productsIterator.next();
            boolean bl = canEdit = isPerkstoreManager || this.canEditProduct(product2, username);
            if (canEdit || this.canViewProduct(product2, username, isPerkstoreManager) && product2.isEnabled()) {
                this.computeProductFields(username, product2, canEdit);
                continue;
            }
            productsIterator.remove();
        }
        if (available) {
            products = products.stream().filter(product -> product.isEnabled() && (product.isUnlimited() || product.getTotalSupply() > product.getPurchased())).collect(Collectors.toList());
        }
        return products;
    }

    public List<ProductOrder> getOrders(OrderFilter filter, String username) throws Exception {
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        boolean isProductOwner = false;
        if (!this.canAccessApplication(this.getGlobalSettings(), username)) {
            throw new PerkStoreException(PerkStoreError.GLOBAL_SETTINGS_ACCESS_DENIED, new Serializable[]{username});
        }
        if (filter.getProductId() > 0L) {
            Product product = this.getProductById(filter.getProductId());
            if (product == null) {
                throw new PerkStoreException(PerkStoreError.PRODUCT_NOT_EXISTS, Long.valueOf(filter.getProductId()));
            }
            if (!this.canViewProduct(product, username, this.isPerkStoreManager(username))) {
                throw new PerkStoreException(PerkStoreError.PRODUCT_ACCESS_DENIED, new Serializable[]{product.getTitle(), username});
            }
            isProductOwner = product.getCreator() != null && StringUtils.equals((String)product.getCreator().getId(), (String)username) || product.getReceiverMarchand() != null && StringUtils.equals((String)product.getReceiverMarchand().getId(), (String)username);
        }
        List<ProductOrder> orders = null;
        long selectedOrderId = filter.getSelectedOrderId();
        if (selectedOrderId > 0L) {
            ProductOrder order2 = this.getOrderById(selectedOrderId);
            if (order2 == null || !StringUtils.equals((String)order2.getSender().getId(), (String)username) && !this.canEditProduct(order2.getProductId(), username)) {
                throw new PerkStoreException(PerkStoreError.ORDER_ACCESS_DENIED, new Serializable[]{Long.valueOf(selectedOrderId), username});
            }
            return Collections.singletonList(order2);
        }
        boolean isPerkStoreManager = this.isPerkStoreManager(username);
        orders = this.perkStoreStorage.getOrders(username, filter, isPerkStoreManager, isProductOwner);
        if (orders != null && !orders.isEmpty()) {
            orders.stream().forEach(order -> this.computeOrderFields(null, (ProductOrder)order));
        }
        return orders;
    }

    public Long countOrders(OrderFilter filter, String username) throws Exception {
        long selectedOrderId;
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        boolean isProductOwner = false;
        if (!this.canAccessApplication(this.getGlobalSettings(), username)) {
            throw new PerkStoreException(PerkStoreError.GLOBAL_SETTINGS_ACCESS_DENIED, new Serializable[]{username});
        }
        if (filter.getProductId() > 0L) {
            Product product = this.getProductById(filter.getProductId());
            if (product == null) {
                throw new PerkStoreException(PerkStoreError.PRODUCT_NOT_EXISTS, Long.valueOf(filter.getProductId()));
            }
            if (!this.canViewProduct(product, username, this.isPerkStoreManager(username))) {
                throw new PerkStoreException(PerkStoreError.PRODUCT_ACCESS_DENIED, new Serializable[]{product.getTitle(), username});
            }
            boolean bl = isProductOwner = product.getCreator() != null && StringUtils.equals((String)product.getCreator().getId(), (String)username) || product.getReceiverMarchand() != null && StringUtils.equals((String)product.getReceiverMarchand().getId(), (String)username);
        }
        if ((selectedOrderId = filter.getSelectedOrderId()) > 0L) {
            ProductOrder order = this.getOrderById(selectedOrderId);
            if (order == null || !StringUtils.equals((String)order.getSender().getId(), (String)username) && !this.canEditProduct(order.getProductId(), username)) {
                throw new PerkStoreException(PerkStoreError.ORDER_ACCESS_DENIED, new Serializable[]{Long.valueOf(selectedOrderId), username});
            }
            return 1L;
        }
        boolean isPerkStoreManager = this.isPerkStoreManager(username);
        return this.perkStoreStorage.countOrders(username, filter, isPerkStoreManager, isProductOwner);
    }

    public Long countUserOrders(OrderFilter filter, String username) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        return this.perkStoreStorage.countOrders(username, filter, false, false);
    }

    public void checkCanCreateOrder(ProductOrder order, String username) throws PerkStoreException {
        if (order == null) {
            throw new IllegalArgumentException("Order is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_ERROR);
        }
        Product product = this.getProductById(order.getProductId());
        if (product == null) {
            throw new PerkStoreException(PerkStoreError.PRODUCT_NOT_EXISTS, Long.valueOf(order.getProductId()));
        }
        if (!product.isEnabled()) {
            throw new PerkStoreException(PerkStoreError.PRODUCT_IS_DISABLED, new Serializable[]{product.getTitle()});
        }
        if (order.getId() != 0L) {
            throw new PerkStoreException(PerkStoreError.ORDER_MODIFICATION_DENIED, new Serializable[]{username, product.getTitle()});
        }
        if (!Utils.isUserMemberOf(username, this.getGlobalSettings().getAccessPermissionsProfiles()) || !Utils.isUserMemberOf(username, product.getAccessPermissions())) {
            throw new PerkStoreException(PerkStoreError.ORDER_MODIFICATION_DENIED, new Serializable[]{username, product.getTitle()});
        }
        if (StringUtils.isBlank((String)order.getTransactionHash())) {
            throw new PerkStoreException(PerkStoreError.ORDER_CREATION_EMPTY_TX, new Serializable[0]);
        }
        this.checkTransactionHashNotExists(product, order, username);
        order.setSender(Utils.toProfile("user", username));
        if (order.getStatus() != null) {
            throw new PerkStoreException(PerkStoreError.ORDER_CREATION_STATUS_DENIED, new Serializable[0]);
        }
        if (order.getQuantity() <= 0.0) {
            throw new PerkStoreException(PerkStoreError.ORDER_CREATION_EMPTY_QUANTITY, new Serializable[0]);
        }
        if (order.getReceiver() == null) {
            throw new PerkStoreException(PerkStoreError.ORDER_CREATION_EMPTY_RECEIVER, new Serializable[0]);
        }
        if (order.getSender() == null) {
            throw new PerkStoreException(PerkStoreError.ORDER_CREATION_EMPTY_SENDER, new Serializable[0]);
        }
        if (!this.canViewProduct(product, username, false)) {
            throw new PerkStoreException(PerkStoreError.ORDER_CREATION_DENIED, new Serializable[]{username, product.getTitle()});
        }
        this.checkOrderQuantity(product, order);
    }

    @ExoPerkStoreStatistic(local=true, service="perkstore", operation="create_order")
    public ProductOrder createOrder(ProductOrder order, String username) throws Exception {
        ProductOrder productOrder = order;
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)productOrder, (Object)string);
        return (ProductOrder)PerkStoreService.createOrder_aroundBody3$advice(this, productOrder, string, joinPoint, ExoPerkStoreStatisticAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoPerkStoreStatistic(local=true, service="perkstore", operation="order_save")
    public ProductOrder saveOrder(ProductOrder order, ProductOrderModificationType modificationType, String username, boolean checkUsername) throws Exception {
        ProductOrder productOrder = order;
        ProductOrderModificationType productOrderModificationType = modificationType;
        String string = username;
        boolean bl = checkUsername;
        Object[] objectArray = new Object[]{productOrder, productOrderModificationType, string, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        return (ProductOrder)PerkStoreService.saveOrder_aroundBody5$advice(this, productOrder, productOrderModificationType, string, bl, joinPoint, ExoPerkStoreStatisticAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public void saveOrderTransactionStatus(Map<String, Object> transactionDetails) throws Exception {
        if (transactionDetails == null) {
            throw new IllegalArgumentException("Transaction detail is mandatory");
        }
        String hash = (String)transactionDetails.get("hash");
        if (StringUtils.isBlank((String)hash)) {
            throw new IllegalArgumentException("Transaction hash is empty");
        }
        boolean succeeded = (Boolean)transactionDetails.get("status");
        ProductOrderModificationType modificationType = null;
        ProductOrder order = this.perkStoreStorage.findOrderByTransactionHash(hash);
        if (order == null) {
            order = this.perkStoreStorage.findOrderByRefundTransactionHash(hash);
            if (order == null || !StringUtils.equalsIgnoreCase((String)order.getRefundTransactionHash(), (String)hash)) {
                return;
            }
            order.setRefundTransactionStatus(succeeded ? ProductOrderTransactionStatus.SUCCESS.name() : ProductOrderTransactionStatus.FAILED.name());
            modificationType = ProductOrderModificationType.REFUND_TX_STATUS;
            LOG.debug("Set Refund order {} with transaction hash {} as scceeded={}", new Object[]{order.getId(), hash, succeeded});
        } else if (StringUtils.equalsIgnoreCase((String)order.getTransactionHash(), (String)hash)) {
            order.setTransactionStatus(succeeded ? ProductOrderTransactionStatus.SUCCESS.name() : ProductOrderTransactionStatus.FAILED.name());
            modificationType = ProductOrderModificationType.TX_STATUS;
            LOG.debug("Set Order {} with transaction hash {} as scceeded={}", new Object[]{order.getId(), hash, succeeded});
        }
        String contractAddress = (String)transactionDetails.get("contractAddress");
        String contractMethodName = (String)transactionDetails.get("contractMethodName");
        double contractAmount = (Double)transactionDetails.get("contractAmount");
        long fromIdentityId = (Long)transactionDetails.get("from");
        long toIdentityId = (Long)transactionDetails.get("to");
        long issuerId = (Long)transactionDetails.get("issuerId");
        if (succeeded) {
            Profile receiver;
            Profile sender = modificationType == ProductOrderModificationType.TX_STATUS ? order.getSender() : order.getReceiver();
            Profile profile = receiver = modificationType == ProductOrderModificationType.TX_STATUS ? order.getReceiver() : order.getSender();
            if (StringUtils.isBlank((String)contractAddress)) {
                order.setError(PerkStoreError.ORDER_FRAUD_NOT_TOKEN_TRANSACTION);
            } else if (!StringUtils.equals((String)"transfer", (String)contractMethodName)) {
                order.setError(PerkStoreError.ORDER_FRAUD_WRONG_TOKEN_TRANSFER_METHOD);
            } else if (sender != null && sender.getTechnicalId() != fromIdentityId) {
                order.setError(PerkStoreError.ORDER_FRAUD_WRONG_SENDER);
            } else if (receiver != null && receiver.getTechnicalId() != toIdentityId) {
                order.setError(PerkStoreError.ORDER_FRAUD_WRONG_RECEIVER);
            } else if (modificationType == ProductOrderModificationType.TX_STATUS && Math.abs(contractAmount - order.getAmount()) > 0.001) {
                order.setError(PerkStoreError.ORDER_FRAUD_WRONG_AMOUNT);
            }
            if (order.getError() != null) {
                if (modificationType == ProductOrderModificationType.TX_STATUS) {
                    order.setTransactionStatus(ProductOrderTransactionStatus.FAILED.name());
                } else {
                    order.setRefundTransactionStatus(ProductOrderTransactionStatus.FAILED.name());
                }
                this.addFraudStatistic(issuerId, hash, order);
            }
        }
        this.saveOrder(order, modificationType, null, false);
    }

    public ProductOrder getOrderById(long orderId) {
        return this.computeOrderFields(null, this.perkStoreStorage.getOrderById(orderId));
    }

    public Product getProductById(long productId, String username) throws Exception {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is madatory");
        }
        Product product = this.getProductById(productId);
        if (product == null) {
            return null;
        }
        if (this.canViewProduct(product, username, this.isPerkStoreManager(username))) {
            this.computeProductFields(username, product, this.canEditProduct(product, username));
        } else {
            product = new Product();
            product.setId(productId);
        }
        return product;
    }

    public Product getProductById(long productId) {
        return this.perkStoreStorage.getProductById(productId);
    }

    public FileDetail getFileDetail(long productId, long imageId, boolean retrieveData, String username) throws Exception {
        if (!this.canViewProduct(this.getProductById(productId), username, this.isPerkStoreManager(username))) {
            return null;
        }
        return this.perkStoreStorage.getFileDetail(productId, imageId, retrieveData);
    }

    public boolean isPerkStoreManager(String username) throws Exception {
        if (Utils.isUserAdmin(username)) {
            return true;
        }
        GlobalSettings globalSettings = this.getGlobalSettings();
        if (globalSettings != null && globalSettings.getManagers() != null && !globalSettings.getManagers().isEmpty()) {
            return Utils.hasPermission(username, globalSettings.getManagers());
        }
        return false;
    }

    public void replaceTransactions(String oldHash, String newHash) {
        this.perkStoreStorage.replaceTransactions(oldHash, newHash);
    }

    @Override
    public Map<String, Object> getStatisticParameters(String operation, Object result, Object ... methodArgs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String issuer = null;
        if (StringUtils.equals((String)STATISTIC_OPERATION_SAVE_PRODUCT, (String)operation)) {
            Product savedProduct = (Product)result;
            if (savedProduct == null) {
                return null;
            }
            Product product = (Product)methodArgs[0];
            operation = product.getId() <= 0L ? STATISTIC_OPERATION_CREATE_PRODUCT : STATISTIC_OPERATION_MODIFY_PRODUCT;
            parameters.put("operation", operation);
            parameters.put("product_id", savedProduct.getId());
            parameters.put("total_supply", savedProduct.getTotalSupply());
            parameters.put("marchand_identity_id", savedProduct.getReceiverMarchand().getTechnicalId());
            parameters.put("price", savedProduct.getPrice());
            parameters.put("enabled", savedProduct.isEnabled());
            issuer = (String)methodArgs[methodArgs.length - 1];
        } else if (StringUtils.equals((String)STATISTIC_OPERATION_CREATE_ORDER, (String)operation)) {
            savedOrder = (ProductOrder)result;
            if (savedOrder == null) {
                return null;
            }
            parameters.put("order_id", savedOrder.getId());
            parameters.put("product_id", savedOrder.getProductId());
            parameters.put("buyer_identity_id", savedOrder.getSender().getTechnicalId());
            parameters.put("marchand_identity_id", savedOrder.getReceiver().getTechnicalId());
            parameters.put("order_quantity", savedOrder.getQuantity());
            parameters.put("order_amount", savedOrder.getAmount());
            parameters.put("transaction_hash", savedOrder.getTransactionHash());
            issuer = (String)methodArgs[methodArgs.length - 1];
        } else if (StringUtils.equals((String)STATISTIC_OPERATION_SAVE_ORDER, (String)operation)) {
            savedOrder = (ProductOrder)result;
            if (savedOrder == null) {
                return null;
            }
            ProductOrderModificationType modificationType = (ProductOrderModificationType)((Object)methodArgs[1]);
            switch (modificationType) {
                case NEW: {
                    return null;
                }
                case STATUS: {
                    parameters.put("operation", STATISTIC_OPERATION_CHANGE_STATUS);
                    parameters.put("order_id", savedOrder.getId());
                    parameters.put("product_id", savedOrder.getProductId());
                    parameters.put("order_status", savedOrder.getStatus());
                    break;
                }
                case TX_STATUS: {
                    parameters.put("operation", STATISTIC_OPERATION_PAY_ORDER);
                    parameters.put("order_id", savedOrder.getId());
                    parameters.put("product_id", savedOrder.getProductId());
                    parameters.put("buyer_identity_id", savedOrder.getSender().getTechnicalId());
                    parameters.put("marchand_identity_id", savedOrder.getReceiver().getTechnicalId());
                    parameters.put("transaction_hash", savedOrder.getTransactionHash());
                    parameters.put("transaction_status", savedOrder.getTransactionStatus());
                    parameters.put("order_status", savedOrder.getStatus());
                    break;
                }
                case DELIVERED_QUANTITY: {
                    parameters.put("operation", STATISTIC_OPERATION_DELIVER_ORDER);
                    parameters.put("order_id", savedOrder.getId());
                    parameters.put("product_id", savedOrder.getProductId());
                    parameters.put("buyer_identity_id", savedOrder.getSender().getTechnicalId());
                    parameters.put("order_quantity", savedOrder.getQuantity());
                    parameters.put("delivered_order_quantity", savedOrder.getDeliveredQuantity());
                    parameters.put("refunded_order_quantity", savedOrder.getRefundedQuantity());
                    parameters.put("remaining_order_quantity", savedOrder.getRemainingQuantityToProcess());
                    parameters.put("order_status", savedOrder.getStatus());
                    break;
                }
                case REFUNDED_QUANTITY: {
                    parameters.put("operation", STATISTIC_OPERATION_REFUND_ORDER);
                    parameters.put("order_id", savedOrder.getId());
                    parameters.put("product_id", savedOrder.getProductId());
                    parameters.put("buyer_identity_id", savedOrder.getSender().getTechnicalId());
                    parameters.put("marchand_identity_id", savedOrder.getReceiver().getTechnicalId());
                    parameters.put("order_quantity", savedOrder.getQuantity());
                    parameters.put("delivered_order_quantity", savedOrder.getDeliveredQuantity());
                    parameters.put("refunded_order_quantity", savedOrder.getRefundedQuantity());
                    parameters.put("remaining_order_quantity", savedOrder.getRemainingQuantityToProcess());
                    parameters.put("order_refund_amount", savedOrder.getRefundedAmount());
                    parameters.put("refund_transaction_hash", savedOrder.getRefundTransactionHash());
                    parameters.put("order_status", savedOrder.getStatus());
                    break;
                }
                case REFUND_TX_STATUS: {
                    parameters.put("operation", STATISTIC_OPERATION_REFUND_PAY_ORDER);
                    parameters.put("order_id", savedOrder.getId());
                    parameters.put("product_id", savedOrder.getProductId());
                    parameters.put("buyer_identity_id", savedOrder.getSender().getTechnicalId());
                    parameters.put("marchand_identity_id", savedOrder.getReceiver().getTechnicalId());
                    parameters.put("refund_transaction_hash", savedOrder.getRefundTransactionHash());
                    parameters.put("refund_transaction_status", savedOrder.getRefundTransactionStatus());
                    parameters.put("order_status", savedOrder.getStatus());
                    break;
                }
            }
            issuer = (String)methodArgs[methodArgs.length - 2];
        } else {
            LOG.warn("Statistic operation type '{}' not handled", new Object[]{operation});
            return null;
        }
        if (StringUtils.isNotBlank((String)issuer)) {
            Identity identity = Utils.getIdentityByTypeAndId("organization", issuer);
            if (identity == null) {
                LOG.debug((Object)("Can't find identity with remote id: {}" + issuer));
            } else {
                parameters.put("user_social_id", identity.getId());
            }
        }
        return parameters;
    }

    private GlobalSettings loadGlobalSettings() {
        GlobalSettings globalSettings;
        SettingValue globalSettingsValue = this.getSettingService().get(Utils.PERKSTORE_CONTEXT, Utils.PERKSTORE_SCOPE, "ADDONS_PERKSTORE_SETTINGS");
        if (globalSettingsValue == null || StringUtils.isBlank((String)globalSettingsValue.getValue().toString())) {
            return new GlobalSettings();
        }
        try {
            globalSettings = Utils.fromString(GlobalSettings.class, globalSettingsValue.getValue().toString());
        }
        catch (JsonException e) {
            throw new IllegalStateException("Can't read perkstore settings", e);
        }
        if (globalSettings != null) {
            List<Long> list;
            List<Long> managers;
            List<Long> accessPermissions = globalSettings.getAccessPermissions();
            if (accessPermissions != null && !accessPermissions.isEmpty()) {
                globalSettings.setAccessPermissionsProfiles(new ArrayList<Profile>());
                for (Long l : accessPermissions) {
                    globalSettings.getAccessPermissionsProfiles().add(Utils.toProfile(l));
                }
            }
            if ((managers = globalSettings.getManagers()) != null && !managers.isEmpty()) {
                globalSettings.setManagersProfiles(new ArrayList<Profile>());
                for (Long identityId : managers) {
                    globalSettings.getManagersProfiles().add(Utils.toProfile(identityId));
                }
            }
            if ((list = globalSettings.getProductCreationPermissions()) != null && !list.isEmpty()) {
                globalSettings.setProductCreationPermissionsProfiles(new ArrayList<Profile>());
                for (Long identityId : list) {
                    globalSettings.getProductCreationPermissionsProfiles().add(Utils.toProfile(identityId));
                }
            }
        }
        return globalSettings;
    }

    private ProductOrder computeOrderFields(Product product, ProductOrder order) {
        if (order == null) {
            return null;
        }
        if (product == null) {
            product = this.getProductById(order.getProductId());
        }
        if (product == null) {
            return order;
        }
        order.setProductTitle(product.getTitle());
        return order;
    }

    private void computeRemainingQuantity(ProductOrder persistedOrder, double deliveredQuantity, double refundedQuantity) throws PerkStoreException {
        if (StringUtils.equalsIgnoreCase((String)persistedOrder.getStatus(), (String)ProductOrderStatus.CANCELED.name()) || StringUtils.equalsIgnoreCase((String)persistedOrder.getStatus(), (String)ProductOrderStatus.ERROR.name()) || StringUtils.equalsIgnoreCase((String)persistedOrder.getStatus(), (String)ProductOrderStatus.FRAUD.name())) {
            persistedOrder.setRemainingQuantityToProcess(0.0);
        } else {
            double remainingQuantityToProcess = persistedOrder.getQuantity() - refundedQuantity - deliveredQuantity;
            if (remainingQuantityToProcess < 0.0) {
                throw new PerkStoreException(PerkStoreError.ORDER_MODIFICATION_QUANTITY_INVALID_REMAINING, Double.valueOf(remainingQuantityToProcess), Long.valueOf(persistedOrder.getId()));
            }
            persistedOrder.setRemainingQuantityToProcess(remainingQuantityToProcess);
        }
    }

    private void computeProductFields(String username, Product product, boolean canEdit) {
        long productId = product.getId();
        product.setPurchased(this.perkStoreStorage.countOrderedQuantity(productId));
        UserProductData userData = new UserProductData();
        product.setUserData(userData);
        userData.setUsername(username);
        userData.setCanEdit(canEdit);
        userData.setCanOrder(StringUtils.isNotBlank((String)username) && this.canViewProduct(product, username, false));
        long identityId = 0L;
        if (StringUtils.isNotBlank((String)username)) {
            Identity currentUserIdentity = Utils.getIdentityByTypeAndId("user", username);
            identityId = Long.parseLong(currentUserIdentity.getId());
        }
        if (product.getReceiverMarchand() != null && !StringUtils.equals((String)product.getReceiverMarchand().getId(), (String)username)) {
            userData.setTotalPurchased(this.perkStoreStorage.countUserTotalPurchasedQuantity(productId, identityId));
            double purchasedQuantityInPeriod = this.countPurchasedQuantityInCurrentPeriod(product, identityId);
            userData.setPurchasedInCurrentPeriod(purchasedQuantityInPeriod);
        }
        userData.setNotProcessedOrders(this.perkStoreStorage.countRemainingOrdersToProcess(identityId, productId));
        if (userData.isCanEdit()) {
            product.setNotProcessedOrders(this.perkStoreStorage.countRemainingOrdersToProcess(productId));
        }
    }

    private double countPurchasedQuantityInCurrentPeriod(Product product, long identityId) {
        if (StringUtils.isBlank((String)product.getOrderPeriodicity())) {
            return 0.0;
        }
        ProductOrderPeriodType periodType = ProductOrderPeriodType.valueOf(product.getOrderPeriodicity().toUpperCase());
        ProductOrderPeriod period = periodType.getPeriodOfTime(LocalDateTime.now());
        return this.perkStoreStorage.countUserPurchasedQuantityInPeriod(product.getId(), identityId, period.getStartDate(), period.getEndDate());
    }

    private void checkTransactionHashNotExists(Product product, ProductOrder order, String username) throws PerkStoreException {
        ProductOrder orderWithSameTransactionHash;
        String transactionHash = order.getTransactionHash();
        if (StringUtils.isNotBlank((String)transactionHash) && (orderWithSameTransactionHash = this.perkStoreStorage.findOrderByTransactionHash(transactionHash)) != null) {
            LOG.warn((Object)(username + " is attempting to recreate an order with the same transaction hash twice " + transactionHash));
            throw new PerkStoreException(PerkStoreError.ORDER_CREATION_DENIED, new Serializable[]{username, product.getTitle()});
        }
    }

    private void checkTransactionRefundHashNotExists(Product product, ProductOrder order, String username) throws PerkStoreException {
        ProductOrder orderWithSameRefundTransactionHash;
        String transactionHash = order.getRefundTransactionHash();
        if (StringUtils.isNotBlank((String)transactionHash) && (orderWithSameRefundTransactionHash = this.perkStoreStorage.findOrderByRefundTransactionHash(transactionHash)) != null && orderWithSameRefundTransactionHash.getId() != order.getId()) {
            LOG.warn((Object)(username + " is attempting to refund an order with another order refund transaction hash " + transactionHash));
            throw new PerkStoreException(PerkStoreError.ORDER_CREATION_DENIED, new Serializable[]{username, product.getTitle()});
        }
    }

    private void checkOrderQuantity(Product product, ProductOrder productOrder) throws PerkStoreException {
        double totalSupply;
        double orderedQuantity;
        double quantity = productOrder.getQuantity();
        long productId = productOrder.getProductId();
        Profile sender = productOrder.getSender();
        String username = sender.getId();
        long identityId = sender.getTechnicalId();
        if (!product.isUnlimited() && (orderedQuantity = this.perkStoreStorage.countOrderedQuantity(productId)) + quantity > (totalSupply = product.getTotalSupply())) {
            throw new PerkStoreException(PerkStoreError.ORDER_CREATION_QUANTITY_EXCEEDS_SUPPLY, new Serializable[]{username});
        }
        double maxOrdersPerUser = product.getMaxOrdersPerUser();
        if (maxOrdersPerUser > 0.0) {
            double purchasedQuantity = 0.0;
            purchasedQuantity = product.getOrderPeriodicity() != null ? this.countPurchasedQuantityInCurrentPeriod(product, identityId) : this.perkStoreStorage.countUserTotalPurchasedQuantity(productId, identityId);
            if (purchasedQuantity + quantity > maxOrdersPerUser) {
                throw new PerkStoreException(PerkStoreError.ORDER_CREATION_QUANTITY_EXCEEDS_ALLOWED, new Serializable[]{username});
            }
        }
    }

    private void checkCanAddProduct(String username) throws Exception {
        if (!this.canAddProduct(username)) {
            throw new PerkStoreException(PerkStoreError.PRODUCT_CREATION_DENIED, new Serializable[]{username});
        }
    }

    private boolean canAccessApplication(GlobalSettings globalSettings, String username) throws Exception {
        if (StringUtils.isBlank((String)username)) {
            return false;
        }
        Identity userIdentity = Utils.getIdentityByTypeAndId("user", username);
        if (userIdentity == null) {
            return false;
        }
        if (this.isPerkStoreManager(username)) {
            return true;
        }
        return Utils.hasPermission(username, globalSettings.getAccessPermissions());
    }

    private boolean canAddProduct(String username) throws Exception {
        if (StringUtils.isBlank((String)username)) {
            return false;
        }
        GlobalSettings globalSettings = this.getGlobalSettings();
        return Utils.isUserAdmin(username) || Utils.hasPermission(username, globalSettings.getProductCreationPermissions()) && Utils.hasPermission(username, globalSettings.getAccessPermissions());
    }

    private boolean canEditProduct(long productId, String username) throws Exception {
        if (StringUtils.isBlank((String)username)) {
            return false;
        }
        Product product = this.getProductById(productId);
        return this.canEditProduct(product, username);
    }

    private boolean canEditProduct(Product product, String username) throws Exception {
        if (product == null) {
            throw new IllegalArgumentException("Product is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            return false;
        }
        if (product.getId() == 0L) {
            return this.canAddProduct(username);
        }
        if (this.isPerkStoreManager(username)) {
            return true;
        }
        List<Profile> marchands = product.getMarchands();
        if (marchands == null || marchands.isEmpty()) {
            return false;
        }
        return Utils.isUserMemberOf(username, marchands);
    }

    private boolean canViewProduct(Product product, String username, boolean isPerkStoreManager) {
        if (isPerkStoreManager) {
            return true;
        }
        if (product == null) {
            return false;
        }
        if (product.getCreator() != null && StringUtils.isNotBlank((String)username) && username.equals(product.getCreator().getId())) {
            return true;
        }
        if (StringUtils.isBlank((String)username)) {
            return false;
        }
        List<Profile> accessPermissions = product.getAccessPermissions();
        if (accessPermissions == null || accessPermissions.isEmpty()) {
            return true;
        }
        return Utils.isUserMemberOf(username, accessPermissions);
    }

    private void addFraudStatistic(long issuerId, String hash, ProductOrder order) {
        if (order.getError() != null) {
            HashMap<String, Object> statisticParameters = new HashMap<String, Object>();
            statisticParameters.put("local_service", "perkstore");
            statisticParameters.put("operation", "order_fraud");
            statisticParameters.put("user_social_id", issuerId);
            statisticParameters.put("order_id", order.getId());
            statisticParameters.put("product_id", order.getProductId());
            if (StringUtils.isNotBlank((String)hash)) {
                statisticParameters.put("fraud_transaction_hash", hash);
            }
            if (StringUtils.isNotBlank((String)order.getTransactionHash())) {
                statisticParameters.put("transaction_hash", order.getTransactionHash());
            }
            if (StringUtils.isNotBlank((String)order.getRefundTransactionHash())) {
                statisticParameters.put("refund_transaction_hash", order.getRefundTransactionHash());
            }
            statisticParameters.put("error_code", order.getError().getCode());
            statisticParameters.put("error_code_msg", order.getError().getErrorCode());
            StatisticUtils.addStatisticEntry(statisticParameters);
        }
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        }
        return this.settingService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }

    static {
        PerkStoreService.ajc$preClinit();
        LOG = ExoLogger.getLogger(PerkStoreService.class);
    }

    private static /* synthetic */ Product saveProduct_aroundBody0(PerkStoreService ajc$this, Product product, String username, JoinPoint joinPoint) {
        if (product == null) {
            throw new IllegalArgumentException("Product is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("Username is null");
        }
        boolean isNew = product.getId() == 0L;
        Product productToStore = null;
        if (isNew) {
            ajc$this.checkCanAddProduct(username);
            productToStore = new Product();
        } else {
            productToStore = ajc$this.perkStoreStorage.getProductById(product.getId());
            if (productToStore == null) {
                throw new PerkStoreException(PerkStoreError.PRODUCT_NOT_EXISTS, Long.valueOf(product.getId()));
            }
            if (!ajc$this.canEditProduct(productToStore, username)) {
                throw new PerkStoreException(PerkStoreError.PRODUCT_MODIFICATION_DENIED, new Serializable[]{username, productToStore.getTitle()});
            }
        }
        productToStore.setTitle(product.getTitle().trim());
        if (product.getIllustrationURL() != null) {
            productToStore.setIllustrationURL(product.getIllustrationURL().trim());
        } else {
            productToStore.setIllustrationURL(null);
        }
        if (product.getDescription() != null) {
            productToStore.setDescription(product.getDescription().trim());
        } else {
            productToStore.setDescription(null);
        }
        productToStore.setReceiverMarchand(product.getReceiverMarchand());
        productToStore.setAccessPermissions(product.getAccessPermissions());
        productToStore.setMarchands(product.getMarchands());
        productToStore.setEnabled(product.isEnabled());
        productToStore.setAllowFraction(product.isAllowFraction());
        productToStore.setPrice(product.getPrice());
        productToStore.setMaxOrdersPerUser(product.getMaxOrdersPerUser());
        productToStore.setImageFiles(product.getImageFiles());
        if (product.getOrderPeriodicity() != null) {
            productToStore.setOrderPeriodicity(product.getOrderPeriodicity().trim());
        } else {
            productToStore.setOrderPeriodicity(null);
        }
        productToStore.setUnlimited(product.isUnlimited());
        if (product.isUnlimited()) {
            productToStore.setTotalSupply(0.0);
        } else {
            productToStore.setTotalSupply(product.getTotalSupply());
        }
        product = ajc$this.perkStoreStorage.saveProduct(productToStore, username);
        ajc$this.getListenerService().broadcast("exo.perkstore.product.createOrModify", (Object)product, (Object)isNew);
        return product;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object saveProduct_aroundBody1$advice(PerkStoreService ajc$this, Product product, String username, JoinPoint thisJoinPoint, ExoPerkStoreStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        Product product2;
        ExoPerkStoreStatisticService statisticService = (ExoPerkStoreStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoPerkStoreStatistic annotation = method.getAnnotation(ExoPerkStoreStatistic.class);
        boolean local = annotation.local();
        String service = annotation.service();
        String operation = annotation.operation();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        Product result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            product2 = result = PerkStoreService.saveProduct_aroundBody0(ajc$this, product, username, (JoinPoint)proceedingJoinPoint);
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map<String, Object> parameters = statisticService.getStatisticParameters(operation, result, point.getArgs());
                    if (parameters == null) throw throwable;
                    if (local) {
                        parameters.put("local_service", service);
                    } else {
                        parameters.put("remote_service", service);
                    }
                    if (!parameters.containsKey("operation")) {
                        parameters.put("operation", operation);
                    }
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry(parameters);
                    throw throwable;
                }
                catch (Throwable e2) {
                    ExoPerkStoreStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_perkstore_statistic_ExoPerkStoreStatisticAspect$org_exoplatform_perkstore_statistic_ExoPerkStoreStatisticAspect$LOG().warn("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), operation, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map<String, Object> parameters = statisticService.getStatisticParameters(operation, result, point.getArgs());
            if (parameters == null) return product2;
            if (local) {
                parameters.put("local_service", service);
            } else {
                parameters.put("remote_service", service);
            }
            if (!parameters.containsKey("operation")) {
                parameters.put("operation", operation);
            }
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry(parameters);
            return product2;
        }
        catch (Throwable e) {
            ExoPerkStoreStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_perkstore_statistic_ExoPerkStoreStatisticAspect$org_exoplatform_perkstore_statistic_ExoPerkStoreStatisticAspect$LOG().warn("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), operation, e});
        }
        return product2;
    }

    private static /* synthetic */ ProductOrder createOrder_aroundBody2(PerkStoreService ajc$this, ProductOrder order, String username, JoinPoint joinPoint) {
        Profile sender;
        ajc$this.checkCanCreateOrder(order, username);
        Product product = ajc$this.getProductById(order.getProductId());
        double quantity = order.getQuantity();
        if (!product.isAllowFraction()) {
            quantity = (int)quantity;
            order.setQuantity(quantity);
        }
        if ((sender = Utils.toProfile("user", username)) == null) {
            throw new IllegalStateException("Social identity not found for user " + username);
        }
        order.setSender(sender);
        ProductOrder productOrder = new ProductOrder();
        if (quantity <= 0.0) {
            throw new IllegalStateException("Wrong order quantity: " + quantity);
        }
        productOrder.setQuantity(quantity);
        productOrder.setProductId(order.getProductId());
        double amount = quantity * product.getPrice();
        productOrder.setAmount(amount);
        productOrder.setSender(sender);
        if (order.getReceiver() != null && order.getReceiver().getTechnicalId() != product.getReceiverMarchand().getTechnicalId()) {
            productOrder.setError(PerkStoreError.ORDER_FRAUD_WRONG_RECEIVER);
            LOG.warn("Transaction receiver '{}' sent by '{}' to buy product '{}' is wrong. It must be '{}'", new Object[]{order.getReceiver(), username, product.getTitle(), product.getReceiverMarchand()});
        }
        productOrder.setReceiver(product.getReceiverMarchand());
        productOrder.setTransactionHash(Utils.formatTransactionHash(order.getTransactionHash()));
        productOrder.setTransactionStatus(StringUtils.isBlank((String)order.getTransactionHash()) ? ProductOrderTransactionStatus.NONE.name() : ProductOrderTransactionStatus.PENDING.name());
        productOrder.setRefundTransactionStatus(ProductOrderTransactionStatus.NONE.name());
        productOrder.setRemainingQuantityToProcess(quantity);
        if (productOrder.getError() != null) {
            productOrder.setStatus(ProductOrderStatus.FRAUD.name());
            productOrder.setRemainingQuantityToProcess(0.0);
        } else if (StringUtils.isBlank((String)order.getTransactionHash())) {
            productOrder.setStatus(ProductOrderStatus.CANCELED.name());
        } else {
            productOrder.setStatus(ProductOrderStatus.ORDERED.name());
        }
        ajc$this.computeRemainingQuantity(productOrder, productOrder.getDeliveredQuantity(), productOrder.getRefundedQuantity());
        productOrder = ajc$this.perkStoreStorage.saveOrder(productOrder);
        if (productOrder.getError() != null) {
            ajc$this.addFraudStatistic(sender.getTechnicalId(), productOrder.getTransactionHash(), productOrder);
        }
        ajc$this.computeOrderFields(product, productOrder);
        ajc$this.getListenerService().broadcast("exo.perkstore.order.createOrModify", (Object)product, (Object)new ProductOrderModification(Utils.toProfile("user", username), ProductOrderModificationType.NEW, null, productOrder));
        return productOrder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object createOrder_aroundBody3$advice(PerkStoreService ajc$this, ProductOrder order, String username, JoinPoint thisJoinPoint, ExoPerkStoreStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ProductOrder productOrder;
        ExoPerkStoreStatisticService statisticService = (ExoPerkStoreStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoPerkStoreStatistic annotation = method.getAnnotation(ExoPerkStoreStatistic.class);
        boolean local = annotation.local();
        String service = annotation.service();
        String operation = annotation.operation();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        ProductOrder result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            productOrder = result = PerkStoreService.createOrder_aroundBody2(ajc$this, order, username, (JoinPoint)proceedingJoinPoint);
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map<String, Object> parameters = statisticService.getStatisticParameters(operation, result, point.getArgs());
                    if (parameters == null) throw throwable;
                    if (local) {
                        parameters.put("local_service", service);
                    } else {
                        parameters.put("remote_service", service);
                    }
                    if (!parameters.containsKey("operation")) {
                        parameters.put("operation", operation);
                    }
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry(parameters);
                    throw throwable;
                }
                catch (Throwable e2) {
                    ExoPerkStoreStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_perkstore_statistic_ExoPerkStoreStatisticAspect$org_exoplatform_perkstore_statistic_ExoPerkStoreStatisticAspect$LOG().warn("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), operation, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map<String, Object> parameters = statisticService.getStatisticParameters(operation, result, point.getArgs());
            if (parameters == null) return productOrder;
            if (local) {
                parameters.put("local_service", service);
            } else {
                parameters.put("remote_service", service);
            }
            if (!parameters.containsKey("operation")) {
                parameters.put("operation", operation);
            }
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry(parameters);
            return productOrder;
        }
        catch (Throwable e) {
            ExoPerkStoreStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_perkstore_statistic_ExoPerkStoreStatisticAspect$org_exoplatform_perkstore_statistic_ExoPerkStoreStatisticAspect$LOG().warn("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), operation, e});
        }
        return productOrder;
    }

    private static /* synthetic */ ProductOrder saveOrder_aroundBody4(PerkStoreService ajc$this, ProductOrder order, ProductOrderModificationType modificationType, String username, boolean checkUsername, JoinPoint joinPoint) {
        if (order == null) {
            throw new IllegalArgumentException("Order is null");
        }
        if (modificationType == null) {
            throw new IllegalArgumentException("Order modification type is null");
        }
        if (order.getProductId() == 0L) {
            throw new PerkStoreException(PerkStoreError.ORDER_CREATION_EMPTY_PRODUCT, new Serializable[0]);
        }
        Product product = ajc$this.getProductById(order.getProductId());
        if (product == null) {
            throw new PerkStoreException(PerkStoreError.ORDER_CREATION_EMPTY_PRODUCT, new Serializable[0]);
        }
        long orderId = order.getId();
        if (orderId == 0L) {
            throw new PerkStoreException(PerkStoreError.ORDER_NOT_EXISTS, Long.valueOf(orderId));
        }
        if (checkUsername && !ajc$this.canEditProduct(order.getProductId(), username)) {
            throw new PerkStoreException(PerkStoreError.ORDER_MODIFICATION_DENIED, new Serializable[]{username, Long.valueOf(order.getProductId())});
        }
        ProductOrder orderToUpdate = ajc$this.getOrderById(orderId);
        if (orderToUpdate == null) {
            throw new PerkStoreException(PerkStoreError.ORDER_NOT_EXISTS, Long.valueOf(orderId));
        }
        ProductOrderModification productOrderModification = new ProductOrderModification(Utils.toProfile("user", username), modificationType, orderToUpdate.clone(), orderToUpdate);
        double deliveredQuantity = orderToUpdate.getDeliveredQuantity();
        double refundedQuantity = orderToUpdate.getRefundedQuantity();
        boolean broadcastOrderEvent = true;
        switch (modificationType) {
            case STATUS: {
                if (checkUsername && StringUtils.isBlank((String)username)) {
                    throw new IllegalArgumentException(USERNAME_IS_MANDATORY_ERROR);
                }
                orderToUpdate.setStatus(order.getStatus());
                break;
            }
            case DELIVERED_QUANTITY: {
                deliveredQuantity = order.getDeliveredQuantity();
                if (StringUtils.isBlank((String)username)) {
                    throw new IllegalArgumentException(USERNAME_IS_MANDATORY_ERROR);
                }
                if (deliveredQuantity < 0.0) {
                    throw new IllegalStateException("Delivered quantity can't be negative");
                }
                orderToUpdate.setDeliveredQuantity(deliveredQuantity);
                if (deliveredQuantity == 0.0) {
                    orderToUpdate.setDeliveredDate(0L);
                } else if (orderToUpdate.getDeliveredDate() == 0L) {
                    orderToUpdate.setDeliveredDate(System.currentTimeMillis());
                }
                Utils.computeOrderDeliverStatus(orderToUpdate, refundedQuantity, deliveredQuantity);
                break;
            }
            case REFUNDED_QUANTITY: {
                refundedQuantity = order.getRefundedQuantity();
                if (StringUtils.isBlank((String)username)) {
                    throw new IllegalArgumentException(USERNAME_IS_MANDATORY_ERROR);
                }
                if (refundedQuantity < 0.0) {
                    throw new IllegalStateException("Refunded quantity can't be negative");
                }
                if (order.getRefundedAmount() < 0.0) {
                    throw new IllegalStateException("Refunded quantity can't be negative");
                }
                ajc$this.checkTransactionRefundHashNotExists(product, order, username);
                orderToUpdate.setRefundTransactionHash(Utils.formatTransactionHash(order.getRefundTransactionHash()));
                orderToUpdate.setRefundTransactionStatus(ProductOrderTransactionStatus.PENDING.name());
                orderToUpdate.setRefundedQuantity(refundedQuantity);
                orderToUpdate.setRefundedAmount(order.getRefundedAmount());
                if (refundedQuantity == 0.0) {
                    orderToUpdate.setRefundedDate(0L);
                } else if (orderToUpdate.getRefundedDate() == 0L) {
                    orderToUpdate.setRefundedDate(System.currentTimeMillis());
                }
                Utils.computeOrderDeliverStatus(orderToUpdate, refundedQuantity, deliveredQuantity);
                break;
            }
            case TX_STATUS: {
                broadcastOrderEvent = !StringUtils.equals((String)order.getTransactionStatus(), (String)orderToUpdate.getTransactionStatus());
                Utils.computeOrderPaymentStatus(orderToUpdate, StringUtils.equals((String)ProductOrderTransactionStatus.SUCCESS.name(), (String)order.getTransactionStatus()));
                orderToUpdate.setTransactionStatus(order.getTransactionStatus());
                orderToUpdate.setError(order.getError());
                break;
            }
            case REFUND_TX_STATUS: {
                broadcastOrderEvent = !StringUtils.equals((String)order.getRefundTransactionStatus(), (String)orderToUpdate.getRefundTransactionStatus());
                Utils.computeOrderDeliverStatus(orderToUpdate, refundedQuantity, deliveredQuantity);
                orderToUpdate.setRefundTransactionStatus(order.getRefundTransactionStatus());
                orderToUpdate.setError(order.getError());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Order modification type '" + modificationType + "' is not supported");
            }
        }
        if (orderToUpdate.getError() != null) {
            orderToUpdate.setStatus(ProductOrderStatus.FRAUD.name());
        }
        ajc$this.computeRemainingQuantity(orderToUpdate, orderToUpdate.getDeliveredQuantity(), orderToUpdate.getRefundedQuantity());
        orderToUpdate = ajc$this.perkStoreStorage.saveOrder(orderToUpdate);
        if (broadcastOrderEvent) {
            ajc$this.computeOrderFields(product, orderToUpdate);
            ajc$this.getListenerService().broadcast("exo.perkstore.order.createOrModify", (Object)product, (Object)productOrderModification);
        }
        return orderToUpdate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object saveOrder_aroundBody5$advice(PerkStoreService ajc$this, ProductOrder order, ProductOrderModificationType modificationType, String username, boolean checkUsername, JoinPoint thisJoinPoint, ExoPerkStoreStatisticAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ProductOrder productOrder;
        ExoPerkStoreStatisticService statisticService = (ExoPerkStoreStatisticService)point.getThis();
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        ExoPerkStoreStatistic annotation = method.getAnnotation(ExoPerkStoreStatistic.class);
        boolean local = annotation.local();
        String service = annotation.service();
        String operation = annotation.operation();
        String errorMessage = null;
        long startTime = System.currentTimeMillis();
        ProductOrder result = null;
        try {
            ProceedingJoinPoint proceedingJoinPoint = point;
            productOrder = result = PerkStoreService.saveOrder_aroundBody4(ajc$this, order, modificationType, username, checkUsername, (JoinPoint)proceedingJoinPoint);
        }
        catch (RuntimeException e) {
            try {
                errorMessage = e.getMessage();
                throw e;
            }
            catch (Throwable throwable) {
                long duration2 = System.currentTimeMillis() - startTime;
                try {
                    Map<String, Object> parameters = statisticService.getStatisticParameters(operation, result, point.getArgs());
                    if (parameters == null) throw throwable;
                    if (local) {
                        parameters.put("local_service", service);
                    } else {
                        parameters.put("remote_service", service);
                    }
                    if (!parameters.containsKey("operation")) {
                        parameters.put("operation", operation);
                    }
                    if (!parameters.containsKey("duration_ms")) {
                        parameters.put("duration_ms", duration2);
                    }
                    if (parameters.containsKey("error_msg") || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errorMessage)) {
                        if (!parameters.containsKey("error_msg")) {
                            parameters.put("error_msg", errorMessage);
                        }
                        parameters.put("status", "ko");
                        parameters.put("status_code", "500");
                    } else {
                        if (!parameters.containsKey("status")) {
                            parameters.put("status", "ok");
                        }
                        if (!parameters.containsKey("status_code")) {
                            parameters.put("status_code", "200");
                        }
                    }
                    StatisticUtils.addStatisticEntry(parameters);
                    throw throwable;
                }
                catch (Throwable e2) {
                    ExoPerkStoreStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_perkstore_statistic_ExoPerkStoreStatisticAspect$org_exoplatform_perkstore_statistic_ExoPerkStoreStatisticAspect$LOG().warn("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), operation, e2});
                }
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        try {
            Map<String, Object> parameters = statisticService.getStatisticParameters(operation, result, point.getArgs());
            if (parameters == null) return productOrder;
            if (local) {
                parameters.put("local_service", service);
            } else {
                parameters.put("remote_service", service);
            }
            if (!parameters.containsKey("operation")) {
                parameters.put("operation", operation);
            }
            if (!parameters.containsKey("duration_ms")) {
                parameters.put("duration_ms", duration);
            }
            if (parameters.containsKey("error_msg") || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errorMessage)) {
                if (!parameters.containsKey("error_msg")) {
                    parameters.put("error_msg", errorMessage);
                }
                parameters.put("status", "ko");
                parameters.put("status_code", "500");
            } else {
                if (!parameters.containsKey("status")) {
                    parameters.put("status", "ok");
                }
                if (!parameters.containsKey("status_code")) {
                    parameters.put("status_code", "200");
                }
            }
            StatisticUtils.addStatisticEntry(parameters);
            return productOrder;
        }
        catch (Throwable e) {
            ExoPerkStoreStatisticAspect.ajc$inlineAccessFieldGet$org_exoplatform_perkstore_statistic_ExoPerkStoreStatisticAspect$org_exoplatform_perkstore_statistic_ExoPerkStoreStatisticAspect$LOG().warn("Error adding statistic log entry in method {} for statistic type {}", new Object[]{method.getName(), operation, e});
        }
        return productOrder;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PerkStoreService.java", PerkStoreService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveProduct", "org.exoplatform.perkstore.service.PerkStoreService", "org.exoplatform.perkstore.model.Product:java.lang.String", "product:username", "java.lang.Exception", "org.exoplatform.perkstore.model.Product"), 201);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createOrder", "org.exoplatform.perkstore.service.PerkStoreService", "org.exoplatform.perkstore.model.ProductOrder:java.lang.String", "order:username", "java.lang.Exception", "org.exoplatform.perkstore.model.ProductOrder"), 452);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveOrder", "org.exoplatform.perkstore.service.PerkStoreService", "org.exoplatform.perkstore.model.ProductOrder:org.exoplatform.perkstore.model.constant.ProductOrderModificationType:java.lang.String:boolean", "order:modificationType:username:checkUsername", "java.lang.Exception", "org.exoplatform.perkstore.model.ProductOrder"), 523);
    }
}

