/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.util;

import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageFactory;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;

public class Util {
    public static PortalRequestContext getPortalRequestContext() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (!(context instanceof PortalRequestContext)) {
            context = (WebuiRequestContext)context.getParentAppRequestContext();
        }
        return (PortalRequestContext)context;
    }

    public static UIPortalApplication getUIPortalApplication() {
        return (UIPortalApplication)Util.getPortalRequestContext().getUIApplication();
    }

    public static UIPortal getUIPortal() {
        return Util.getUIPortalApplication().getCurrentSite();
    }

    public static UIPortalToolPanel getUIPortalToolPanel() {
        return (UIPortalToolPanel)Util.getUIPortalApplication().findFirstComponentOfType(UIPortalToolPanel.class);
    }

    public static <T extends UIComponent> T showComponentOnWorking(UIComponent uicomp, Class<T> clazz) throws Exception {
        UIPortalApplication uiPortalApp = (UIPortalApplication)uicomp.getAncestorOfType(UIPortalApplication.class);
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
        UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)((UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class)).setRendered(true);
        UIComponent uiWork = uiToolPanel.createUIComponent(clazz, null, null);
        uiToolPanel.setUIComponent(uiWork);
        return (T)uiWork;
    }

    public static <T extends UIComponent> T findUIComponent(UIComponent uiComponent, Class<T> clazz, Class ignoreClazz) {
        if (clazz.isInstance(uiComponent)) {
            return (T)uiComponent;
        }
        if (!(uiComponent instanceof UIContainer)) {
            return null;
        }
        List children = ((UIContainer)uiComponent).getChildren();
        for (UIComponent child : children) {
            T value;
            if (clazz.isInstance(child)) {
                return (T)child;
            }
            if (ignoreClazz.isInstance(child) || (value = Util.findUIComponent(child, clazz, ignoreClazz)) == null) continue;
            return value;
        }
        return null;
    }

    public static void findUIComponents(UIComponent uiComponent, List<UIComponent> list, Class clazz, Class ignoreClazz) {
        if (clazz.isInstance(uiComponent)) {
            list.add(uiComponent);
        }
        if (!(uiComponent instanceof UIContainer)) {
            return;
        }
        List children = ((UIContainer)uiComponent).getChildren();
        for (UIComponent child : children) {
            if (clazz.isInstance(child)) {
                list.add(child);
                continue;
            }
            if (ignoreClazz.isInstance(child)) continue;
            Util.findUIComponents(child, list, clazz, ignoreClazz);
        }
    }

    @Deprecated
    public static UIPage toUIPage(PageNode node, UIComponent uiParent) throws Exception {
        return Util.toUIPage(node.getPageReference(), uiParent);
    }

    public static UIPage toUIPage(String pageRef, UIComponent uiParent) throws Exception {
        UserPortalConfigService configService = (UserPortalConfigService)uiParent.getApplicationComponent(UserPortalConfigService.class);
        PageContext pageContext = configService.getPage(PageKey.parse((String)pageRef));
        Page page = configService.getDataStorage().getPage(pageRef);
        pageContext.update(page);
        return Util.toUIPage(page, uiParent);
    }

    public static UIPage toUIPage(Page page, UIComponent uiParent) throws Exception {
        UIPage uiPage = (UIPage)Util.getUIPortal().findFirstComponentOfType(UIPage.class);
        if (uiPage != null && uiPage.getId().equals(page.getId())) {
            return uiPage;
        }
        PortalRequestContext context = Util.getPortalRequestContext();
        UIPageFactory clazz = UIPageFactory.getInstance(page.getFactoryId());
        uiPage = clazz.createUIPage(context);
        PortalDataMapper.toUIPage(uiPage, page);
        return uiPage;
    }

    public static void showComponentEditInBlockMode() {
        Util.updatePortalMode();
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)portalApp.findFirstComponentOfType(UIEditInlineWorkspace.class);
        UIComponent uiComponent = uiEditWS.getUIComponent();
        if (uiComponent instanceof UIPortal) {
            UIPortal uiPortal = (UIPortal)uiComponent;
            uiPortal.setMaximizedUIComponent(null);
        } else {
            UIPortalToolPanel uiPortalToolPanel = Util.getUIPortalToolPanel();
            UIPage uiPage = (UIPage)uiPortalToolPanel.findFirstComponentOfType(UIPage.class);
            if (uiPage != null) {
                Util.getPortalRequestContext().getJavascriptManager().require("SHARED/portal", "portal").addScripts("eXo.portal.UIPortal.showComponentEditInBlockMode();");
            }
        }
    }

    public static void showComponentEditInViewMode() {
        Util.updatePortalMode();
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)portalApp.findFirstComponentOfType(UIEditInlineWorkspace.class);
        UIComponent uiComponent = uiEditWS.getUIComponent();
        if (uiComponent instanceof UIPortal) {
            UIPortal uiPortal = (UIPortal)uiComponent;
            uiPortal.setMaximizedUIComponent(null);
        }
        PortalRequestContext context = Util.getPortalRequestContext();
        context.getJavascriptManager().require("SHARED/portal", "portal").addScripts("portal.UIPortal.showComponentEditInViewMode();");
    }

    public static UIWorkingWorkspace updateUIApplication(Event<? extends UIComponent> event) {
        PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
        UIPortalApplication uiPortalApp = (UIPortalApplication)((UIComponent)event.getSource()).getAncestorOfType(UIPortalApplication.class);
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
        pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        pcontext.ignoreAJAXUpdateOnPortlets(true);
        return uiWorkingWS;
    }

    public static void updatePortalMode() {
        PortalRequestContext context = Util.getPortalRequestContext();
        UIPortalApplication uiPortalApp = (UIPortalApplication)context.getUIApplication();
        boolean isShowMaxWindow = false;
        UIPage page = (UIPage)uiPortalApp.findFirstComponentOfType(UIPage.class);
        if (page != null && page.isShowMaxWindow()) {
            isShowMaxWindow = true;
        }
        context.getJavascriptManager().require("SHARED/portal", "portal").addScripts("portal.UIPortal.updatePortalMode(" + uiPortalApp.getModeState() + ", '" + uiPortalApp.getEditLevel().toString() + "', " + Boolean.toString(UIPage.isFullPreview()) + ", " + Boolean.toString(isShowMaxWindow) + ");");
    }
}

