/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jdbc.impl;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.exoplatform.services.jdbc.impl.ManagedConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ManagedDataSource
implements DataSource {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.common.ManagedDataSource");
    private final TransactionManager tm;
    private final DataSource ds;
    private final boolean checkIfTxActive;

    public ManagedDataSource(DataSource ds, TransactionManager tm, boolean checkIfTxActive) {
        this.tm = tm;
        this.ds = ds;
        this.checkIfTxActive = checkIfTxActive;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.ds.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.ds.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.ds.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.ds.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.ds.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.ds.unwrap(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection con = this.ds.getConnection();
        return this.providesManagedConnection() ? new ManagedConnection(con) : con;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection con = this.ds.getConnection(username, password);
        return this.providesManagedConnection() ? new ManagedConnection(con) : con;
    }

    private boolean isTxActive() {
        try {
            return this.tm != null && this.tm.getStatus() != 6;
        }
        catch (SystemException e) {
            LOG.warn((Object)"We cannot know if a global tx is active", (Throwable)e);
            return false;
        }
    }

    private boolean providesManagedConnection() {
        return !this.checkIfTxActive || this.isTxActive();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        try {
            Method m = this.ds.getClass().getMethod("getParentLogger", new Class[0]);
            return (Logger)m.invoke((Object)this.ds, new Object[0]);
        }
        catch (Exception e) {
            throw new SQLFeatureNotSupportedException(e);
        }
    }
}

