/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Asynchronous
public class AgendaEventGamificationIntegrationListener
extends Listener<Object, Object> {
    private static final Log LOG = ExoLogger.getLogger(AgendaEventGamificationIntegrationListener.class);
    public static final String GAMIFICATION_GENERIC_EVENT = "exo.gamification.generic.action";
    public static final String GAMIFICATION_CREATE_EVENT_RULE_TITLE = "CreateEvent";
    public static final String GAMIFICATION_UPDATE_EVENT_RULE_TITLE = "UpdateEvent";
    public static final String GAMIFICATION_CREATE_DATE_POLL_RULE_TITLE = "CreateDatePoll";
    public static final String GAMIFICATION_VOTE_RULE_TITLE = "VoteDatePoll";
    private PortalContainer container;
    private ListenerService listenerService;
    private AgendaEventService agendaEventService;

    public AgendaEventGamificationIntegrationListener(PortalContainer container, ListenerService listenerService) {
        this.container = container;
        this.listenerService = listenerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Object, Object> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String eventName = event.getEventName();
            Long eventId = null;
            Long earnerId = null;
            if (event.getSource() instanceof AgendaEventModification) {
                AgendaEventModification eventModification = (AgendaEventModification)event.getSource();
                eventId = eventModification.getEventId();
                earnerId = eventModification.getModifierId();
            } else if (event.getSource() instanceof Long) {
                eventId = (Long)event.getSource();
                earnerId = (Long)event.getData();
            }
            if (earnerId == null || eventId == null) {
                LOG.warn("Gamification points for event {} aren't collected because empty inputs: eventId: {}, modifierId: {}", new Object[]{event.getEventName(), eventId, earnerId});
                return;
            }
            org.exoplatform.agenda.model.Event agendaEvent = this.getAgendaEventService().getEventById(eventId.longValue());
            String eventURL = NotificationUtils.getEventURL(agendaEvent);
            String ruleTitle = "";
            if (agendaEvent.getStatus() == EventStatus.TENTATIVE) {
                if (StringUtils.equals((String)eventName, (String)"exo.agenda.event.poll.created")) {
                    ruleTitle = GAMIFICATION_CREATE_DATE_POLL_RULE_TITLE;
                    try {
                        HashMap<String, String> gam = new HashMap<String, String>();
                        gam.put("ruleTitle", ruleTitle);
                        gam.put("object", eventURL);
                        gam.put("senderId", String.valueOf(earnerId));
                        gam.put("receiverId", String.valueOf(earnerId));
                        this.listenerService.broadcast(GAMIFICATION_GENERIC_EVENT, gam, (Object)String.valueOf(eventId));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot broadcast gamification event", (Throwable)e);
                    }
                } else if (StringUtils.equals((String)eventName, (String)"exo.agenda.event.poll.voted.all")) {
                    ruleTitle = GAMIFICATION_VOTE_RULE_TITLE;
                    try {
                        HashMap<String, String> gam = new HashMap<String, String>();
                        gam.put("ruleTitle", ruleTitle);
                        gam.put("object", eventURL);
                        gam.put("senderId", String.valueOf(earnerId));
                        gam.put("receiverId", String.valueOf(earnerId));
                        this.listenerService.broadcast(GAMIFICATION_GENERIC_EVENT, gam, (Object)String.valueOf(eventId));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot broadcast gamification event", (Throwable)e);
                    }
                } else {
                    LOG.warn("Not recognized event name {} for Agenda Poll gamification points collection. eventId: {}, modifierId: {}", new Object[]{event.getEventName(), eventId, earnerId});
                }
            } else if (agendaEvent.getStatus() == EventStatus.CONFIRMED) {
                if (StringUtils.equals((String)eventName, (String)"exo.agenda.event.created")) {
                    ruleTitle = GAMIFICATION_CREATE_EVENT_RULE_TITLE;
                } else if (StringUtils.equals((String)eventName, (String)"exo.agenda.event.updated")) {
                    ruleTitle = GAMIFICATION_UPDATE_EVENT_RULE_TITLE;
                } else {
                    LOG.warn("Not recognized event name {} for Agenda Event gamification points collection. eventId: {}, modifierId: {}", new Object[]{event.getEventName(), eventId, earnerId});
                    return;
                }
                try {
                    HashMap<String, String> gam = new HashMap<String, String>();
                    gam.put("ruleTitle", ruleTitle);
                    gam.put("object", eventURL);
                    gam.put("senderId", String.valueOf(earnerId));
                    gam.put("receiverId", String.valueOf(earnerId));
                    this.listenerService.broadcast(GAMIFICATION_GENERIC_EVENT, gam, (Object)String.valueOf(eventId));
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot broadcast gamification event", (Throwable)e);
                }
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)ExoContainerContext.getService(AgendaEventService.class);
        }
        return this.agendaEventService;
    }
}

