/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class ProfileFilterListAccess
implements ListAccess<Identity> {
    private static final char EMPTY_CHARACTER = '\u0000';
    private IdentityStorage identityStorage;
    private ProfileFilter profileFilter;
    String providerId;
    boolean forceLoadProfile;
    Type type;

    public ProfileFilterListAccess(IdentityStorage identityStorage, String providerId, ProfileFilter profileFilter, boolean forceLoadProfile) {
        this.identityStorage = identityStorage;
        this.profileFilter = profileFilter;
        this.providerId = providerId;
        this.forceLoadProfile = forceLoadProfile;
    }

    public ProfileFilterListAccess(IdentityStorage identityStorage, String providerId, ProfileFilter profileFilter, boolean forceLoadProfile, Type type) {
        this.identityStorage = identityStorage;
        this.profileFilter = profileFilter;
        this.providerId = providerId;
        this.forceLoadProfile = forceLoadProfile;
        this.type = type;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public Identity[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        int usedLimit = limit;
        if (this.profileFilter != null && this.profileFilter.getViewerIdentity() != null) {
            ++usedLimit;
        }
        List identities = new ArrayList();
        if (this.type != null) {
            switch (this.type) {
                case UNIFIED_SEARCH: {
                    identities = this.identityStorage.getIdentitiesForUnifiedSearch(this.providerId, this.profileFilter, (long)offset, (long)usedLimit);
                    break;
                }
            }
        } else if (this.profileFilter == null || this.profileFilter.isEmpty()) {
            if (this.profileFilter == null || this.profileFilter.getViewerIdentity() == null) {
                if (this.profileFilter == null) {
                    identities = this.identityStorage.getIdentities(this.providerId, (long)offset, (long)usedLimit);
                } else {
                    firstCharFieldName = this.profileFilter.getFirstCharFieldName();
                    firstCharacter = this.profileFilter.getFirstCharacterOfName();
                    sorting = this.profileFilter.getSorting();
                    boolean isEnabled = this.profileFilter.isEnabled();
                    String userType = this.profileFilter.getUserType();
                    Boolean isConnected = this.profileFilter.isConnected();
                    String enrollmentStatus = this.profileFilter.getEnrollmentStatus();
                    String sortFieldName = sorting == null || sorting.sortBy == null ? null : sorting.sortBy.getFieldName();
                    String sortDirection = sorting == null || sorting.sortBy == null ? null : sorting.orderBy.name();
                    identities = this.identityStorage.getIdentities(this.providerId, firstCharFieldName, firstCharacter, sortFieldName, sortDirection, isEnabled, userType, isConnected, enrollmentStatus, (long)offset, (long)usedLimit);
                }
            } else {
                firstCharFieldName = this.profileFilter.getFirstCharFieldName();
                firstCharacter = this.profileFilter.getFirstCharacterOfName();
                sorting = this.profileFilter.getSorting();
                String sortFieldName = sorting == null || sorting.sortBy == null ? null : sorting.sortBy.getFieldName();
                String sortDirection = sorting == null || sorting.sortBy == null ? null : sorting.orderBy.name();
                identities = this.identityStorage.getIdentitiesWithRelationships(this.profileFilter.getViewerIdentity().getId(), firstCharFieldName, firstCharacter, sortFieldName, sortDirection, offset, usedLimit);
            }
        } else {
            identities = this.identityStorage.getIdentitiesForMentions(this.providerId, this.profileFilter, null, (long)offset, (long)usedLimit, this.forceLoadProfile);
        }
        if (this.profileFilter != null && this.profileFilter.getViewerIdentity() != null) {
            Iterator iterator = identities.iterator();
            while (iterator.hasNext()) {
                Identity identity = (Identity)iterator.next();
                if (!identity.equals((Object)this.profileFilter.getViewerIdentity())) continue;
                iterator.remove();
            }
            if (identities.size() > limit) {
                identities.remove(identities.size() - 1);
            }
        }
        return identities.toArray(new Identity[0]);
    }

    public int getSize() throws Exception {
        int size = 0;
        if (this.profileFilter.getFirstCharacterOfName() != '\u0000') {
            size = this.identityStorage.getIdentitiesByFirstCharacterOfNameCount(this.providerId, this.profileFilter);
        } else if (this.profileFilter.isEmpty()) {
            if (this.profileFilter.getViewerIdentity() == null) {
                size = this.identityStorage.getIdentitiesByProfileFilterCount(this.providerId, this.profileFilter);
            } else {
                size = this.identityStorage.countIdentitiesWithRelationships(this.profileFilter.getViewerIdentity().getId());
                --size;
            }
        } else {
            size = this.identityStorage.getIdentitiesForMentionsCount(this.providerId, this.profileFilter, null);
        }
        return size;
    }

    public static enum Type {
        ALL,
        BY_FIRST_CHARACTER_OF_NAME,
        MENTION,
        UNIFIED_SEARCH;

    }
}

