/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.plugin;

import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.metadata.FavoriteACLPlugin;

public class ActivityFavoriteACLPlugin
extends FavoriteACLPlugin {
    private static final String ACTIVITY_FAVORITE_TYPE = "activity";
    private final ActivityManager activityManager;

    public ActivityFavoriteACLPlugin(ActivityManager activityManager) {
        this.activityManager = activityManager;
    }

    public String getEntityType() {
        return ACTIVITY_FAVORITE_TYPE;
    }

    public boolean canCreateFavorite(Identity userIdentity, String objectId) {
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(objectId));
        if (activity == null) {
            throw new IllegalStateException("Activity with id " + objectId + " wasn't found");
        }
        return this.activityManager.isActivityViewable(activity, userIdentity);
    }
}

