/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.search.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.social.core.search.SearchConnector;
import org.exoplatform.social.core.search.SearchConnectorPlugin;
import org.exoplatform.social.core.search.SearchService;
import org.picocontainer.Startable;

public class SearchServiceImpl
implements SearchService,
Startable {
    private static final Context SEARCH_CONNECTORS_CONTEXT = Context.GLOBAL.id("search");
    private static final Scope SEARCH_CONNECTORS_SCOPE = Scope.APPLICATION.id("connectors");
    private static final String SEARCH_CONNECTORS_STATUS_PARAM = "enabledSearchConnectors";
    private static final String PLATFORM_EXTERNALS_GROUP = "/platform/externals";
    private SettingService settingService;
    private Set<SearchConnector> connectors = new HashSet<SearchConnector>();

    public SearchServiceImpl(SettingService settingService) {
        this.settingService = settingService;
    }

    public void start() {
        List<String> enabledTypes = this.getEnabledConnectorNames();
        if (enabledTypes != null && !enabledTypes.isEmpty()) {
            for (SearchConnector connector : this.connectors) {
                connector.setEnabled(enabledTypes.contains(connector.getName()));
            }
        }
    }

    public void stop() {
    }

    public void addConnector(SearchConnectorPlugin connectorPlugin) {
        if (connectorPlugin == null) {
            throw new IllegalArgumentException("connectorPlugin parameter is mandatory");
        }
        this.connectors.addAll(connectorPlugin.getConnectors());
    }

    public Set<SearchConnector> getConnectors() {
        return Collections.unmodifiableSet(this.connectors.stream().map(SearchConnector::clone).collect(Collectors.toSet()));
    }

    public Set<SearchConnector> getEnabledConnectors() {
        UserACL userACL = (UserACL)CommonsUtils.getService(UserACL.class);
        boolean isExternalUser = userACL.isUserInGroup(PLATFORM_EXTERNALS_GROUP);
        return Collections.unmodifiableSet(this.connectors.stream().filter(c -> c.isEnabled() && (!c.getName().equals("people") && !c.getName().equals("space") || !isExternalUser)).map(SearchConnector::clone).collect(Collectors.toSet()));
    }

    public List<String> getEnabledConnectorNames() {
        SettingValue enabledSearchTypes = this.settingService.get(SEARCH_CONNECTORS_CONTEXT, SEARCH_CONNECTORS_SCOPE, SEARCH_CONNECTORS_STATUS_PARAM);
        String enabledSearchTypesValue = enabledSearchTypes == null || enabledSearchTypes.getValue() == null ? null : enabledSearchTypes.getValue().toString();
        List<String> enabledTypes = null;
        if (StringUtils.isNotBlank((String)enabledSearchTypesValue)) {
            enabledTypes = Arrays.asList(enabledSearchTypesValue.split(",\\s*"));
        }
        return enabledTypes == null ? Collections.emptyList() : enabledTypes;
    }

    public void setConnectorAsEnabled(String name, boolean enabled) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalStateException("connector name is empty");
        }
        SearchConnector connector = this.connectors.stream().filter(conn -> StringUtils.equals((String)name, (String)conn.getName())).findFirst().orElse(null);
        if (connector == null) {
            throw new IllegalStateException("Can't find connector with name: " + name);
        }
        connector.setEnabled(enabled);
        this.storeConnectorsStatus();
    }

    private void storeConnectorsStatus() {
        StringBuilder statuses = new StringBuilder();
        for (SearchConnector searchConnector : this.connectors) {
            if (!searchConnector.isEnabled()) continue;
            statuses.append(searchConnector.getName());
        }
        this.settingService.set(SEARCH_CONNECTORS_CONTEXT, SEARCH_CONNECTORS_SCOPE, SEARCH_CONNECTORS_STATUS_PARAM, SettingValue.create((String)statuses.toString()));
    }
}

