/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.exoplatform.social.core.space.impl.SpacesAdministrationServiceImpl;

@Managed
@ManagedDescription(value="Social Spaces Administration Service manager bean")
@NameTemplate(value={@Property(key="service", value="social"), @Property(key="view", value="SpacesAdministrationService")})
@RESTEndpoint(path="spacesadministrationservice")
public class SpacesAdministrationServiceManagerBean {
    private SpacesAdministrationService spacesAdministrationService;

    public SpacesAdministrationServiceManagerBean(SpacesAdministrationServiceImpl spacesAdministrationServiceImpl) {
        this.spacesAdministrationService = spacesAdministrationServiceImpl;
    }

    @Managed
    @ManagedDescription(value="Get Spaces administrators")
    @Impact(value=ImpactType.READ)
    public List<String> getSpaceManager() {
        return this.spacesAdministrationService.getSpacesAdministratorsMemberships().stream().map(membership -> membership.toString()).collect(Collectors.toList());
    }

    @Managed
    @ManagedDescription(value="Add Spaces administrators membership")
    @Impact(value=ImpactType.WRITE)
    public void addSpaceManager(@ManagedDescription(value="Spaces super manger role") @ManagedName(value="permissionExpression") String permissionExpression) {
        ArrayList<MembershipEntry> superManagersMemberships = new ArrayList<MembershipEntry>(this.spacesAdministrationService.getSpacesAdministratorsMemberships());
        superManagersMemberships.add(MembershipEntry.parse((String)permissionExpression));
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(superManagersMemberships);
    }

    @Managed
    @ManagedDescription(value="Remove Spaces administrators membership")
    @Impact(value=ImpactType.WRITE)
    public void removeSpaceManager(@ManagedDescription(value="Spaces super manger memberships") @ManagedName(value="permissionExpression") String permissionExpression) {
        List superManagersMemberships = this.spacesAdministrationService.getSpacesAdministratorsMemberships();
        List updatedMemberships = superManagersMemberships.stream().filter(m -> !m.toString().equals(permissionExpression)).collect(Collectors.toList());
        this.spacesAdministrationService.updateSpacesAdministratorsMemberships(updatedMemberships);
    }

    @Managed
    @ManagedDescription(value="Get Spaces creators memberships")
    @Impact(value=ImpactType.READ)
    public List<String> getSpacesCreatorsMemberships() {
        return this.spacesAdministrationService.getSpacesCreatorsMemberships().stream().map(membership -> membership.toString()).collect(Collectors.toList());
    }

    @Managed
    @ManagedDescription(value="Add Spaces creators membership")
    @Impact(value=ImpactType.WRITE)
    public void addSpacesCreatorsMembership(@ManagedDescription(value="Spaces creator membership") @ManagedName(value="permissionExpression") String permissionExpression) {
        ArrayList<MembershipEntry> superCreatorsMemberships = new ArrayList<MembershipEntry>(this.spacesAdministrationService.getSpacesCreatorsMemberships());
        superCreatorsMemberships.add(MembershipEntry.parse((String)permissionExpression));
        this.spacesAdministrationService.updateSpacesCreatorsMemberships(superCreatorsMemberships);
    }

    @Managed
    @ManagedDescription(value="Remove Spaces creators membership")
    @Impact(value=ImpactType.WRITE)
    public void removeSpacesCreatorsMembership(@ManagedDescription(value="Spaces creator membership") @ManagedName(value="permissionExpression") String permissionExpression) {
        List superCreatorsMemberships = this.spacesAdministrationService.getSpacesCreatorsMemberships();
        List updatedMemberships = superCreatorsMemberships.stream().filter(m -> !m.toString().equals(permissionExpression)).collect(Collectors.toList());
        this.spacesAdministrationService.updateSpacesCreatorsMemberships(updatedMemberships);
    }
}

