/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.dataflow.persistent;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedItemData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedSize;
import org.exoplatform.services.jcr.impl.dataflow.persistent.SimplePersistedSize;

public class PersistedPropertyData
extends PersistedItemData
implements PropertyData,
Externalizable {
    private static final long serialVersionUID = 2035566403758848232L;
    protected static final int NULL_VALUES = -1;
    protected List<ValueData> values;
    protected int type;
    protected boolean multiValued;
    protected PersistedSize persitedSize;

    public PersistedPropertyData() {
    }

    public PersistedPropertyData(String id, QPath qpath, String parentId, int version, int type, boolean multiValued, List<ValueData> values, PersistedSize persistedSize) {
        super(id, qpath, parentId, version);
        this.values = values;
        this.type = type;
        this.multiValued = multiValued;
        this.persitedSize = persistedSize;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public List<ValueData> getValues() {
        return this.values;
    }

    @Override
    public boolean isMultiValued() {
        return this.multiValued;
    }

    @Override
    public boolean isNode() {
        return false;
    }

    public long getPersistedSize() {
        return this.persitedSize.getSize();
    }

    @Override
    public void accept(ItemDataVisitor visitor) throws RepositoryException {
        visitor.visit(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.type);
        out.writeBoolean(this.multiValued);
        out.writeLong(this.persitedSize.getSize());
        if (this.values != null) {
            int listSize = this.values.size();
            out.writeInt(listSize);
            for (int i = 0; i < listSize; ++i) {
                out.writeObject(this.values.get(i));
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.type = in.readInt();
        this.multiValued = in.readBoolean();
        this.persitedSize = new SimplePersistedSize(in.readLong());
        int listSize = in.readInt();
        if (listSize != -1) {
            this.values = new ArrayList<ValueData>();
            for (int i = 0; i < listSize; ++i) {
                this.values.add((ValueData)in.readObject());
            }
        }
    }
}

