/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.proccess.WorkerThread;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="SessionRegistry")})
public final class SessionRegistry
implements Startable {
    private final Map<String, SessionImpl> sessionsMap = new ConcurrentHashMap<String, SessionImpl>();
    public static final int DEFAULT_CLEANER_TIMEOUT = 60000;
    public static final int DEFAULT_SESSION_TIMEOUT = 600000;
    protected static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.SessionRegistry");
    private volatile SessionCleaner sessionCleaner;
    private String repositoryId;
    protected volatile long timeOut;

    @Managed
    @ManagedDescription(value="How many sessions are currently active")
    public int getSize() {
        return this.sessionsMap.size();
    }

    @Managed
    @ManagedDescription(value="The session time out")
    public long getTimeOut() {
        return this.timeOut;
    }

    @Managed
    @ManagedDescription(value="Set the session time out in seconds")
    public void setTimeOut(long timeout) {
        if (this.timeOut == timeout) {
            return;
        }
        this.sessionCleaner.halt();
        this.sessionCleaner = null;
        long l = this.timeOut = timeout <= 0L ? 0L : timeout * 1000L;
        if (this.timeOut == 0L && this.sessionCleaner != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Stop the previous session cleaner");
            }
        } else if (this.timeOut > 0L && this.sessionCleaner == null) {
            this.sessionCleaner = new SessionCleaner(this.repositoryId, 60000L, this.timeOut);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Start a new session cleaner");
            }
        }
    }

    @Managed
    @ManagedDescription(value="Perform a cleanup of timed out sessions")
    public void runCleanup() {
        if (this.sessionCleaner != null) {
            try {
                this.sessionCleaner.callPeriodically();
            }
            catch (Exception e) {
                log.warn((Object)"Could not execute the cleanup command", (Throwable)e);
            }
        }
    }

    public SessionRegistry(RepositoryEntry entry) {
        this(null, entry);
    }

    public SessionRegistry(ExoContainerContext ctx, RepositoryEntry entry) {
        if (entry != null) {
            long l = this.timeOut = entry.getSessionTimeOut() > 0L ? entry.getSessionTimeOut() : 600000L;
        }
        this.repositoryId = ctx != null ? ctx.getName() : (entry == null ? null : entry.getName());
    }

    public void registerSession(SessionImpl session) {
        this.sessionsMap.put(session.getId(), session);
    }

    public void unregisterSession(String sessionId) {
        this.sessionsMap.remove(sessionId);
    }

    public SessionImpl getSession(String sessionId) {
        return sessionId == null ? null : this.sessionsMap.get(sessionId);
    }

    public boolean isInUse(String workspaceName) {
        if (workspaceName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session in use " + this.sessionsMap.size()));
            }
            return this.sessionsMap.size() > 0;
        }
        for (SessionImpl session : this.sessionsMap.values()) {
            if (!session.getWorkspace().getName().equals(workspaceName)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session for workspace " + workspaceName + " in use. Session id:" + session.getId() + " user: " + session.getUserID()));
            }
            return true;
        }
        return false;
    }

    public void start() {
        this.sessionsMap.clear();
        if (this.timeOut > 0L) {
            this.sessionCleaner = new SessionCleaner(this.repositoryId, 60000L, this.timeOut);
        }
    }

    public void stop() {
        if (this.timeOut > 0L && this.sessionCleaner != null) {
            this.sessionCleaner.halt();
        }
        for (SessionImpl s : this.sessionsMap.values()) {
            try {
                s.logout();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Could not close the session", (Throwable)e);
            }
        }
        this.sessionsMap.clear();
    }

    public int closeSessions(String workspaceName) {
        int closedSessions = 0;
        for (SessionImpl session : this.sessionsMap.values()) {
            if (!session.getWorkspace().getName().equals(workspaceName)) continue;
            session.logout();
            ++closedSessions;
        }
        return closedSessions;
    }

    private class SessionCleaner
    extends WorkerThread {
        private final long sessionTimeOut;

        public SessionCleaner(String id, long workTime, long sessionTimeOut) {
            super(workTime);
            this.sessionTimeOut = sessionTimeOut;
            this.setName("Session Cleaner " + (Serializable)(id == null ? Long.valueOf(this.getId()) : id));
            this.setPriority(1);
            this.setDaemon(true);
            this.start();
            if (log.isDebugEnabled()) {
                log.debug((Object)("SessionCleaner instantiated name= " + this.getName() + " workTime= " + workTime + " sessionTimeOut=" + sessionTimeOut));
            }
        }

        @Override
        protected void callPeriodically() throws Exception {
            for (SessionImpl session : SessionRegistry.this.sessionsMap.values()) {
                if (session.getLastAccessTime() + this.getTimeout(session) >= System.currentTimeMillis()) continue;
                session.expire();
            }
        }

        private long getTimeout(SessionImpl session) {
            long localSessionTimeout = session.getTimeout();
            return localSessionTimeout == 0L ? this.sessionTimeOut : localSessionTimeout;
        }
    }
}

