/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.Serializable;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractRecoveryFilter;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCException;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;

public class DocNumberRecoveryFilter
extends AbstractRecoveryFilter {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.index.DocNumberRecoveryFilter");
    protected RemoteCommand getDocsNumCommand;
    protected RPCService rpcService;

    public DocNumberRecoveryFilter(SearchIndex searchIndex) {
        super(searchIndex);
        this.rpcService = this.context.getRPCService();
        this.getDocsNumCommand = this.rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberRecoveryFilter-getDocNum-" + DocNumberRecoveryFilter.this.searchIndex.getWsId() + "-" + (DocNumberRecoveryFilter.this.searchIndex.getContext().getParentHandler() == null);
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Trying to get the total amount of documents from the master");
                }
                while (DocNumberRecoveryFilter.this.searchIndex.isSuspended()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"The index has been suspended, it will wait until it is resumed");
                    }
                    DocNumberRecoveryFilter.this.searchIndex.waitForResuming();
                }
                return Integer.valueOf(DocNumberRecoveryFilter.this.searchIndex.getIndex().numDocs());
            }
        });
    }

    @Override
    public boolean accept() throws RepositoryException {
        try {
            if (!this.rpcService.isCoordinator()) {
                Integer docsNumber = (Integer)this.rpcService.executeCommandOnCoordinator(this.getDocsNumCommand, true, new Serializable[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Remote result received: {} and local is: {}", new Object[]{docsNumber, this.searchIndex.getIndex().numDocs()});
                }
                return docsNumber.intValue() != this.searchIndex.getIndex().numDocs();
            }
            return false;
        }
        catch (SecurityException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (RPCException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.rpcService.unregisterCommand(this.getDocsNumCommand);
        super.close();
    }
}

