/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractNamespaceMappings;

public class NSRegistryBasedNamespaceMappings
extends AbstractNamespaceMappings {
    private final NamespaceRegistryImpl nsReg;

    NSRegistryBasedNamespaceMappings(NamespaceRegistryImpl nsReg) {
        this.nsReg = nsReg;
    }

    @Override
    public String getNamespaceURIByPrefix(String prefix) throws NamespaceException {
        try {
            return this.nsReg.getURI(prefix);
        }
        catch (IllegalArgumentException e) {
            throw new NamespaceException("Unknown namespace prefix: " + prefix, (Throwable)e);
        }
    }

    @Override
    public String getNamespacePrefixByURI(String uri) throws NamespaceException {
        try {
            return this.nsReg.getPrefix(uri);
        }
        catch (IllegalArgumentException e) {
            throw new NamespaceException("Unknown namespace URI: " + uri, (Throwable)e);
        }
    }

    @Override
    public String[] getAllNamespacePrefixes() throws RepositoryException {
        return this.nsReg.getPrefixes();
    }
}

