/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.persistence.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.persistence.impl.ChangeLogsPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.picocontainer.Startable;

public class LiquibaseDataInitializer
implements Startable,
DataInitializer {
    private static final Log LOG = ExoLogger.getLogger(LiquibaseDataInitializer.class);
    public static final String LIQUIBASE_DATASOURCE_PARAM_NAME = "liquibase.datasource";
    public static final String LIQUIBASE_CONTEXTS_PARAM_NAME = "liquibase.contexts";
    public static final String LIQUIBASE_DEFAULT_CONTEXTS = "production";
    private String datasourceName;
    private String liquibaseContexts;
    private List<ChangeLogsPlugin> changeLogsPlugins = new ArrayList<ChangeLogsPlugin>();

    public LiquibaseDataInitializer(InitialContextInitializer initialContextInitializer, InitParams initParams) {
        this(initParams);
    }

    public LiquibaseDataInitializer(InitParams initParams) {
        if (initParams == null) {
            throw new IllegalArgumentException("No InitParams found for LiquibaseDataInitializer service. The datasource name (liquibase.datasource) should be defined at least.");
        }
        ValueParam liquibaseDatasourceNameParam = initParams.getValueParam(LIQUIBASE_DATASOURCE_PARAM_NAME);
        if (liquibaseDatasourceNameParam == null || liquibaseDatasourceNameParam.getValue() == null) {
            throw new IllegalArgumentException("Datasource name for LiquibaseDataInitializer must be defined in the init params (liquibase.datasource)");
        }
        this.datasourceName = liquibaseDatasourceNameParam.getValue();
        ValueParam liquibaseContextsParam = initParams.getValueParam(LIQUIBASE_CONTEXTS_PARAM_NAME);
        this.liquibaseContexts = liquibaseContextsParam != null && liquibaseContextsParam.getValue() != null ? liquibaseContextsParam.getValue() : LIQUIBASE_DEFAULT_CONTEXTS;
        LOG.info("LiquibaseDataInitializer created with : datasourceName={}, contexts={}", new Object[]{this.datasourceName, this.liquibaseContexts});
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public String getContexts() {
        return this.liquibaseContexts;
    }

    public void setContexts(String liquibaseContexts) {
        this.liquibaseContexts = liquibaseContexts;
    }

    public void addChangeLogsPlugin(ChangeLogsPlugin changeLogsPlugin) {
        this.changeLogsPlugins.add(changeLogsPlugin);
    }

    public void start() {
        this.initData();
    }

    public void stop() {
    }

    @Override
    public void initData() {
        this.initData(this.datasourceName);
    }

    @Override
    public void initData(String datasourceName) {
        if (this.changeLogsPlugins.isEmpty()) {
            LOG.info((Object)"No data to initialize with Liquibase");
        } else {
            LOG.info("Starting data initialization with Liquibase with datasource {0}", new Object[]{datasourceName});
            DataSource datasource = this.getDatasource(datasourceName);
            for (ChangeLogsPlugin changeLogsPlugin : this.changeLogsPlugins) {
                DataSource changelogDatasource;
                LOG.info((Object)("Processing changelogs of " + changeLogsPlugin.getName()));
                String changelogDatasourceName = changeLogsPlugin.getDatasourceName();
                if (StringUtils.isBlank((CharSequence)changelogDatasourceName)) {
                    changelogDatasource = datasource;
                    if (changelogDatasource == null) {
                        LOG.error("Data initialization of '{}' aborted because the datasource {} has not been found.", new Object[]{changeLogsPlugin.getName(), datasourceName});
                        return;
                    }
                } else {
                    changelogDatasource = this.getDatasource(changelogDatasourceName);
                    if (changelogDatasource == null) {
                        LOG.error("Data initialization of '{}' aborted because the datasource {} has not been found.", new Object[]{changeLogsPlugin.getName(), changelogDatasourceName});
                        return;
                    }
                }
                for (String changelogsPath : changeLogsPlugin.getChangelogPaths()) {
                    LOG.info((Object)("  * processing changelog " + changelogsPath));
                    this.applyChangeLog(changelogDatasource, changelogsPath);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyChangeLog(DataSource datasource, String changelogsPath) {
        Database database = null;
        try {
            database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(datasource.getConnection()));
            database.addReservedWords(Arrays.asList("RANK"));
            Liquibase liquibase = new Liquibase(changelogsPath, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.update(this.liquibaseContexts);
        }
        catch (SQLException e) {
            LOG.error((Object)("Error while getting a JDBC connection from datasource " + this.datasourceName + " - Cause : " + e.getMessage()), (Throwable)e);
        }
        catch (LiquibaseException e) {
            LOG.error((Object)("Error while applying liquibase changelogs " + changelogsPath + " - Cause : " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (database != null) {
                try {
                    database.close();
                }
                catch (DatabaseException e) {
                    LOG.error((Object)("Error while closing database connection - Cause : " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    protected DataSource getDatasource(String datasourceName) {
        DataSource dataSource = null;
        try {
            InitialContext initCtx = new InitialContext();
            dataSource = (DataSource)initCtx.lookup(datasourceName);
        }
        catch (NamingException e) {
            LOG.error((Object)("Cannot find datasource " + datasourceName + " - Cause : " + e.getMessage()), (Throwable)e);
        }
        return dataSource;
    }
}

