/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.model;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import org.exoplatform.kudos.model.KudosPeriod;
import org.exoplatform.kudos.service.utils.Utils;

public enum KudosPeriodType {
    WEEK,
    MONTH,
    QUARTER,
    SEMESTER,
    YEAR;

    public static final KudosPeriodType DEFAULT;

    public KudosPeriod getPeriodOfTime(LocalDateTime localDateTime) {
        KudosPeriod kudosPeriod = new KudosPeriod();
        YearMonth yearMonth = YearMonth.from(localDateTime);
        switch (this) {
            case WEEK: {
                LocalDateTime firstDayOfThisWeek = localDateTime.toLocalDate().with(DayOfWeek.MONDAY).atStartOfDay();
                LocalDateTime firstDayOfNextWeek = firstDayOfThisWeek.plusWeeks(1L);
                kudosPeriod.setStartDateInSeconds(Utils.timeToSeconds(firstDayOfThisWeek));
                kudosPeriod.setEndDateInSeconds(Utils.timeToSeconds(firstDayOfNextWeek));
                break;
            }
            case MONTH: {
                YearMonth currentMonth = yearMonth;
                YearMonth nextMonth = currentMonth.plusMonths(1L);
                kudosPeriod.setStartDateInSeconds(Utils.timeToSeconds(currentMonth.atDay(1).atStartOfDay()));
                kudosPeriod.setEndDateInSeconds(Utils.timeToSeconds(nextMonth.atDay(1).atStartOfDay()));
                break;
            }
            case QUARTER: {
                int monthQuarterIndex = (yearMonth.getMonthValue() - 1) / 3 * 3 + 1;
                YearMonth startQuarterMonth = YearMonth.of(yearMonth.getYear(), monthQuarterIndex);
                YearMonth endQuarterMonth = startQuarterMonth.plusMonths(3L);
                kudosPeriod.setStartDateInSeconds(Utils.timeToSeconds(startQuarterMonth.atDay(1).atStartOfDay()));
                kudosPeriod.setEndDateInSeconds(Utils.timeToSeconds(endQuarterMonth.atDay(1).atStartOfDay()));
                break;
            }
            case SEMESTER: {
                int monthSemesterIndex = (yearMonth.getMonthValue() - 1) / 6 * 6 + 1;
                YearMonth startSemesterMonth = YearMonth.of(yearMonth.getYear(), monthSemesterIndex);
                YearMonth endSemesterMonth = startSemesterMonth.plusMonths(6L);
                kudosPeriod.setStartDateInSeconds(Utils.timeToSeconds(startSemesterMonth.atDay(1).atStartOfDay()));
                kudosPeriod.setEndDateInSeconds(Utils.timeToSeconds(endSemesterMonth.atDay(1).atStartOfDay()));
                break;
            }
            case YEAR: {
                kudosPeriod.setStartDateInSeconds(Utils.timeToSeconds(Year.from(localDateTime).atDay(1).atStartOfDay()));
                kudosPeriod.setEndDateInSeconds(Utils.timeToSeconds(Year.from(localDateTime).plusYears(1L).atDay(1).atStartOfDay()));
            }
        }
        return kudosPeriod;
    }

    static {
        DEFAULT = MONTH;
    }
}

