/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import io.swagger.v3.oas.annotations.Parameter;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.IdentityType;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.addons.gamification.service.effective.LeaderboardFilter;
import org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard;
import org.exoplatform.addons.gamification.service.effective.StandardLeaderboard;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Path(value="/gamification/leaderboard")
@Produces(value={"application/json"})
@RolesAllowed(value={"users"})
public class LeaderboardEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(LeaderboardEndpoint.class);
    private static final String YOUR_CURRENT_RANK_MSG = "Your current rank";
    private static final int DEFAULT_LOAD_CAPACITY = 10;
    private static final int MAX_LOAD_CAPACITY = 100;
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected GamificationService gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);
    protected RelationshipManager relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);

    @GET
    @Path(value="rank/all")
    @RolesAllowed(value={"users"})
    public Response getAllLeadersByRank(@Context UriInfo uriInfo, @Parameter(description="Get leaderboard of user or space") @DefaultValue(value="user") @QueryParam(value="earnerType") String earnerType, @Parameter(description="Limit of identities to retrieve") @DefaultValue(value="10") @QueryParam(value="limit") int limit, @Parameter(description="Period name, possible values: WEEK, MONTH or ALL") @DefaultValue(value="ALL") @QueryParam(value="period") String period, @Parameter(description="Get only the top 10 or all") @DefaultValue(value="true") @QueryParam(value="loadCapacity") boolean loadCapacity) {
        LeaderboardFilter leaderboardFilter = new LeaderboardFilter();
        IdentityType identityType = IdentityType.getType(earnerType);
        leaderboardFilter.setIdentityType(identityType);
        if (limit <= 0) {
            limit = loadCapacity ? 10 : 100;
        }
        leaderboardFilter.setLoadCapacity(limit);
        if (StringUtils.isBlank((CharSequence)period)) {
            period = LeaderboardFilter.Period.ALL.name();
        }
        leaderboardFilter.setPeriod(period);
        leaderboardFilter.setCurrentUser(ConversationState.getCurrent().getIdentity().getUserId());
        ArrayList<LeaderboardInfo> leaderboardList = new ArrayList<LeaderboardInfo>();
        try {
            List<StandardLeaderboard> standardLeaderboards = this.gamificationService.filter(leaderboardFilter);
            if (standardLeaderboards == null) {
                return Response.ok(leaderboardList, (String)"application/json").build();
            }
            int index = 1;
            for (StandardLeaderboard standardLeaderboard : standardLeaderboards) {
                Identity identity = this.identityManager.getIdentity(standardLeaderboard.getEarnerId());
                if (identity == null) continue;
                LeaderboardInfo leaderboardInfo = new LeaderboardInfo();
                leaderboardInfo.setSocialId(identity.getId());
                String technicalId = this.computeTechnicalId(identity);
                leaderboardInfo.setTechnicalId(technicalId);
                leaderboardInfo.setScore(standardLeaderboard.getReputationScore());
                leaderboardInfo.setRemoteId(identity.getRemoteId());
                leaderboardInfo.setFullname(identity.getProfile().getFullName());
                leaderboardInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
                leaderboardInfo.setProfileUrl(identity.getProfile().getUrl());
                leaderboardInfo.setRank(index);
                leaderboardList.add(leaderboardInfo);
                ++index;
            }
            if (identityType.isUser()) {
                Date date = null;
                switch (leaderboardFilter.getPeriod()) {
                    case "WEEK": {
                        date = Date.from(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
                        break;
                    }
                    case "MONTH": {
                        date = Date.from(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                    }
                }
                LeaderboardInfo leaderboardInfo = this.buildCurrentUserRank(date, leaderboardFilter.getDomainId(), leaderboardList);
                if (leaderboardInfo != null) {
                    leaderboardList.add(leaderboardInfo);
                }
            }
            return Response.ok(leaderboardList, (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error building leaderboard ", (Throwable)e);
            return Response.serverError().entity((Object)"Error building leaderboard").build();
        }
    }

    @GET
    @Path(value="filter")
    @RolesAllowed(value={"users"})
    public Response filter(@Context UriInfo uriInfo, @QueryParam(value="domainId") Long domainId, @QueryParam(value="period") String period, @QueryParam(value="capacity") String capacity) {
        LeaderboardFilter leaderboardFilter = new LeaderboardFilter();
        leaderboardFilter.setDomainId(domainId);
        if (StringUtils.isNotBlank((CharSequence)period)) {
            leaderboardFilter.setPeriod(period);
        }
        if (StringUtils.isNotBlank((CharSequence)capacity)) {
            leaderboardFilter.setLoadCapacity(capacity);
        }
        LeaderboardInfo leaderboardInfo = null;
        try {
            List<StandardLeaderboard> standardLeaderboards = this.gamificationService.filter(leaderboardFilter);
            ArrayList<LeaderboardInfo> leaderboardInfoList = new ArrayList<LeaderboardInfo>();
            if (standardLeaderboards == null || standardLeaderboards.isEmpty()) {
                return Response.ok(leaderboardInfoList, (String)"application/json").build();
            }
            for (StandardLeaderboard standardLeaderboard : standardLeaderboards) {
                Identity identity = this.identityManager.getIdentity(standardLeaderboard.getEarnerId());
                leaderboardInfo = new LeaderboardInfo();
                String technicalId = this.computeTechnicalId(identity);
                leaderboardInfo.setTechnicalId(technicalId);
                leaderboardInfo.setSocialId(identity.getId());
                leaderboardInfo.setScore(standardLeaderboard.getReputationScore());
                leaderboardInfo.setRemoteId(identity.getRemoteId());
                leaderboardInfo.setFullname(identity.getProfile().getFullName());
                leaderboardInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
                leaderboardInfo.setProfileUrl(identity.getProfile().getUrl());
                leaderboardInfoList.add(leaderboardInfo);
            }
            Date date = null;
            switch (leaderboardFilter.getPeriod()) {
                case "WEEK": {
                    date = Date.from(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
                    break;
                }
                case "MONTH": {
                    date = Date.from(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                }
            }
            LeaderboardInfo leaderboardInfo2 = this.buildCurrentUserRank(date, leaderboardFilter.getDomainId(), leaderboardInfoList);
            if (leaderboardInfo2 != null) {
                leaderboardInfoList.add(leaderboardInfo2);
            }
            return Response.ok(leaderboardInfoList, (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.error("Error filtering leaderbaord by Doamin : {} and by Period {} ", new Object[]{leaderboardFilter.getDomainId(), leaderboardFilter.getPeriod(), e});
            return Response.serverError().entity((Object)"Error filtering leaderboard").build();
        }
    }

    @GET
    @Path(value="stats")
    @RolesAllowed(value={"users"})
    public Response stats(@Context UriInfo uriInfo, @QueryParam(value="username") String userSocialId, @QueryParam(value="period") String period) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            try {
                if (userSocialId != null) {
                    userSocialId = this.identityManager.getOrCreateIdentity("organization", userSocialId).getId();
                }
                period = StringUtils.isBlank((CharSequence)period) ? LeaderboardFilter.Period.ALL.name() : period.toUpperCase();
                Date startDate = null;
                switch (period) {
                    case "WEEK": {
                        startDate = Date.from(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
                        break;
                    }
                    case "MONTH": {
                        startDate = Date.from(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                    }
                }
                List<PiechartLeaderboard> userStats = this.gamificationService.buildStatsByUser(userSocialId, startDate, Calendar.getInstance().getTime());
                return Response.ok(userStats, (String)"application/json").build();
            }
            catch (Exception e) {
                LOG.error("Error building statistics for user {} ", new Object[]{userSocialId, e});
                return Response.serverError().entity((Object)"Error building statistics").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Unauthorized user").build();
    }

    private boolean isEarnerInTopTen(String username, List<LeaderboardInfo> leaderboard) {
        if (leaderboard.isEmpty()) {
            return false;
        }
        return leaderboard.stream().map(LeaderboardInfo::getSocialId).anyMatch(username::equals);
    }

    private String computeTechnicalId(Identity identity) {
        if (!"space".equals(identity.getProviderId())) {
            return null;
        }
        Space space = this.spaceService.getSpaceByPrettyName(identity.getRemoteId());
        return space == null ? null : space.getId();
    }

    private LeaderboardInfo buildCurrentUserRank(Date date, Long domainId, List<LeaderboardInfo> leaderboardList) {
        if (leaderboardList.isEmpty()) {
            return null;
        }
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        LeaderboardInfo leaderboardInfo = null;
        try {
            int rank;
            String earnerIdentity = this.identityManager.getOrCreateIdentity("organization", currentUser).getId();
            if (!this.isEarnerInTopTen(earnerIdentity, leaderboardList) && (rank = this.gamificationService.getLeaderboardRank(earnerIdentity, date, domainId)) > 0) {
                leaderboardInfo = new LeaderboardInfo();
                leaderboardInfo.setRank(rank);
                leaderboardInfo.setRemoteId(YOUR_CURRENT_RANK_MSG);
                leaderboardInfo.setFullname(YOUR_CURRENT_RANK_MSG);
                leaderboardInfo.setAvatarUrl(YOUR_CURRENT_RANK_MSG);
                leaderboardInfo.setProfileUrl(YOUR_CURRENT_RANK_MSG);
            }
        }
        catch (Exception e) {
            LOG.error("Error building Rank for user {} ", new Object[]{currentUser, e});
        }
        return leaderboardInfo;
    }

    public static class LeaderboardInfo {
        String technicalId;
        String socialId;
        String avatarUrl;
        String remoteId;
        String fullname;
        long score;
        String profileUrl;
        int rank;

        public int getRank() {
            return this.rank;
        }

        public void setRank(int rank) {
            this.rank = rank;
        }

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public void setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
        }

        public String getRemoteId() {
            return this.remoteId;
        }

        public void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        public String getFullname() {
            return this.fullname;
        }

        public void setFullname(String fullname) {
            this.fullname = fullname;
        }

        public long getScore() {
            return this.score;
        }

        public void setScore(long score) {
            this.score = score;
        }

        public String getProfileUrl() {
            return this.profileUrl;
        }

        public void setProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
        }

        public String getSocialId() {
            return this.socialId;
        }

        public void setSocialId(String socialId) {
            this.socialId = socialId;
        }

        public String getTechnicalId() {
            return this.technicalId;
        }

        public void setTechnicalId(String technicalId) {
            this.technicalId = technicalId;
        }
    }
}

