/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.configuration;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.service.ChallengeService;
import org.exoplatform.addons.gamification.service.dto.configuration.Challenge;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleFilter;
import org.exoplatform.addons.gamification.storage.ChallengeStorage;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ChallengeServiceImpl
implements ChallengeService {
    private static final String CHALLENGE_IS_MANDATORY_MESSAGE = "Challenge is mandatory";
    private static final Log LOG = ExoLogger.getExoLogger(ChallengeServiceImpl.class);
    private ChallengeStorage challengeStorage;
    private SpaceService spaceService;
    private ListenerService listenerService;

    public ChallengeServiceImpl(ChallengeStorage challengeStorage, SpaceService spaceService, ListenerService listenerService) {
        this.challengeStorage = challengeStorage;
        this.spaceService = spaceService;
        this.listenerService = listenerService;
    }

    @Override
    public Challenge createChallenge(Challenge challenge, String username) throws IllegalAccessException {
        if (challenge == null) {
            throw new IllegalArgumentException(CHALLENGE_IS_MANDATORY_MESSAGE);
        }
        if (challenge.getId() != 0L) {
            throw new IllegalArgumentException("challenge id must be equal to 0");
        }
        this.checkChallengePermissionAndDates(challenge, username);
        challenge = this.challengeStorage.saveChallenge(challenge, username);
        try {
            this.listenerService.broadcast("rule.created", (Object)this, (Object)challenge.getId());
        }
        catch (Exception e) {
            LOG.error("Error broadcasting challenge with id {} creation event", new Object[]{challenge.getId(), e});
        }
        return challenge;
    }

    @Override
    public Challenge createChallenge(Challenge challenge) {
        if (challenge == null) {
            throw new IllegalArgumentException(CHALLENGE_IS_MANDATORY_MESSAGE);
        }
        this.applyDomainAttributes(challenge, true);
        return this.challengeStorage.saveChallenge(challenge, "SYSTEM");
    }

    @Override
    public Challenge getChallengeById(long challengeId, String username) throws IllegalAccessException {
        Space space;
        if (challengeId <= 0L) {
            throw new IllegalArgumentException("Challenge id has to be positive integer");
        }
        Challenge challenge = this.buildChallengeById(challengeId);
        if (challenge == null) {
            return null;
        }
        String idSpace = String.valueOf(challenge.getAudience());
        if (StringUtils.isNotBlank((CharSequence)idSpace) && (space = this.spaceService.getSpaceById(idSpace)) != null && !this.spaceService.isMember(space, username) && !Utils.isSuperManager(username)) {
            throw new IllegalAccessException("user is not allowed to access to the challenge");
        }
        return challenge;
    }

    @Override
    public Challenge getChallengeById(long challengeId) {
        return this.buildChallengeById(challengeId);
    }

    @Override
    public Challenge updateChallenge(Challenge challenge, String username) throws IllegalArgumentException, ObjectNotFoundException, IllegalAccessException {
        if (challenge == null) {
            throw new IllegalArgumentException(CHALLENGE_IS_MANDATORY_MESSAGE);
        }
        if (challenge.getId() == 0L) {
            throw new IllegalArgumentException("challenge id must not be equal to 0");
        }
        Challenge oldChallenge = this.buildChallengeById(challenge.getId());
        if (oldChallenge == null) {
            throw new ObjectNotFoundException("challenge is not exist");
        }
        this.checkChallengePermissionAndDates(oldChallenge, username);
        this.checkChallengePermissionAndDates(challenge, username);
        challenge = this.challengeStorage.saveChallenge(challenge, username);
        try {
            this.listenerService.broadcast("rule.updated", (Object)this, (Object)challenge.getId());
        }
        catch (Exception e) {
            LOG.error("Error broadcasting challenge with id {} update event", new Object[]{challenge.getId(), e});
        }
        return challenge;
    }

    @Override
    public void deleteChallenge(Long challengeId, String username) throws IllegalAccessException, ObjectNotFoundException {
        Date currentDate;
        if (challengeId <= 0L) {
            throw new IllegalArgumentException("Challenge id has to be positive integer");
        }
        Challenge challenge = this.buildChallengeById(challengeId);
        if (challenge == null) {
            throw new ObjectNotFoundException("challenge doesn't exist");
        }
        if (!Utils.isChallengeManager(challenge, username)) {
            throw new IllegalAccessException("User is not allowed to delete challenge with id " + challenge.getId());
        }
        if (Utils.countAnnouncementsByChallenge(challengeId) > 0L) {
            throw new IllegalArgumentException("challenge already have announcements");
        }
        Date endDate = Utils.parseSimpleDate(challenge.getEndDate());
        if (endDate.after(currentDate = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant())) || endDate.equals(currentDate)) {
            throw new IllegalArgumentException("Challenge does not ended yet");
        }
        this.challengeStorage.deleteChallenge(challengeId, username);
        try {
            this.listenerService.broadcast("rule.deleted", (Object)this, (Object)challengeId);
        }
        catch (Exception e) {
            LOG.error("Error broadcasting chanllenge with id {} deletion event", new Object[]{challenge.getId(), e});
        }
    }

    @Override
    public List<Challenge> getChallengesByFilterAndUser(RuleFilter challengeFilter, int offset, int limit, String username) {
        List spaceIds = this.spaceService.getMemberSpacesIds(username, 0, -1);
        if (spaceIds.isEmpty()) {
            return Collections.emptyList();
        }
        this.setFilterAudience(challengeFilter, spaceIds);
        List<Long> challengesIds = null;
        challengesIds = challengeFilter.isOrderByRealizations() ? this.challengeStorage.findMostRealizedChallengesIds(challengeFilter.getSpaceIds(), offset, limit) : this.challengeStorage.findChallengesIdsByFilter(challengeFilter, offset, limit);
        ArrayList<Challenge> challenges = new ArrayList<Challenge>();
        for (Long challengeId : challengesIds) {
            Challenge challenge = this.getChallengeById(challengeId);
            challenges.add(challenge);
        }
        return challenges;
    }

    @Override
    public int countChallengesByFilterAndUser(RuleFilter challengeFilter, String username) {
        List spaceIds = this.spaceService.getMemberSpacesIds(username, 0, -1);
        if (spaceIds.isEmpty()) {
            return 0;
        }
        this.setFilterAudience(challengeFilter, spaceIds);
        return this.challengeStorage.countChallengesByFilter(challengeFilter);
    }

    @Override
    public void clearUserChallengeCache() {
        this.challengeStorage.clearCache();
    }

    private Challenge buildChallengeById(long challengeId) {
        Challenge challenge = this.challengeStorage.getChallengeById(challengeId);
        if (challenge != null) {
            this.applyDomainAttributes(challenge, false);
        }
        return challenge;
    }

    private void setFilterAudience(RuleFilter challengeFilter, List<String> spaceIds) {
        List userSpaceIds = spaceIds.stream().map(Long::parseLong).toList();
        if (CollectionUtils.isNotEmpty(challengeFilter.getSpaceIds())) {
            userSpaceIds = (List)CollectionUtils.intersection(userSpaceIds, challengeFilter.getSpaceIds());
        }
        challengeFilter.setSpaceIds(userSpaceIds);
    }

    private void checkChallengePermissionAndDates(Challenge challenge, String username) throws IllegalAccessException {
        this.applyDomainAttributes(challenge, true);
        if (!Utils.isChallengeManager(challenge, username)) {
            if (challenge.getId() > 0L) {
                throw new IllegalAccessException("User " + username + " is not allowed to update challenge with id " + challenge.getId());
            }
            throw new IllegalAccessException("User " + username + " is not allowed to create challenge that he/she can't manage");
        }
        Date startDate = Utils.parseSimpleDate(challenge.getStartDate());
        Date endDate = Utils.parseSimpleDate(challenge.getEndDate());
        if (startDate != null && endDate != null && endDate.compareTo(startDate) <= 0) {
            throw new IllegalStateException("endDate must be greater than startDate");
        }
    }

    private void applyDomainAttributes(Challenge challenge, boolean throwWhenNotfound) {
        DomainDTO domain = Utils.getChallengeDomainDTO(challenge);
        if (domain == null) {
            if (challenge.getAudience() == 0L && throwWhenNotfound) {
                throw new IllegalArgumentException("Audience is Mandatory");
            }
        } else {
            challenge.setProgramId(domain.getId());
            challenge.setProgram(domain.getTitle());
            if (CollectionUtils.isEmpty(domain.getOwners())) {
                challenge.setManagers(Collections.emptyList());
            } else {
                challenge.setManagers(new ArrayList<Long>(domain.getOwners()));
            }
            challenge.setAudience(domain.getAudienceId());
        }
    }
}

