/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.analytics.listener.social;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.model.SpaceWebNotificationItem;
import org.exoplatform.social.notification.model.SpaceWebNotificationItemUpdate;

public class AnalyticsSpaceWebNotificationListener
extends Listener<SpaceWebNotificationItem, Long> {
    private SpaceService spaceService;

    public AnalyticsSpaceWebNotificationListener(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    public void onEvent(Event<SpaceWebNotificationItem, Long> event) throws Exception {
        String userEvent;
        StatisticData statisticData;
        String eventName = event.getEventName();
        SpaceWebNotificationItem spaceWebNotificationItem = (SpaceWebNotificationItem)event.getSource();
        switch (eventName) {
            case "notification.read.item": {
                statisticData = this.buildStatisticData("markAsRead", spaceWebNotificationItem.getSpaceId(), spaceWebNotificationItem.getUserId());
                break;
            }
            case "notification.unread.item": {
                statisticData = this.buildStatisticData("markAsUnRead", spaceWebNotificationItem.getSpaceId(), spaceWebNotificationItem.getUserId());
                break;
            }
            case "notification.read.allItems": {
                statisticData = this.buildStatisticData("markAllAsRead", spaceWebNotificationItem.getSpaceId(), spaceWebNotificationItem.getUserId());
                break;
            }
            default: {
                return;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)spaceWebNotificationItem.getApplicationName())) {
            statisticData.addParameter("entityType", (Object)spaceWebNotificationItem.getApplicationName());
        }
        if (StringUtils.isNotBlank((CharSequence)spaceWebNotificationItem.getApplicationItemId())) {
            statisticData.addParameter("entityId", (Object)spaceWebNotificationItem.getApplicationItemId());
        }
        if (spaceWebNotificationItem instanceof SpaceWebNotificationItemUpdate && StringUtils.isNotBlank((CharSequence)(userEvent = ((SpaceWebNotificationItemUpdate)spaceWebNotificationItem).getUserEvent()))) {
            statisticData.addParameter("event-type", (Object)userEvent);
        }
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private StatisticData buildStatisticData(String operation, long spaceId, long userId) {
        StatisticData statisticData = this.buildStatisticData(operation, this.spaceService.getSpaceById(String.valueOf(spaceId)), userId);
        statisticData.setSpaceId(spaceId);
        return statisticData;
    }

    private StatisticData buildStatisticData(String operation, Space space, long userId) {
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("social");
        statisticData.setSubModule("spaceWebNotifications");
        statisticData.setOperation(operation);
        statisticData.setUserId(userId);
        AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        return statisticData;
    }
}

