/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.elastic.upgrade;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.es.AnalyticsESClient;
import org.exoplatform.commons.search.es.client.ElasticResponse;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ElasticsearchMigration
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(ElasticsearchMigration.class);
    private static final String OLD_INDEX_PARAM = "oldIndex";
    private static final String NEW_INDEX_PARAM = "newIndex";
    private static final String REINDEX_URI = "_reindex";
    private AnalyticsESClient analyticsESClient;
    private String oldIndex;
    private String newIndex;

    public ElasticsearchMigration(AnalyticsESClient analyticsESClient, InitParams initParams) {
        super(initParams);
        this.analyticsESClient = analyticsESClient;
        if (initParams != null) {
            this.oldIndex = initParams.getValueParam(OLD_INDEX_PARAM).getValue();
            this.newIndex = initParams.getValueParam(NEW_INDEX_PARAM).getValue();
        }
    }

    public boolean isEnabled() {
        LOG.info("ElasticsearchMigration from {} to {}", new Object[]{this.oldIndex, this.newIndex});
        return StringUtils.isNotBlank((CharSequence)this.oldIndex) && StringUtils.isNotBlank((CharSequence)this.newIndex);
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            this.reindex();
        }
        catch (Exception e) {
            LOG.info((Object)"Reindexing proceeded successfully.");
        }
    }

    public void reindex() {
        long startTime = System.currentTimeMillis();
        try {
            LOG.info("Reindexing index  from old index {} to new index {}", new Object[]{this.oldIndex, this.newIndex});
            String request = "{\n\t\"source\": {\n\t\t\"index\": \"" + this.oldIndex + "\"\n\t},\n\t\"dest\": {\n\t\t\"index\": \"" + this.newIndex + "\"\n\t}\n}";
            ElasticResponse response = this.analyticsESClient.sendHttpPostRequest(REINDEX_URI, request);
            if (response.getStatusCode() != 200) {
                throw new IllegalStateException("Cannot index alias from old index " + this.oldIndex + " to new index " + this.newIndex + ", response code = " + response.getStatusCode() + " message = " + response.getMessage());
            }
            LOG.info("Reindexation finished for index  from old index {} to new index {}", new Object[]{this.oldIndex, this.newIndex});
            LOG.info("START::Delete files index {}", new Object[]{this.oldIndex});
            this.analyticsESClient.sendHttpDeleteRequest(this.oldIndex);
            LOG.info("END::Delete old files index {} successfully", new Object[]{this.oldIndex});
            LOG.info("END::Index '{}' migration to {} successfully. The operation took {} milliseconds.", new Object[]{this.oldIndex, this.newIndex, System.currentTimeMillis() - startTime});
        }
        catch (Exception e) {
            LOG.error("An error occurred while reindexing index {} from {} ", new Object[]{this.newIndex, this.oldIndex, e});
        }
    }
}

