/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.webrtc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.webconferencing.CallProvider;
import org.exoplatform.webconferencing.CallProviderException;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.webconferencing.webrtc.WebrtcProviderException;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebrtcProvider
extends CallProvider {
    public static final String WEBRTC_TYPE = "webrtc";
    public static final String WEBRTC_TITLE = "WebRTC";
    public static final String CONFIG_RTC_CONFIGURATION = "rtc-configuration";
    protected static final String WEBRTC_SCOPE_NAME = "webconferencing.webrtc".intern();
    protected static final String KEY_RTC_SETTINGS = "rtc-settings".intern();
    public static final String VERSION = "1.0.0";
    protected static final Log LOG = ExoLogger.getLogger(WebrtcProvider.class);
    protected final SettingService settingService;
    protected final ResourceBundleService resourceBundleService;
    protected RTCConfiguration rtcConfiguration;

    public WebrtcProvider(InitParams params, SettingService settingService, ResourceBundleService resourceBundleService) throws ConfigurationException {
        super(params);
        RTCConfiguration rtcConfiguration;
        this.settingService = settingService;
        this.resourceBundleService = resourceBundleService;
        try {
            rtcConfiguration = this.readRtcConfig();
        }
        catch (Exception e) {
            LOG.error((Object)"Error reading RTC configuration", (Throwable)e);
            rtcConfiguration = null;
        }
        if (rtcConfiguration == null) {
            ObjectParameter objParam = params.getObjectParam(CONFIG_RTC_CONFIGURATION);
            if (objParam != null) {
                Object obj = objParam.getObject();
                if (obj != null && RTCConfiguration.class.isAssignableFrom(obj.getClass())) {
                    this.rtcConfiguration = (RTCConfiguration)RTCConfiguration.class.cast(obj);
                } else {
                    LOG.warn((Object)"Predefined services configuration exists but RTCConfiguration object not found.");
                    this.rtcConfiguration = new RTCConfiguration();
                }
            } else {
                this.rtcConfiguration = new RTCConfiguration();
            }
        } else {
            this.rtcConfiguration = rtcConfiguration;
        }
        for (ICEServer ices : this.rtcConfiguration.getIceServers()) {
            if (!ices.isEnabled() || !ices.isDefault()) continue;
            LOG.info((Object)("Default eXo ICE servers will be used for WebRTC calls: " + ices.getUrls().toString() + ". You can configure your own set of servers and disable the default one."));
        }
        this.logRemoteLogEnabled();
    }

    public RTCConfiguration getRtcConfiguration() {
        return this.rtcConfiguration.clone(false);
    }

    public void saveRtcConfiguration(RTCConfiguration conf) throws Exception {
        this.saveRtcConfig(conf);
        this.rtcConfiguration = conf;
        this.logRemoteLogEnabled();
    }

    public SettingsBuilder settings() {
        return new SettingsBuilder();
    }

    public UserInfo.IMInfo getIMInfo(String imId) throws CallProviderException {
        return null;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getType() {
        return WEBRTC_TYPE;
    }

    public String[] getSupportedTypes() {
        return new String[]{this.getType()};
    }

    public String getTitle() {
        return WEBRTC_TITLE;
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle res = this.resourceBundleService.getResourceBundle("locale.webrtc.WebRTCAdmin", locale);
        return res.getString("webrtc.admin.description");
    }

    public boolean isLogEnabled() {
        return this.rtcConfiguration.isLogEnabled();
    }

    public RTCConfiguration jsonToRtcConfig(JSONObject json) throws Exception {
        int iceCandidatePoolSize;
        Object iceTransportPolicy;
        JSONArray jsonIceServers = json.optJSONArray("iceServers");
        if (jsonIceServers == null) {
            throw new WebrtcProviderException("ICE Servers not found");
        }
        LinkedHashSet<ICEServer> iceServers = new LinkedHashSet<ICEServer>();
        for (int si = 0; si < jsonIceServers.length(); ++si) {
            Object credential;
            JSONObject jsonIs = jsonIceServers.getJSONObject(si);
            ICEServer ices = new ICEServer();
            boolean enabled = jsonIs.optBoolean("enabled", true);
            ices.setEnabled(enabled);
            JSONArray jsonUrls = jsonIs.optJSONArray("urls");
            if (jsonUrls == null) {
                throw new WebrtcProviderException("ICE Server has no URLs");
            }
            ArrayList<String> urls = new ArrayList<String>();
            for (int ui = 0; ui < jsonUrls.length(); ++ui) {
                Object url = jsonUrls.opt(ui);
                if (!this.isNotNull(url)) continue;
                urls.add((String)url);
            }
            if (urls.size() <= 0) {
                throw new WebrtcProviderException("ICE Server has empty URLs");
            }
            ices.setUrls(urls);
            Object username = jsonIs.opt("username");
            if (this.isNotNull(username)) {
                ices.setUsername((String)username);
            }
            if (this.isNotNull(credential = jsonIs.opt("credential"))) {
                ices.setCredential((String)credential);
            }
            iceServers.add(ices);
        }
        RTCConfiguration rtcConf = new RTCConfiguration();
        rtcConf.setIceServers(iceServers);
        Object bundlePolicy = json.opt("bundlePolicy");
        if (this.isNotNull(bundlePolicy)) {
            rtcConf.setBundlePolicy((String)bundlePolicy);
        }
        if (this.isNotNull(iceTransportPolicy = json.opt("iceTransportPolicy"))) {
            rtcConf.setIceTransportPolicy((String)iceTransportPolicy);
        }
        if ((iceCandidatePoolSize = json.optInt("iceCandidatePoolSize", -1)) >= 0) {
            rtcConf.setIceCandidatePoolSize(iceCandidatePoolSize);
        }
        boolean logEnabled = json.optBoolean("logEnabled", false);
        rtcConf.setLogEnabled(logEnabled);
        return rtcConf;
    }

    public JSONObject rtcConfigToJson(RTCConfiguration rtcConf) throws Exception {
        JSONObject json = new JSONObject();
        JSONArray jsonIces = new JSONArray();
        for (ICEServer is : rtcConf.getIceServers()) {
            JSONObject jsonIs = new JSONObject();
            jsonIs.put("enabled", is.isEnabled());
            JSONArray jsonUrls = new JSONArray();
            for (String url : is.getUrls()) {
                jsonUrls.put((Object)url);
            }
            jsonIs.put("urls", (Object)jsonUrls);
            if (is.getUsername() != null) {
                jsonIs.put("username", (Object)is.getUsername());
            }
            if (is.getCredential() != null) {
                jsonIs.put("credential", (Object)is.getCredential());
            }
            jsonIces.put((Object)jsonIs);
        }
        json.put("iceServers", (Object)jsonIces);
        if (rtcConf.getBundlePolicy() != null) {
            json.put("bundlePolicy", (Object)rtcConf.getBundlePolicy());
        }
        if (rtcConf.getIceTransportPolicy() != null) {
            json.put("iceTransportPolicy", (Object)rtcConf.getIceTransportPolicy());
        }
        if (rtcConf.getIceCandidatePoolSize() > 0) {
            json.put("iceCandidatePoolSize", rtcConf.getIceCandidatePoolSize());
        }
        json.put("logEnabled", rtcConf.isLogEnabled());
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveRtcConfig(RTCConfiguration conf) throws Exception {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            JSONObject json = this.rtcConfigToJson(conf);
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(WEBRTC_SCOPE_NAME), KEY_RTC_SETTINGS, SettingValue.create((String)json.toString()));
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RTCConfiguration readRtcConfig() throws Exception {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            SettingValue val = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(WEBRTC_SCOPE_NAME), KEY_RTC_SETTINGS);
            if (val != null) {
                String str = String.valueOf(val.getValue());
                if (str.startsWith("{")) {
                    RTCConfiguration conf;
                    RTCConfiguration rTCConfiguration = conf = this.jsonToRtcConfig(new JSONObject(str));
                    return rTCConfiguration;
                }
                LOG.warn((Object)("Cannot parse saved RTCConfiguration: " + str));
            }
            RTCConfiguration rTCConfiguration = null;
            return rTCConfiguration;
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    protected boolean isNotNull(Object obj) {
        return obj != null && obj != JSONObject.NULL;
    }

    protected void logRemoteLogEnabled() {
        if (this.rtcConfiguration != null && this.rtcConfiguration.isLogEnabled()) {
            LOG.info((Object)"Remote diagnostic log enabled for WebRTC connector");
        } else {
            LOG.info((Object)"Remote diagnostic log disabled for WebRTC connector");
        }
    }

    public static class RTCConfiguration {
        protected String bundlePolicy;
        protected int iceCandidatePoolSize;
        protected String iceTransportPolicy;
        protected Set<ICEServer> iceServers = new LinkedHashSet<ICEServer>();
        protected boolean logEnabled;

        public String getBundlePolicy() {
            return this.bundlePolicy;
        }

        public boolean isLogEnabled() {
            return this.logEnabled;
        }

        public void setLogEnabled(boolean enableLog) {
            this.logEnabled = enableLog;
        }

        public void setBundlePolicy(String bundlePolicy) {
            this.bundlePolicy = bundlePolicy;
        }

        public int getIceCandidatePoolSize() {
            return this.iceCandidatePoolSize;
        }

        public void setIceCandidatePoolSize(int iceCandidatePoolSize) {
            this.iceCandidatePoolSize = iceCandidatePoolSize;
        }

        public String getIceTransportPolicy() {
            return this.iceTransportPolicy;
        }

        public void setIceTransportPolicy(String iceTransportPolicy) {
            this.iceTransportPolicy = iceTransportPolicy;
        }

        public Set<ICEServer> getIceServers() {
            return this.iceServers;
        }

        public void setIceServers(Set<ICEServer> iceServers) {
            this.iceServers = iceServers;
        }

        RTCConfiguration clone(boolean onlyEnabled) {
            RTCConfiguration enabled = new RTCConfiguration();
            if (this.bundlePolicy != null && this.bundlePolicy.length() > 0) {
                enabled.setBundlePolicy(this.bundlePolicy);
            }
            if (this.iceTransportPolicy != null && this.iceTransportPolicy.length() > 0) {
                enabled.setIceTransportPolicy(this.iceTransportPolicy);
            }
            if (this.iceCandidatePoolSize > 0) {
                enabled.setIceCandidatePoolSize(this.iceCandidatePoolSize);
            }
            LinkedHashSet<ICEServer> iceServers = new LinkedHashSet<ICEServer>();
            if (this.iceServers.size() > 0) {
                Iterator<ICEServer> iterator = this.iceServers.iterator();
                while (iterator.hasNext()) {
                    ICEServer o;
                    ICEServer ices = o = iterator.next();
                    if (onlyEnabled && !ices.isEnabled()) continue;
                    iceServers.add(ices);
                }
            }
            enabled.setIceServers(iceServers);
            enabled.setLogEnabled(this.isLogEnabled());
            return enabled;
        }
    }

    public static class ICEServer {
        protected boolean enabled;
        protected String username;
        protected String credential;
        protected List<String> urls = new ArrayList<String>();

        public boolean isDefault() {
            return false;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getCredential() {
            return this.credential;
        }

        public void setCredential(String credential) {
            this.credential = credential;
        }

        public List<String> getUrls() {
            return this.urls;
        }

        public void setUrls(List<String> urls) {
            this.urls = urls;
        }
    }

    public class SettingsBuilder {
        protected String callUri;
        protected Locale locale;

        public SettingsBuilder callUri(String callUri) {
            this.callUri = callUri;
            return this;
        }

        public SettingsBuilder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public WebrtcSettings build() {
            WebrtcSettings settings = new WebrtcSettings(this.callUri, WebrtcProvider.this.rtcConfiguration.clone(true));
            if (this.locale != null) {
                settings.addMessages(Utils.getResourceMessages((String)"locale.webrtc.WebRTCClient", (Locale)this.locale));
            }
            return settings;
        }
    }

    public static final class DefaultICEServer
    extends ICEServer {
        @Override
        public boolean isDefault() {
            return true;
        }
    }

    public class WebrtcSettings
    extends CallProvider.Settings {
        protected final String callUri;
        protected final RTCConfiguration rtcConfiguration;

        public WebrtcSettings(String callUri, RTCConfiguration rtcConfiguration) {
            super((CallProvider)WebrtcProvider.this);
            this.callUri = callUri;
            this.rtcConfiguration = rtcConfiguration;
        }

        public String getCallUri() {
            return this.callUri;
        }

        public RTCConfiguration getRtcConfiguration() {
            return this.rtcConfiguration;
        }
    }
}

