/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.model.AgendaUserSettings;
import org.exoplatform.agenda.model.EventReminderParameter;
import org.exoplatform.agenda.service.AgendaEventConferenceService;
import org.exoplatform.agenda.service.AgendaRemoteEventService;
import org.exoplatform.agenda.service.AgendaUserSettingsService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;

public class AgendaUserSettingsServiceImpl
implements AgendaUserSettingsService {
    private static final String AGENDA_USER_SETTINGS_PARAM_KEY = "agenda.user.settings";
    private static final Scope AGENDA_USER_SETTING_SCOPE = Scope.APPLICATION.id("Agenda");
    private static final String AGENDA_USER_SETTING_KEY = "AgendaSettings";
    private AgendaEventConferenceService agendaEventConferenceService;
    private AgendaRemoteEventService agendaRemoteEventService;
    private SettingService settingService;
    private AgendaUserSettings defaultUserSettings = null;
    private List<EventReminderParameter> defaultReminders = new ArrayList<EventReminderParameter>();

    public AgendaUserSettingsServiceImpl(AgendaEventConferenceService agendaEventConferenceService, AgendaRemoteEventService agendaRemoteEventService, SettingService settingService, InitParams initParams) {
        this.agendaEventConferenceService = agendaEventConferenceService;
        this.agendaRemoteEventService = agendaRemoteEventService;
        this.settingService = settingService;
        Iterator objectParamIterator = initParams.getObjectParamIterator();
        if (objectParamIterator != null) {
            while (objectParamIterator.hasNext()) {
                ObjectParameter objectParameter = (ObjectParameter)objectParamIterator.next();
                Object objectParam = objectParameter.getObject();
                if (!(objectParam instanceof EventReminderParameter)) continue;
                EventReminderParameter eventReminderParameter = (EventReminderParameter)objectParam;
                this.defaultReminders.add(eventReminderParameter);
            }
        }
        if (initParams.containsKey((Object)AGENDA_USER_SETTINGS_PARAM_KEY)) {
            this.defaultUserSettings = (AgendaUserSettings)initParams.getObjectParam(AGENDA_USER_SETTINGS_PARAM_KEY).getObject();
        }
        if (this.defaultUserSettings == null) {
            this.defaultUserSettings = new AgendaUserSettings();
        }
    }

    public void saveAgendaUserSettings(long userIdentityId, AgendaUserSettings agendaUserSettings) {
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("User identity id is mandatory");
        }
        if (agendaUserSettings == null) {
            throw new IllegalArgumentException("Agenda settings are empty");
        }
        this.settingService.set(Context.USER.id(String.valueOf(userIdentityId)), AGENDA_USER_SETTING_SCOPE, AGENDA_USER_SETTING_KEY, SettingValue.create((String)agendaUserSettings.toString()));
    }

    public AgendaUserSettings getAgendaUserSettings(long userIdentityId) {
        SettingValue settingValue = this.settingService.get(Context.USER.id(String.valueOf(userIdentityId)), AGENDA_USER_SETTING_SCOPE, AGENDA_USER_SETTING_KEY);
        List remoteProviders = this.agendaRemoteEventService.getRemoteProviders();
        AgendaUserSettings agendaUserSettings = null;
        if (settingValue == null || settingValue.getValue() == null || StringUtils.isBlank((CharSequence)settingValue.getValue().toString())) {
            agendaUserSettings = this.defaultUserSettings.clone();
            agendaUserSettings.setReminders(this.getDefaultReminders());
            agendaUserSettings.setRemoteProviders(remoteProviders);
        } else {
            agendaUserSettings = AgendaUserSettings.fromString((String)settingValue.getValue().toString());
            agendaUserSettings.setRemoteProviders(remoteProviders);
        }
        List enabledWebConferenceProviders = this.agendaEventConferenceService.getEnabledWebConferenceProviders();
        agendaUserSettings.setWebConferenceProviders(enabledWebConferenceProviders);
        return agendaUserSettings;
    }

    public void saveUserConnector(String connectorName, String connectorUserId, long userIdentityId) {
        if (StringUtils.isBlank((CharSequence)connectorName)) {
            throw new IllegalArgumentException("connectorName parameter is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)connectorUserId)) {
            throw new IllegalArgumentException("connectorUserId parameter is mandatory");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId parameter is mandatory");
        }
        AgendaUserSettings agendaUserSettings = this.getAgendaUserSettings(userIdentityId);
        List remoteProviders = agendaUserSettings.getRemoteProviders();
        boolean enabledRemoteProvider = remoteProviders.stream().anyMatch(remoteProvider -> StringUtils.equals((CharSequence)remoteProvider.getName(), (CharSequence)connectorName) && remoteProvider.isEnabled());
        if (!enabledRemoteProvider) {
            throw new IllegalStateException("Connector " + connectorName + " is not enabled");
        }
        agendaUserSettings.setConnectedRemoteUserId(connectorUserId);
        agendaUserSettings.setConnectedRemoteProvider(connectorName);
        this.saveAgendaUserSettings(userIdentityId, agendaUserSettings);
    }

    public List<EventReminderParameter> getDefaultReminders() {
        return Collections.unmodifiableList(this.defaultReminders);
    }
}

