/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.connector;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.gamification.entities.domain.configuration.DomainEntity;
import org.exoplatform.addons.gamification.entities.domain.configuration.RuleEntity;
import org.exoplatform.addons.gamification.storage.dao.RuleDAO;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class RuleIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    public static final String INDEX = "rules";
    private static final Log LOG = ExoLogger.getLogger(RuleIndexingServiceConnector.class);
    private RuleDAO ruleDAO;
    private IdentityManager identityManager;

    public RuleIndexingServiceConnector(RuleDAO ruleDAO, IdentityManager identityManager, InitParams initParams) {
        super(initParams);
        this.ruleDAO = ruleDAO;
        this.identityManager = identityManager;
    }

    public String getConnectorName() {
        return INDEX;
    }

    public Document create(String id) {
        return this.getDocument(id);
    }

    public Document update(String id) {
        return this.getDocument(id);
    }

    public List<String> getAllIds(int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    private Document getDocument(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        LOG.debug("Index document for rule with id={}", new Object[]{id});
        RuleEntity rule = (RuleEntity)this.ruleDAO.find(Long.valueOf(id));
        if (rule == null) {
            throw new IllegalStateException("rule with id '" + id + "' not found");
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("id", Long.toString(rule.getId()));
        fields.put("title", rule.getTitle());
        fields.put("description", StringEscapeUtils.unescapeHtml((String)rule.getDescription()));
        fields.put("score", String.valueOf(rule.getScore()));
        DomainEntity domainEntity = rule.getDomainEntity();
        if (domainEntity != null) {
            fields.put("domainId", String.valueOf(domainEntity.getId()));
        }
        fields.put("event", rule.getEvent());
        fields.put("audience", String.valueOf(rule.getAudience() != null ? rule.getAudience() : 0L));
        fields.put("startDate", this.toMilliSecondsString(rule.getStartDate()));
        fields.put("endDate", this.toMilliSecondsString(rule.getEndDate()));
        fields.put("createdBy", this.getUserIdentityId(rule.getCreatedBy()));
        fields.put("createdDate", this.toMilliSecondsString(rule.getCreatedDate()));
        fields.put("lastModifiedBy", this.getUserIdentityId(rule.getLastModifiedBy()));
        fields.put("lastModifiedDate", this.toMilliSecondsString(rule.getLastModifiedDate()));
        fields.put("type", rule.getType().name());
        Document document = new Document(id, null, new Date(System.currentTimeMillis()), Collections.emptySet(), fields);
        if (CollectionUtils.isNotEmpty(rule.getManagers())) {
            document.addListField("managers", (Collection)rule.getManagers().stream().map(String::valueOf).collect(Collectors.toList()));
        }
        return document;
    }

    private String getUserIdentityId(String username) {
        Identity identity;
        String userIdentityId = "0";
        if (StringUtils.isNotBlank((String)username) && (identity = this.identityManager.getOrCreateUserIdentity(username)) != null) {
            userIdentityId = identity.getId();
        }
        return userIdentityId;
    }

    private String toMilliSecondsString(Date date) {
        return date != null ? String.valueOf(date.getTime()) : "0";
    }
}

