/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.reader;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.jcr.util.Text;

public class ContentReader {
    public static String getXSSCompatibilityContent(String content) {
        if (content != null) {
            content = StringEscapeUtils.escapeHtml((String)Text.unescapeIllegalJcrChars((String)content));
        }
        return content;
    }

    public static String getEscapeHtmlContent(String content) {
        if (content != null) {
            content = StringEscapeUtils.unescapeHtml((String)content);
            content = StringEscapeUtils.escapeHtml((String)content);
        }
        return content;
    }

    public static String getUnescapeIllegalJcrContent(String content) {
        if (content != null) {
            content = Text.unescapeIllegalJcrChars((String)content);
        }
        return content;
    }

    public static String simpleEscapeHtml(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        int length = value.length();
        StringBuilder result = new StringBuilder((int)((double)length * 1.5));
        block4: for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '<': {
                    result.append("&lt;");
                    continue block4;
                }
                case '>': {
                    result.append("&gt;");
                    continue block4;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }
}

