/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.cache;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.cache.MembershipCacheKey;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;

public class CacheableUserHandlerImpl
implements UserHandler {
    private final ExoCache<String, User> userCache;
    private final ExoCache<?, ?> userProfileCache;
    private final ExoCache membershipCache;
    private final UserHandler userHandler;

    public CacheableUserHandlerImpl(OrganizationCacheHandler organizationCacheHandler, UserHandler userHandler) {
        this.userCache = organizationCacheHandler.getUserCache();
        this.userProfileCache = organizationCacheHandler.getUserProfileCache();
        this.membershipCache = organizationCacheHandler.getMembershipCache();
        this.userHandler = userHandler;
    }

    @Override
    public void addUserEventListener(UserEventListener listener) {
        this.userHandler.addUserEventListener(listener);
    }

    @Override
    public void removeUserEventListener(UserEventListener listener) {
        this.userHandler.removeUserEventListener(listener);
    }

    @Override
    public boolean authenticate(String username, String password) throws Exception {
        boolean authenticated = this.userHandler.authenticate(username, password);
        this.userCache.remove((Serializable)((Object)username));
        return authenticated;
    }

    @Override
    public void createUser(User user, boolean broadcast) throws Exception {
        this.userHandler.createUser(user, broadcast);
    }

    @Override
    public User createUserInstance() {
        return this.userHandler.createUserInstance();
    }

    @Override
    public User createUserInstance(String username) {
        return this.userHandler.createUserInstance(username);
    }

    @Override
    public User findUserByName(String userName) throws Exception {
        return this.findUserByName(userName, UserStatus.ENABLED);
    }

    @Override
    public PageList<User> findUsers(Query query) throws Exception {
        return this.userHandler.findUsers(query);
    }

    @Override
    public PageList<User> findUsersByGroup(String groupId) throws Exception {
        return this.userHandler.findUsersByGroup(groupId);
    }

    @Override
    public PageList<User> getUserPageList(int pageSize) throws Exception {
        return this.userHandler.getUserPageList(pageSize);
    }

    @Override
    public ListAccess<User> findUsersByGroupId(String groupId) throws Exception {
        return this.userHandler.findUsersByGroupId(groupId);
    }

    @Override
    public ListAccess<User> findUsersByQuery(Query query, List<String> groupIds, UserStatus userStatus) throws Exception {
        return this.userHandler.findUsersByQuery(query, groupIds, userStatus);
    }

    @Override
    public ListAccess<User> findAllUsers() throws Exception {
        return this.userHandler.findAllUsers();
    }

    @Override
    public ListAccess<User> findUsersByQuery(Query query) throws Exception {
        return this.userHandler.findUsersByQuery(query);
    }

    @Override
    public User removeUser(String userName, boolean broadcast) throws Exception {
        User user = this.userHandler.removeUser(userName, broadcast);
        if (user != null) {
            this.userCache.remove((Serializable)((Object)userName));
            this.userProfileCache.remove((Serializable)((Object)userName));
            List memberships = this.membershipCache.getCachedObjects();
            for (Membership membership : memberships) {
                if (!membership.getUserName().equals(userName)) continue;
                this.membershipCache.remove((Serializable)((Object)membership.getId()));
                this.membershipCache.remove((Serializable)new MembershipCacheKey(membership));
            }
        }
        return user;
    }

    @Override
    public void saveUser(User user, boolean broadcast) throws Exception {
        this.userHandler.saveUser(user, broadcast);
        this.userCache.put((Serializable)((Object)user.getUserName()), (Object)user);
    }

    @Override
    public User setEnabled(String userName, boolean enabled, boolean broadcast) throws Exception {
        User result = this.userHandler.setEnabled(userName, enabled, broadcast);
        if (result != null) {
            this.userCache.put((Serializable)((Object)result.getUserName()), (Object)result);
        }
        return result;
    }

    @Override
    public User findUserByName(String userName, UserStatus status) throws Exception {
        User user = (User)this.userCache.get((Serializable)((Object)userName));
        if (user != null) {
            return status.matches(user.isEnabled()) ? user : null;
        }
        user = this.userHandler.findUserByName(userName, status);
        if (user != null) {
            this.userCache.put((Serializable)((Object)userName), (Object)user);
        }
        return user;
    }

    @Override
    public ListAccess<User> findUsersByGroupId(String groupId, UserStatus status) throws Exception {
        return this.userHandler.findUsersByGroupId(groupId, status);
    }

    @Override
    public ListAccess<User> findAllUsers(UserStatus status) throws Exception {
        return this.userHandler.findAllUsers(status);
    }

    @Override
    public ListAccess<User> findUsersByQuery(Query query, UserStatus status) throws Exception {
        return this.userHandler.findUsersByQuery(query, status);
    }
}

