/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.oauth.webui;

import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.oauth.webui.UIRegisterOAuth;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.webui.register.UIRegisterForm;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.DisabledUserException;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.config.InitParams;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.PasswordStringLengthValidator;
import org.gatein.security.oauth.spi.OAuthPrincipal;
import org.gatein.security.oauth.spi.OAuthProviderType;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/oauth/UIOAuthInvitationForm.gtmpl", events={@EventConfig(listeners={ConfirmActionListener.class}), @EventConfig(listeners={NewAccountActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIRegisterOAuth.CancelActionListener.class}, phase=Event.Phase.DECODE)}, initParams={@ParamConfig(name="skipCaptcha", value="false")})})
public class UIOAuthInvitationForm
extends UIForm {
    private static final Log log = ExoLogger.getLogger(UIOAuthInvitationForm.class);
    private static final String[] ACTIONS = new String[]{"Confirm", "NewAccount", "Cancel"};
    protected static String PASSWORD = "password";
    private String detectedUserName;

    public UIOAuthInvitationForm(InitParams params) throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PASSWORD, PASSWORD, null).setType((short)1).addValidator(PasswordStringLengthValidator.class, new Object[]{6, 30}));
        this.setActions(ACTIONS);
    }

    public String getDetectedUserName() {
        return this.detectedUserName;
    }

    public void setDetectedUserName(String detectedUserName) {
        this.detectedUserName = detectedUserName;
    }

    public static class NewAccountActionListener
    extends EventListener<UIOAuthInvitationForm> {
        public void execute(Event<UIOAuthInvitationForm> event) throws Exception {
            UIRegisterOAuth uiRegisterOAuth = (UIRegisterOAuth)((UIOAuthInvitationForm)((Object)event.getSource())).getParent();
            ((UIOAuthInvitationForm)uiRegisterOAuth.getChild(UIOAuthInvitationForm.class)).setRendered(false);
            ((UIRegisterForm)uiRegisterOAuth.getChild(UIRegisterForm.class)).setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiRegisterOAuth);
        }
    }

    public static class ConfirmActionListener
    extends EventListener<UIOAuthInvitationForm> {
        public void execute(Event<UIOAuthInvitationForm> event) throws Exception {
            PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
            HttpServletRequest request = portalRequestContext.getRequest();
            UIOAuthInvitationForm form = (UIOAuthInvitationForm)((Object)event.getSource());
            UIFormStringInput passwordInput = (UIFormStringInput)form.getChild(UIFormStringInput.class);
            String password = (String)passwordInput.getValue();
            String username = "";
            AuthenticationRegistry authRegistry = (AuthenticationRegistry)form.getApplicationComponent(AuthenticationRegistry.class);
            Authenticator authenticator = (Authenticator)form.getApplicationComponent(Authenticator.class);
            User detectedUser = (User)authRegistry.getAttributeOfClient(request, "_authenticatedPortalUserDetected");
            if (detectedUser != null) {
                username = detectedUser.getUserName();
            }
            Credential[] credentials = new Credential[]{new UsernameCredential(username), new PasswordCredential(password)};
            try {
                if (password == null || password.trim().isEmpty()) {
                    throw new LoginException("Password must not empty");
                }
                String user = authenticator.validateUser(credentials);
                if (user != null && !user.isEmpty()) {
                    OrganizationService orgService = (OrganizationService)form.getApplicationComponent(OrganizationService.class);
                    OAuthPrincipal principal = (OAuthPrincipal)authRegistry.getAttributeOfClient(request, "_authenticatedOAuthPrincipal");
                    OAuthProviderType providerType = principal.getOauthProviderType();
                    UserProfileHandler profileHandler = orgService.getUserProfileHandler();
                    UserProfile newUserProfile = profileHandler.findUserProfileByName(user);
                    if (newUserProfile == null) {
                        newUserProfile = orgService.getUserProfileHandler().createUserProfileInstance(user);
                    }
                    newUserProfile.setAttribute(providerType.getUserNameAttrName(), principal.getUserName());
                    profileHandler.saveUserProfile(newUserProfile, true);
                    authRegistry.removeAttributeOfClient(request, "_authenticatedPortalUser");
                    authRegistry.removeAttributeOfClient(request, "_authenticatedPortalUserDetected");
                    UIMaskWorkspace.CloseActionListener closePopupListener = new UIMaskWorkspace.CloseActionListener();
                    closePopupListener.execute(event);
                    SiteKey siteKey = portalRequestContext.getSiteKey();
                    NodeURL urlToRedirect = (NodeURL)portalRequestContext.createURL(NodeURL.TYPE);
                    urlToRedirect.setResource(new NavigationResource(siteKey, portalRequestContext.getNodePath()));
                    portalRequestContext.getJavascriptManager().addJavascript((CharSequence)("window.location = '" + urlToRedirect.toString() + "';"));
                }
            }
            catch (LoginException ex) {
                UIApplication uiApp = portalRequestContext.getUIApplication();
                Exception e = authenticator.getLastExceptionOnValidateUser();
                if (e != null && e instanceof DisabledUserException) {
                    uiApp.addMessage(new ApplicationMessage("UIOAuthInvitationForm.message.userDisabled", new Object[0], 0));
                } else {
                    uiApp.addMessage(new ApplicationMessage("UIOAuthInvitationForm.message.loginFailure", new Object[0], 0));
                }
            }
            catch (Exception ex) {
                log.warn((Object)ex);
                UIApplication uiApp = portalRequestContext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIOAuthInvitationForm.message.loginUnknowException", new Object[0], 0));
            }
        }
    }
}

