/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.LazyThreadFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class TimeScheduler3
implements TimeScheduler,
Runnable {
    protected final ThreadPoolExecutor pool;
    protected final BlockingQueue<Task> queue = new DelayQueue<Task>();
    protected volatile Thread runner;
    protected static final Log log = LogFactory.getLog(TimeScheduler3.class);
    protected ThreadFactory timer_thread_factory;

    public TimeScheduler3() {
        this.pool = new ThreadPoolExecutor(4, 10, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.start();
    }

    public TimeScheduler3(ThreadFactory factory, int min_threads, int max_threads, long keep_alive_time, int max_queue_size, String rejection_policy) {
        this.timer_thread_factory = factory;
        this.pool = new ThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(max_queue_size), factory, Util.parseRejectionPolicy(rejection_policy));
        this.start();
    }

    @Override
    public void setThreadFactory(ThreadFactory f) {
        this.pool.setThreadFactory(f);
    }

    @Override
    public int getMinThreads() {
        return this.pool.getCorePoolSize();
    }

    @Override
    public void setMinThreads(int size) {
        this.pool.setCorePoolSize(size);
    }

    @Override
    public int getMaxThreads() {
        return this.pool.getMaximumPoolSize();
    }

    @Override
    public void setMaxThreads(int size) {
        this.pool.setMaximumPoolSize(size);
    }

    @Override
    public long getKeepAliveTime() {
        return this.pool.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setKeepAliveTime(long time) {
        this.pool.setKeepAliveTime(time, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getCurrentThreads() {
        return this.pool.getPoolSize();
    }

    public int getQueueSize() {
        return this.pool.getQueue().size();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isShutdown() {
        return this.pool.isShutdown();
    }

    @Override
    public String dumpTimerTasks() {
        StringBuilder sb = new StringBuilder();
        for (Task task : this.queue) {
            sb.append(task);
            if (task.isCancelled()) {
                sb.append(" (cancelled)");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void execute(Runnable task) {
        this.submitToPool(task instanceof TimeScheduler.Task ? new RecurringTask(task, TaskType.dynamic, 0L, ((TimeScheduler.Task)task).nextInterval(), TimeUnit.MILLISECONDS) : new Task(task));
    }

    @Override
    public Future<?> schedule(Runnable work, long initial_delay, TimeUnit unit) {
        return this.doSchedule(new Task(work, initial_delay, unit), initial_delay);
    }

    @Override
    public Future<?> scheduleWithFixedDelay(Runnable work, long initial_delay, long delay, TimeUnit unit) {
        return this.scheduleRecurring(work, TaskType.fixed_delay, initial_delay, delay, unit);
    }

    @Override
    public Future<?> scheduleAtFixedRate(Runnable work, long initial_delay, long delay, TimeUnit unit) {
        return this.scheduleRecurring(work, TaskType.fixed_rate, initial_delay, delay, unit);
    }

    @Override
    public Future<?> scheduleWithDynamicInterval(TimeScheduler.Task work) {
        return this.scheduleRecurring(work, TaskType.dynamic, work.nextInterval(), 0L, TimeUnit.MILLISECONDS);
    }

    protected void start() {
        this.startRunner();
    }

    @Override
    public void stop() {
        this.stopRunner();
        while (!this.queue.isEmpty()) {
            for (Task entry : this.queue) {
                entry.cancel(true);
                this.queue.remove(entry);
            }
        }
        this.queue.clear();
        List<Runnable> remaining_tasks = this.pool.shutdownNow();
        for (Runnable task : remaining_tasks) {
            if (!(task instanceof Future)) continue;
            Future future = (Future)((Object)task);
            future.cancel(true);
        }
        this.pool.getQueue().clear();
        try {
            this.pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.timer_thread_factory instanceof LazyThreadFactory) {
            ((LazyThreadFactory)this.timer_thread_factory).destroy();
        }
    }

    @Override
    public void run() {
        while (Thread.currentThread() == this.runner) {
            try {
                Task entry = this.queue.take();
                this.submitToPool(entry);
            }
            catch (InterruptedException interrupted) {
            }
            catch (Throwable t) {
                log.error(Util.getMessage("FailedSubmittingTaskToThreadPool"), t);
            }
        }
    }

    protected Future<?> scheduleRecurring(Runnable work, TaskType type, long initial_delay, long delay, TimeUnit unit) {
        return this.doSchedule(new RecurringTask(work, type, initial_delay, delay, unit), initial_delay);
    }

    protected Future<?> doSchedule(Task task, long initial_delay) {
        if (task.getRunnable() == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            return null;
        }
        if (initial_delay <= 0L) {
            this.submitToPool(task);
            return task;
        }
        return this.add(task);
    }

    protected void submitToPool(Task entry) {
        try {
            this.pool.execute(entry);
        }
        catch (RejectedExecutionException rejected) {
            Thread thread = this.timer_thread_factory != null ? this.timer_thread_factory.newThread(entry, "Timer temp thread") : new Thread((Runnable)entry, "Timer temp thread");
            thread.start();
        }
    }

    protected Task add(Task task) {
        if (!this.isRunning()) {
            return null;
        }
        this.queue.add(task);
        return task;
    }

    protected boolean isRunning() {
        Thread tmp = this.runner;
        return tmp != null && tmp.isAlive();
    }

    protected synchronized void startRunner() {
        this.stopRunner();
        this.runner = this.timer_thread_factory != null ? this.timer_thread_factory.newThread(this, "Timer runner") : new Thread((Runnable)this, "Timer runner");
        this.runner.start();
    }

    protected synchronized void stopRunner() {
        Thread tmp = this.runner;
        this.runner = null;
        if (tmp != null) {
            tmp.interrupt();
            try {
                tmp.join(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.queue.clear();
    }

    protected class RecurringTask
    extends Task {
        protected final TaskType type;
        protected final long period;
        protected final long initial_delay;
        protected int cnt;

        public RecurringTask(Runnable runnable, TaskType type, long initial_delay, long delay, TimeUnit unit) {
            super(runnable, initial_delay, unit);
            this.cnt = 1;
            this.initial_delay = TimeUnit.NANOSECONDS.convert(initial_delay, TimeUnit.MILLISECONDS);
            this.type = type;
            this.period = TimeUnit.NANOSECONDS.convert(delay, unit);
            if (type == TaskType.dynamic && !(runnable instanceof TimeScheduler.Task)) {
                throw new IllegalArgumentException("Need to provide a TimeScheduler.Task as runnable when type is dynamic");
            }
        }

        @Override
        public void run() {
            if (this.isDone()) {
                return;
            }
            super.run();
            if (this.cancelled) {
                return;
            }
            this.done = false;
            switch (this.type) {
                case dynamic: {
                    long next_interval = TimeUnit.NANOSECONDS.convert(((TimeScheduler.Task)this.runnable).nextInterval(), TimeUnit.MILLISECONDS);
                    if (next_interval <= 0L) {
                        if (log.isTraceEnabled()) {
                            log.trace("task will not get rescheduled as interval is " + next_interval);
                        }
                        this.done = true;
                        return;
                    }
                    this.creation_time = System.nanoTime();
                    this.delay = next_interval;
                    break;
                }
                case fixed_rate: {
                    this.delay = this.initial_delay + (long)this.cnt++ * this.period;
                    break;
                }
                case fixed_delay: {
                    this.creation_time = System.nanoTime();
                    this.delay = this.period;
                }
            }
            TimeScheduler3.this.add(this);
        }
    }

    public static class Task
    implements Runnable,
    Delayed,
    Future {
        protected final Runnable runnable;
        protected long creation_time;
        protected long delay;
        protected volatile boolean cancelled;
        protected volatile boolean done;

        public Task(Runnable runnable) {
            this.runnable = runnable;
        }

        public Task(Runnable runnable, long initial_delay, TimeUnit unit) {
            this.creation_time = System.nanoTime();
            this.delay = TimeUnit.NANOSECONDS.convert(initial_delay, unit);
            this.runnable = runnable;
            if (runnable == null) {
                throw new IllegalArgumentException("runnable cannot be null");
            }
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        @Override
        public int compareTo(Delayed o) {
            long other_delay;
            long my_delay = this.getDelay(TimeUnit.NANOSECONDS);
            return my_delay < (other_delay = o.getDelay(TimeUnit.NANOSECONDS)) ? -1 : (my_delay == other_delay ? 0 : 1);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long remaining_time = this.delay - (System.nanoTime() - this.creation_time);
            return unit.convert(remaining_time, TimeUnit.NANOSECONDS);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean retval = !this.isDone();
            this.cancelled = true;
            return retval;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done || this.cancelled;
        }

        public Object get() throws InterruptedException, ExecutionException {
            return null;
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.isDone()) {
                return;
            }
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                log.error(Util.getMessage("FailedExecutingTask") + this.runnable, t);
            }
            finally {
                this.done = true;
            }
        }

        public String toString() {
            return this.runnable.toString();
        }
    }

    protected static enum TaskType {
        dynamic,
        fixed_rate,
        fixed_delay;

    }
}

